/*
 * Decompiled with CFR 0.152.
 */
package com.huangzhimin.contacts.email;

import com.huangzhimin.contacts.Contact;
import com.huangzhimin.contacts.email.EmailImporter;
import com.huangzhimin.contacts.exception.ContactsException;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.NameValuePair;
import org.cyberneko.html.parsers.DOMParser;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneTwoSixImporter
extends EmailImporter {
    private String loginUrl = "http://reg.163.com/login.jsp?type=1&product=mail126&url=http://entry.mail.126.com/cgi/ntesdoor?hid%3D10010102%26lightweight%3D1%26language%3D0%26style%3D3";
    private String contactsUrl = "http://tg1a64.mail.126.com/jy3/address/addrlist.jsp?sid=%sid";
    private String indexPage = null;
    private Pattern SidPattern = Pattern.compile("sid=([^\"]*)\"");

    public OneTwoSixImporter(String email, String password) {
        super(email, password, "GBK");
    }

    @Override
    public void doLogin() throws ContactsException {
        try {
            NameValuePair[] params = new NameValuePair[]{new NameValuePair("domain", "126.com"), new NameValuePair("language", "0"), new NameValuePair("user", this.getUsername(this.email)), new NameValuePair("username", this.email), new NameValuePair("password", this.password), new NameValuePair("style", "3")};
            Calendar calendar = Calendar.getInstance();
            calendar.set(2099, 11, 31);
            this.client.getState().addCookies(new Cookie[]{new Cookie(".126.com", "ntes_mail_firstpage", "normal", "/", calendar.getTime(), false), new Cookie(".126.com", "logType", "jy", "/", calendar.getTime(), false), new Cookie(".126.com", "NETEASE_SSN", this.getUsername(this.email), "/", calendar.getTime(), false), new Cookie(".126.com", "ntes_mail_noremember", "true", "/", calendar.getTime(), false)});
            String responseStr = this.doPost(this.loginUrl, params, "http://www.126.com/");
            String redirectUrl1 = this.getJSRedirectLocation(responseStr);
            redirectUrl1 = redirectUrl1.replaceAll("\\|", "%7C");
            responseStr = this.doGet(redirectUrl1, this.loginUrl);
            String redirectUrl2 = this.getJSRedirectLocation(responseStr);
            this.indexPage = this.doGet(redirectUrl2, redirectUrl1);
        }
        catch (Exception e) {
            throw new ContactsException("126 protocol has changed", e);
        }
    }

    @Override
    public List<Contact> parseContacts() throws ContactsException {
        try {
            String sid = this.getSid(this.indexPage, "folder");
            String content = this.doGet(this.contactsUrl.replaceFirst("%sid", sid) + "&gid=all");
            ArrayList<Contact> contacts = new ArrayList<Contact>();
            DOMParser parser = new DOMParser();
            InputSource is = new InputSource(new ByteArrayInputStream(content.getBytes("GBK")));
            is.setEncoding("GBK");
            parser.parse(is);
            NodeList nodes = parser.getDocument().getElementsByTagName("td");
            for (int i = 0; i < nodes.getLength(); ++i) {
                Node node = nodes.item(i);
                if (!node.getFirstChild().getNodeName().equalsIgnoreCase("input")) continue;
                String username = "";
                if (nodes.item(++i).getFirstChild().getFirstChild() != null) {
                    username = nodes.item(i).getFirstChild().getFirstChild().getNodeValue();
                }
                String email = nodes.item(++i).getFirstChild().getFirstChild().getNodeValue();
                contacts.add(new Contact(username, email));
            }
            return contacts;
        }
        catch (Exception e) {
            throw new ContactsException("126 protocol has changed", e);
        }
    }

    private String getSid(String content, String frameName) {
        int indexEnd;
        int indexMid = content.indexOf("name=\"" + frameName + "\"");
        int indexBegin = content.substring(0, indexMid).lastIndexOf("<");
        Matcher matcher = this.SidPattern.matcher(content.substring(indexBegin, indexEnd = content.indexOf("<", indexMid)));
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }
}

