/*
 * Decompiled with CFR 0.152.
 */
package com.huangzhimin.contacts.email;

import com.huangzhimin.contacts.Contact;
import com.huangzhimin.contacts.ContactsImporter;
import com.huangzhimin.contacts.exception.ContactsException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.Cookie;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.log4j.Logger;
import org.json.JSONException;
import org.json.JSONObject;
import org.json.JSONTokener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class EmailImporter
implements ContactsImporter {
    protected String email;
    protected String password;
    protected String encoding;
    protected HttpClient client;
    protected String lastUrl;
    private int max_bytes = 4096;
    protected Pattern emailPattern = Pattern.compile("^[0-9a-z]([-_.~]?[0-9a-z])*@[0-9a-z]([-.]?[0-9a-z])*\\.[a-z]{2,4}$");
    static Logger logger = Logger.getLogger((String)EmailImporter.class.getName());

    public EmailImporter(String email, String password) {
        this(email, password, "UTF-8");
    }

    public EmailImporter(String email, String password, String encoding) {
        this.email = email;
        this.password = password;
        this.encoding = encoding;
        this.client = new HttpClient();
        this.client.getParams().setCookiePolicy("compatibility");
        this.client.getParams().setParameter("http.protocol.content-charset", (Object)encoding);
        this.client.getParams().setParameter("http.protocol.single-cookie-header", (Object)true);
    }

    @Override
    public List<Contact> getContacts() throws ContactsException {
        int i = 3;
        while (true) {
            try {
                this.doLogin();
                return this.parseContacts();
            }
            catch (Exception e) {
                if (--i != 0) continue;
                throw new ContactsException(e.getMessage(), e);
            }
            break;
        }
    }

    protected abstract void doLogin() throws ContactsException;

    protected abstract List<Contact> parseContacts() throws ContactsException;

    protected String doPost(String actionUrl, NameValuePair[] params) throws HttpException, IOException {
        return this.doPost(actionUrl, params, "");
    }

    protected String doPost(String actionUrl, NameValuePair[] params, String referer) throws HttpException, IOException {
        PostMethod method = new PostMethod(actionUrl);
        this.setHeaders((HttpMethod)method);
        method.setRequestHeader("Referer", referer);
        method.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        method.setRequestBody(params);
        this.logPostRequest(method);
        this.client.executeMethod((HttpMethod)method);
        String responseStr = this.readInputStream(method.getResponseBodyAsStream());
        this.logPostResponse(method, responseStr);
        method.releaseConnection();
        if (method.getResponseHeader("Location") != null) {
            if (method.getResponseHeader("Location").getValue().startsWith("http")) {
                return this.doGet(method.getResponseHeader("Location").getValue());
            }
            return this.doGet("http://" + this.getResponseHost(method) + method.getResponseHeader("Location").getValue());
        }
        this.lastUrl = method.getURI().toString();
        return responseStr;
    }

    protected String doSoapPost(String url, String body, String soapAction) throws HttpException, IOException {
        PostMethod method = new PostMethod(url);
        this.setHeaders((HttpMethod)method);
        method.setRequestHeader("Content-Type", "text/xml; charset=utf-8");
        if (soapAction != null) {
            method.setRequestHeader("SOAPAction", soapAction);
        }
        method.setRequestEntity((RequestEntity)new StringRequestEntity(body, "text/xml", "UTF-8"));
        this.logPostRequest(method);
        this.client.executeMethod((HttpMethod)method);
        String responseStr = this.readInputStream(method.getResponseBodyAsStream());
        this.logPostResponse(method, responseStr);
        method.releaseConnection();
        this.lastUrl = method.getURI().toString();
        return responseStr;
    }

    private String getResponseHost(PostMethod method) throws URIException {
        String url = method.getURI().toString();
        return url.split("/")[2];
    }

    protected String doGet(String url) throws HttpException, IOException {
        return this.doGet(url, "");
    }

    protected String doGet(String url, String referer) throws HttpException, IOException {
        GetMethod method = new GetMethod(url);
        this.setHeaders((HttpMethod)method);
        method.setRequestHeader("Referer", referer);
        this.logGetRequest(method);
        this.client.executeMethod((HttpMethod)method);
        String responseStr = this.readInputStream(method.getResponseBodyAsStream());
        this.logGetResponse(method, responseStr);
        method.releaseConnection();
        this.lastUrl = method.getURI().toString();
        return responseStr;
    }

    protected String getJSRedirectLocation(String content) {
        String name = "window.location.replace(\"";
        int index = content.indexOf(name) + name.length();
        content = content.substring(index);
        content = content.substring(0, content.indexOf("\""));
        return content;
    }

    private void logGetRequest(GetMethod method) throws URIException {
        logger.debug((Object)("do get request: " + method.getURI().toString()));
        logger.debug((Object)("header:\n" + this.getHeadersStr(method.getRequestHeaders())));
        logger.debug((Object)("cookie:\n" + this.getCookieStr()));
    }

    private void logGetResponse(GetMethod method, String responseStr) throws URIException {
        logger.debug((Object)("do get response: " + method.getURI().toString()));
        logger.debug((Object)("header: \n" + this.getHeadersStr(method.getResponseHeaders())));
        logger.debug((Object)("body: \n" + responseStr));
    }

    protected void retainCookies(String[] cookieNames) {
        Cookie[] cookies = this.client.getState().getCookies();
        ArrayList<Cookie> retainCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (Arrays.binarySearch(cookieNames, cookie.getName()) < 0) continue;
            retainCookies.add(cookie);
        }
        this.client.getState().clearCookies();
        this.client.getState().addCookies(retainCookies.toArray(new Cookie[0]));
    }

    protected void removeCookies(String[] cookieNames) {
        Cookie[] cookies = this.client.getState().getCookies();
        ArrayList<Cookie> retainCookies = new ArrayList<Cookie>();
        for (Cookie cookie : cookies) {
            if (Arrays.binarySearch(cookieNames, cookie.getName()) >= 0) continue;
            retainCookies.add(cookie);
        }
        this.client.getState().clearCookies();
        this.client.getState().addCookies(retainCookies.toArray(new Cookie[0]));
    }

    private String readInputStream(InputStream is) throws IOException {
        byte[] b = new byte[this.max_bytes];
        StringBuilder builder = new StringBuilder();
        int bytesRead = 0;
        while ((bytesRead = is.read(b, 0, this.max_bytes)) != -1) {
            builder.append(new String(b, 0, bytesRead, this.encoding));
        }
        return builder.toString();
    }

    private void logPostRequest(PostMethod method) throws URIException {
        logger.debug((Object)("do post request: " + method.getURI().toString()));
        logger.debug((Object)("header:\n" + this.getHeadersStr(method.getRequestHeaders())));
        logger.debug((Object)("body:\n" + this.getPostBody(method.getParameters())));
        logger.debug((Object)("cookie:\n" + this.getCookieStr()));
    }

    private void logPostResponse(PostMethod method, String responseStr) throws URIException {
        logger.debug((Object)("do post response:" + method.getURI().toString()));
        logger.debug((Object)("header:\n" + this.getHeadersStr(method.getResponseHeaders())));
        logger.debug((Object)("body:\n" + responseStr));
    }

    private void setHeaders(HttpMethod method) {
        method.setRequestHeader("Accept", "text/html,application/xhtml+xml,application/xml;");
        method.setRequestHeader("Accept-Language", "zh-cn");
        method.setRequestHeader("User-Agent", "Mozilla/5.0 (Windows; U; Windows NT 5.1; zh-CN; rv:1.9.0.3) Gecko/2008092417 Firefox/3.0.3");
        method.setRequestHeader("Accept-Charset", this.encoding);
        method.setRequestHeader("Keep-Alive", "300");
        method.setRequestHeader("Connection", "Keep-Alive");
        method.setRequestHeader("Cache-Control", "no-cache");
    }

    private String getHeadersStr(Header[] headers) {
        StringBuilder builder = new StringBuilder();
        for (Header header : headers) {
            builder.append(header.getName()).append(": ").append(header.getValue()).append("\n");
        }
        return builder.toString();
    }

    private String getPostBody(NameValuePair[] postValues) {
        StringBuilder builder = new StringBuilder();
        for (NameValuePair pair : postValues) {
            builder.append(pair.getName()).append(": ").append(pair.getValue()).append("\n");
        }
        return builder.toString();
    }

    private String getCookieStr() {
        Cookie[] cookies = this.client.getState().getCookies();
        StringBuilder builder = new StringBuilder();
        for (Cookie cookie : cookies) {
            builder.append(cookie.getDomain()).append(":").append(cookie.getName()).append("=").append(cookie.getValue()).append(";").append(cookie.getPath()).append(";").append(cookie.getExpiryDate()).append(";").append(cookie.getSecure()).append(";\n");
        }
        return builder.toString();
    }

    protected String getUsername(String email) {
        return email.split("@")[0];
    }

    protected JSONObject parseJSON(String content, String startTag) throws JSONException {
        String json = content.substring(content.indexOf(startTag) + startTag.length());
        JSONTokener jsonTokener = new JSONTokener(json);
        Object o = jsonTokener.nextValue();
        return (JSONObject)o;
    }

    protected JSONObject parseJSON(String content, String startTag, String endTag) throws JSONException {
        String sub_content = content.substring(content.indexOf(startTag) + startTag.length());
        String json = sub_content.substring(0, sub_content.indexOf(endTag));
        JSONTokener jsonTokener = new JSONTokener(json);
        Object o = jsonTokener.nextValue();
        return (JSONObject)o;
    }

    protected boolean isEmailAddress(String email) {
        return this.emailPattern.matcher(email).matches();
    }

    protected String getFormUrl(String content) throws ContactsException {
        int index;
        Pattern p = Pattern.compile("^.*action=\"([^\\s\"]+)\"");
        Matcher matcher = p.matcher(content = content.substring(index, (index = content.indexOf("<form") + 5) + 500 <= content.length() ? index + 500 : content.length()));
        if (!matcher.find()) {
            throw new ContactsException("Can't find from url");
        }
        return matcher.group(1);
    }

    protected String getHrefUrl(String content, String hrefPrefix) {
        int endIndex = (content = content.substring(content.indexOf(hrefPrefix))).indexOf("\"");
        if (endIndex == -1) {
            endIndex = content.indexOf("'");
        }
        String href = content.substring(0, endIndex);
        return href;
    }

    protected String getInputValue(String name, String content) throws ContactsException {
        int end;
        int index;
        int start;
        Pattern p = Pattern.compile("^.*?value=\"([^\\s\"]+)\"");
        Matcher matcher = p.matcher(content.substring(start = content.substring((index = content.indexOf(name)) - 200 > 0 ? index - 200 : 0, index).lastIndexOf("<input") + (index - 200 > 0 ? index - 200 : 0), end = content.substring(index, index + 500 <= content.length() ? index + 500 : content.length()).indexOf(">") + index));
        if (!matcher.find()) {
            throw new ContactsException("Can't find input value");
        }
        return matcher.group(1);
    }
}

