/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.player.impl.jsa.midiport;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.MidiUnavailableException;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import org.herac.tuxguitar.gui.TuxGuitar;
import org.herac.tuxguitar.player.base.MidiPlayerException;
import org.herac.tuxguitar.player.base.MidiPort;
import org.herac.tuxguitar.player.base.MidiPortProvider;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortOut;
import org.herac.tuxguitar.player.impl.jsa.midiport.MidiPortSynthesizer;

public class MidiPortProviderImpl
implements MidiPortProvider {
    public List listPorts() throws MidiPlayerException {
        try {
            ArrayList<MidiPort> arrayList = new ArrayList<MidiPort>();
            MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
            for (int i = 0; i < infoArray.length; ++i) {
                try {
                    MidiDevice midiDevice;
                    Iterator iterator = arrayList.iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        if (!((MidiPort)iterator.next()).getKey().equals(infoArray[i].getName())) continue;
                        bl = true;
                        break;
                    }
                    if (bl || (midiDevice = MidiSystem.getMidiDevice(infoArray[i])).getMaxReceivers() == 0 || midiDevice instanceof Sequencer) continue;
                    if (midiDevice instanceof Synthesizer) {
                        arrayList.add(new MidiPortSynthesizer((Synthesizer)midiDevice));
                        continue;
                    }
                    arrayList.add(new MidiPortOut(midiDevice));
                    continue;
                }
                catch (MidiUnavailableException midiUnavailableException) {
                    throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.midi.unavailable"), (Throwable)midiUnavailableException);
                }
            }
            return arrayList;
        }
        catch (Throwable throwable) {
            throw new MidiPlayerException(TuxGuitar.getProperty((String)"jsa.error.unknown"), throwable);
        }
    }

    public void closeAll() {
    }
}

