/*
 * Decompiled with CFR 0.152.
 */
package org.herac.tuxguitar.io.midi;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.herac.tuxguitar.io.midi.MidiFileHeader;
import org.herac.tuxguitar.io.midi.base.MidiEvent;
import org.herac.tuxguitar.io.midi.base.MidiMessage;
import org.herac.tuxguitar.io.midi.base.MidiSequence;
import org.herac.tuxguitar.io.midi.base.MidiTrack;

public class MidiFileWriter
implements MidiFileHeader {
    public void write(MidiSequence midiSequence, int n, OutputStream outputStream) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
        dataOutputStream.writeInt(1297377380);
        dataOutputStream.writeInt(6);
        dataOutputStream.writeShort(n);
        dataOutputStream.writeShort(midiSequence.countTracks());
        dataOutputStream.writeShort(midiSequence.getDivisionType() == 0.0f ? midiSequence.getResolution() & Short.MAX_VALUE : 0);
        for (int i = 0; i < midiSequence.countTracks(); ++i) {
            MidiFileWriter.writeTrack(midiSequence.getTrack(i), dataOutputStream);
        }
        dataOutputStream.flush();
        dataOutputStream.close();
    }

    private static int writeTrack(MidiTrack midiTrack, DataOutputStream dataOutputStream) throws IOException {
        int n = 0;
        if (dataOutputStream != null) {
            dataOutputStream.writeInt(1297379947);
        }
        if (dataOutputStream != null) {
            dataOutputStream.writeInt(MidiFileWriter.writeTrack(midiTrack, null));
        }
        MidiEvent midiEvent = null;
        for (int i = 0; i < midiTrack.size(); ++i) {
            MidiEvent midiEvent2 = midiTrack.get(i);
            n += MidiFileWriter.writeEvent(midiEvent2, midiEvent, dataOutputStream);
            midiEvent = midiEvent2;
        }
        return n;
    }

    private static int writeEvent(MidiEvent midiEvent, MidiEvent midiEvent2, OutputStream outputStream) throws IOException {
        int n = MidiFileWriter.writeVariableLengthQuantity(midiEvent2 != null ? midiEvent.getTick() - midiEvent2.getTick() : 0L, outputStream);
        MidiMessage midiMessage = midiEvent.getMessage();
        if (midiMessage.getType() == 1) {
            n += MidiFileWriter.writeShortMessage(midiMessage, outputStream);
        } else if (midiMessage.getType() == 2) {
            n += MidiFileWriter.writeMetaMessage(midiMessage, outputStream);
        }
        return n;
    }

    private static int writeShortMessage(MidiMessage midiMessage, OutputStream outputStream) throws IOException {
        byte[] byArray = midiMessage.getData();
        int n = byArray.length;
        if (outputStream != null) {
            outputStream.write(midiMessage.getData(), 0, n);
        }
        return n;
    }

    private static int writeMetaMessage(MidiMessage midiMessage, OutputStream outputStream) throws IOException {
        int n = 0;
        byte[] byArray = midiMessage.getData();
        if (outputStream != null) {
            outputStream.write(255);
            outputStream.write(midiMessage.getCommand());
        }
        n += 2;
        n += MidiFileWriter.writeVariableLengthQuantity(byArray.length, outputStream);
        if (outputStream != null) {
            outputStream.write(byArray);
        }
        return n += byArray.length;
    }

    private static int writeVariableLengthQuantity(long l, OutputStream outputStream) throws IOException {
        boolean bl = false;
        int n = 0;
        int n2 = (int)(l >> 21 & 0x7FL);
        if (n2 != 0) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
            bl = true;
        }
        if ((n2 = (int)(l >> 14 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
            bl = true;
        }
        if ((n2 = (int)(l >> 7 & 0x7FL)) != 0 || bl) {
            if (outputStream != null) {
                outputStream.write(n2 | 0x80);
            }
            ++n;
        }
        n2 = (int)(l & 0x7FL);
        if (outputStream != null) {
            outputStream.write(n2);
        }
        return ++n;
    }
}

