-----------------------------------------------------------------------------------------------
-- Client Lua Script for Medikit
-- Copyright (c) NCsoft. All rights reserved
-----------------------------------------------------------------------------------------------
 
require "Window"
require "GameLib"
require "Unit"
require "Spell"
 
-----------------------------------------------------------------------------------------------
-- Medikit Module Definition
-----------------------------------------------------------------------------------------------
local Medikit = {}

local defaultSettings = {
	bEditMode			= false,
	bLocked				= false,
	version				= 1.2,
	bOverrideSaved 		= true,
	bHide				= false,
	
	bInnate 			= true,
	bInnateText			= false,
	sInnateText			= "HARDCORE !",
	clrInnate			= "6ECC3C",
	bInnateBar			= false,
	
	bShowCharge			= true,
	bLowAct				= true,
	clrAct				= "6ECC3C",
	clrLowAct			= "FF0000",
	clrCharge			= "FDA500",
	clrBgAct			= "353535",
	
	bFocus				= true,
	bFocusText			= true,
	bLowFocus			= true,
	clrFocus			= "FFFFFF",
	clrLowFocus			= "8000FF",
	clrBgFocus			= "353535",
	clrFocusText		= "FFFFFF",
	
	bReplaceFocus		= false,
	bCoreChange			= false,
	bCoreText			= false,
	clrMaxCore			= "E7050B",
	clrCore				= "6ECC3C",
	clrBgCore			= "353535",
	clrCoreText			= "FFFFFF",
	
	bDangerZone			= false,
	bRoE				= false,
	beProbes			= false,
	bAttrition			= false,
	bRefresh			= false,
	sEmpTimer			= 3,
	
	sFocusHeight		= 20,
	bRadius				= false,
	clrRadius			= "FFFFFF",
	bActAlert			= false
}


local mainWindow = ""
local strResource = ""
local restored = false

local posX = 0
local posY = 0
 

-----------------------------------------------------------------------------------------------
-- Initialization
-----------------------------------------------------------------------------------------------
function Medikit:new(o)
    o = o or {}
    setmetatable(o, self)
    self.__index = self 

    -- initialize variables here

	self.run 			= 0
	self.att			= 0
	self.inCombat		= false

    return o
end

function Medikit:Init()
    Apollo.RegisterAddon(self)
end
 

-----------------------------------------------------------------------------------------------
-- Medikit OnLoad
-----------------------------------------------------------------------------------------------

function Medikit:OnLoad()
	Apollo.RegisterSlashCommand("medikit", "SlashMedikit", self)
	Apollo.LoadSprites("MediText.xml")

	Apollo.RegisterEventHandler("CharacterCreated", "OnCharacterCreated", self)
	Apollo.RegisterEventHandler("VarChange_FrameCount", "OnFrame", self)
	Apollo.RegisterEventHandler("UnitEnteredCombat", "OnEnteredCombat", self)
	Apollo.RegisterEventHandler("WindowManagementReady", "OnWindowManagementReady", self)
	
	self.runningTimer = ApolloTimer.Create(1, true, "OnRunTimer", self); 	self.runningTimer:Stop()
	self.attTimer = ApolloTimer.Create(1, true, "OnAttTimer", self); 		self.attTimer:Stop()
	self.empTimer = ApolloTimer.Create(3, true, "onEmpTimer", self);		self.empTimer:Stop()
	
	
	self.bRestored = false
	self.nTryCount = 0
	
		
	if GameLib.GetPlayerUnit() then
		self:OnCharacterCreated()
	end
end

function Medikit:OnConfigure()
	if self.bIsLoaded then
		if self.SettingsOld == nil then
			self.SettingsOld = self:CopyTable(self.Settings)
		end

		self:SetOptions()
		self.wndSettingsForm:Show(true)
		self.Settings.bEditMode = true
	else
		Print("Medikit is not available for your class!!")
	end
end

function Medikit:OnCharacterCreated()
	local unitPlayer = GameLib.GetPlayerUnit()
	
	if unitPlayer:GetClassId() ~= GameLib.CodeEnumClass.Medic then
		return
	end
	
	if not self.bRestored then
		if self.Settings == nil then
			Print ("Medikit no settings, loading default settings")
			self:ResetSettings()
		end
	end


	bLoad = true
	
	
	if bLoad then
	self.xmlDoc 			= XmlDoc.CreateFromFile("Medikit.xml")
	self.wndMain 			= Apollo.LoadForm(self.xmlDoc, "Container", 'FixedHudStratum', self)
	self.Overlay 			= Apollo.LoadForm(self.xmlDoc, "Overlay", 'InWorldHudStratum', self)
	self.Alert				= Apollo.LoadForm(self.xmlDoc, "LowActAlert", nil, self)
	
	self.wndFocusBar		= self.wndMain:FindChild("ManaBar")
	self.wndInnateBar		= self.wndMain:FindChild("InnateBar")
	self.wndInnate			= self.wndMain:FindChild("Innate")
	self.wndCoreBar			= self.wndMain:FindChild("CoreDamage")

	mainWindow = self.wndMain
	

	
	
	self.wndSettingsForm = Apollo.LoadForm(self.xmlDoc, "SettingsForm", nil, self)
	self.wndSettingsMain = Apollo.LoadForm(self.xmlDoc, "SettingsMain", self.wndSettingsForm:FindChild("SettingsContainer"), self)
	self.wndSettingsForm:Show(false)
	
	if eLevel == GameLib.CodeEnumAddonSaveLevel.Character then
		if self.Settings.version ~= defaultSettings.version then

			local newData = {}
			for k,v in pairs(defaultSettings) do
				newData[k] = tData[k] or v
			end
			self.Settings.version = defaultSettings.version
			self.Settings = newData
		else 
			self.Settings = tData
		end
		self.bRestored = true
		self:ApplySettings()
	
	end
	
	self:ApplySettings()	
	Medikit:LoadMedic ()
	
	self.bIsLoaded = true
	end
end


function Medikit:OnFrame()

	local unitPlayer = GameLib.GetPlayerUnit()
	if not unitPlayer then
		return
	elseif unitPlayer:GetClassId() ~= GameLib.CodeEnumClass.Medic then
		if self.wndMain then
			self.wndMain:Destroy()
		end
		return
	end

	if not self.wndMain:IsValid() then
		return
	end

	if not self.wndMain:IsVisible() then
		self.wndMain:Show(true)
	end
		
	--self:ApplySettings()
	

	-- Creates the Medic Resource Bar
	
	self:DrawMedic(unitPlayer)
	
	if self.Settings.bHide == true then
		if self.inCombat == true then
			self.wndMain:Show(true)
		else
			self.wndMain:Show(false)
		end
	end
	
	
		
	-- Core Damage Bar Call
	self:CoreDamage(unitPlayer)

	-- Setting the Focus Number and Bar
	local nFocusCurr = unitPlayer:GetFocus() 
	local nFocusMax = unitPlayer:GetMaxFocus() 
	self.wndFocusBar:SetMax (nFocusMax)
	self.wndFocusBar:SetProgress(nFocusCurr)
	
	if nFocusCurr <= 250 then
		self.wndFocusBar:SetBarColor ("FF"..self.Settings.clrLowFocus)
	else
		self.wndFocusBar:SetBarColor ("FF"..self.Settings.clrFocus)
	end
	
	self.wndFocusBar:FindChild("ManaText"):SetText(math.floor(nFocusCurr).." / "..nFocusMax)
	
	-- Setting the Innate Effect
	self:Innate()
	
	
	-- Sets the buff tracking
	if self.Settings.bDangerZone then
	self:DangerZone(unitPlayer)
	else if self.Settings.bRoE then
	self:Running(unitPlayer)
	end end
	
	if self.Settings.beProbes then
	self:Empowering(unitPlayer)
	else if self.Settings.bAttrition then
	self:Attrition(unitPlayer)
	end end
		
	self.bIsLoaded = true
	
end


function Medikit:LoadMedic()
	local styleWnd = mainWindow:FindChild("Medic");
	
	self.tCores = {} -- windows
	
	for idx = 1,4 do
		self.tCores[idx] = {
			wndCore =  Apollo.LoadForm("Medikit.xml", "MedicCore",  styleWnd:FindChild("CoreContainer" .. idx), self)			
		}
		self.tCores[idx].wndCore:FindChild("PowerSurge"):SetMax(30)
		self.tCores[idx].wndCore:FindChild("PowerSurge"):SetProgress(0)
	end
end

function Medikit:DrawMedic(unitPlayer)
	local myCores = self.tCores
	
	local nResourceCurr = unitPlayer:GetResource(1)
	local nResourceMax = unitPlayer:GetMaxResource(1)

	local myBuffs = unitPlayer:GetBuffs()
	local buffCount = 0
	local goodBuffs = myBuffs["arBeneficial"]
	
	for key, value in pairs(goodBuffs) do
		if value["splEffect"]:GetId() == 42569 then -- POWER CHARGE = 42569 
			buffCount = value.nCount
		end
	end
	
	for idx = 1, #myCores do
		
		if idx <= nResourceCurr then
			myCores[idx].wndCore:FindChild("On"):Show(true)
			myCores[idx].wndCore:FindChild("PowerSurge"):Show(false)
		else
			myCores[idx].wndCore:FindChild("On"):Show(false)
			myCores[idx].wndCore:FindChild( "PowerSurge"):Show(true)
			
			myCores[idx].wndCore:FindChild("PowerSurge"):Show(self.Settings.bShowCharge)
			if self.Settings.bShowCharge == true then
				myCores[idx].wndCore:FindChild("PowerSurge"):SetBarColor("ff"..self.Settings.clrCharge)
			end
				
						
			if idx == nResourceCurr + 1 then
				myCores[idx].wndCore:FindChild("PowerSurge"):SetProgress(buffCount*10, 50)
			else
				myCores[idx].wndCore:FindChild("PowerSurge"):SetProgress(0, 90)
			end
		end
		
		-- Changes color when we have only 1 actuator left
		if self.Settings.bLowAct == true then
			if nResourceCurr == 1 then
				myCores[idx].wndCore:FindChild("On"):SetBGColor ("ff"..self.Settings.clrLowAct)
			else
				myCores[idx].wndCore:FindChild("On"):SetBGColor ("ff"..self.Settings.clrAct)
			end
		else
			myCores[idx].wndCore:FindChild("On"):SetBGColor ("ff"..self.Settings.clrAct)
		end
		
		if self.Settings.bEditMode == false then
			if self.Settings.bActAlert == true then
				if nResourceCurr <= 1 then
					self.Alert:Show(not self.Settings.ActAlert)
				else
					self.Alert:Show(self.Settings.ActAlert)
				end
			else
				self.Alert:Show(self.Settings.ActAlert)
			end
		end		
				
	end
end

function Medikit:Innate()
	local bInnate 		= GameLib.IsCurrentInnateAbilityActive()
	local innate 		= GameLib.GetClassInnateAbilitySpells().tSpells[1]
	local MaxDuration	= innate:GetCooldownTime()
	local Time			= innate:GetCooldownRemaining()
	local TimeInnate	= 8-(30-Time) -- calculates the time we have on Energize Buff
	
	self.wndInnateBar:Show(self.Settings.bInnateBar)
	self.wndInnateBar:SetMax(8)
	self.wndInnateBar:SetProgress(TimeInnate, 24)
	self.wndMain:FindChild("Sigil"):DestroyAllPixies()
	
	if bInnate then
		self.wndInnate:Show(bInnate)
			self.wndMain:FindChild("Sigil"):AddPixie({
  												bLine = false,
 												strSprite = "CM_SpellslingerSprites:sprSlinger_LargeSigil_InCombat",
  												cr = "FF"..self.Settings.clrInnate,
  												loc = {
    												fPoints = {0.5,0,0.5,1},
   													nOffsets = {-106,0,106,0}
  												},
  											})		
	else 
		self.wndInnate:Show(bInnate)
	end
	

end

function Medikit:CoreDamage(unitPlayer)
	local coreCount 	= 0 
	local BarColor		= "red"
	local coreTime		= 0

	for key , value in pairs(GameLib.GetPlayerUnit():GetBuffs().arBeneficial) do
		if value["splEffect"]:GetId() == 60803 then -- CORE DAMAGE = 60803
			coreCount 			= value.nCount
			coreTime			= value.fTimeRemaining
		end
	end
	
	self.wndCoreBar:FindChild("CoreText"):SetText(coreCount)
	
	if coreCount == 4 and self.Settings.bCoreChange == true then
		BarColor = "FF"..self.Settings.clrMaxCore
	else
		BarColor = "FF"..self.Settings.clrCore
	end
	
	self.wndCoreBar:SetBarColor (BarColor)
	self.wndCoreBar:SetMax(5)
	self.wndCoreBar:SetProgress(coreTime, 25)
end
	
function Medikit:DangerZone(unitPlayer)
	local found			= false
	local time			= 0

	for key , value in pairs(GameLib.GetPlayerUnit():GetBuffs().arBeneficial) do
		if value["splEffect"]:GetId() == 60918 then -- DANGER ZONE = 60918
			found = true
			time  = value.fTimeRemaining
		end
	end
	
		self.wndMain:FindChild("BuffLeft"):Show(found)
		self.wndMain:FindChild("RunningIcon"):Show(false)
		self.wndMain:FindChild("DangerIcon"):Show(found)
		self.wndMain:FindChild("BuffLeftProgress"):Show(found)
		self.wndMain:FindChild("BuffLeftProgress"):SetMax(8)
		self.wndMain:FindChild("BuffLeftProgress"):SetProgress(time, 25)
		self.wndMain:FindChild("CdTextLeft"):SetText(math.floor((time * 10) + 0.5) / (10).." s")
end

function Medikit:Empowering(unitPlayer)
	local found			= false
	local time			= 0

	for key , value in pairs(GameLib.GetPlayerUnit():GetBuffs().arBeneficial) do
		if value["splEffect"]:GetName() == "Empowering Probes" then
			found 		= true
			time  		= value.fTimeRemaining
		end
	end
		self.wndMain:FindChild("BuffRight"):Show(found)
		self.wndMain:FindChild("eProbesIcon"):Show(found)
		self.wndMain:FindChild("AttritionIcon"):Show(false)
		self.wndMain:FindChild("BuffRightProgress"):Show(found)
		self.wndMain:FindChild("BuffRightProgress"):SetMax(10)
		self.wndMain:FindChild("BuffRightProgress"):SetProgress(time, 25)
		self.wndMain:FindChild("CdTextRight"):SetText(math.floor((time * 10) + 0.5) / (10).." s")
end

function Medikit:Running(unitPlayer)
	local found			= false

	for key , value in pairs(GameLib.GetPlayerUnit():GetBuffs().arBeneficial) do
		if value["splEffect"]:GetId() == 60674 then -- RUNNING ON EMPTY = 60674
			found = true
			self.runningTimer:Start()
		end		
	end
			self.wndMain:FindChild("TriggerEffectLeft"):Show(found)
			self.wndMain:FindChild("BuffLeft"):Show(true)
			self.wndMain:FindChild("RunningIcon"):Show(true)
			self.wndMain:FindChild("DangerIcon"):Show(false)
			-- sets the Running on Empty icon invisible when is ready
			if self.run == 0 then
				self.wndMain:FindChild("BuffLeft"):Show(false)
			else
				self.wndMain:FindChild("RunningIcon"):Show(true)
				self.wndMain:FindChild("BuffLeftProgress"):Show(true)
				self.wndMain:FindChild("BuffLeftProgress"):SetMax(140)
				self.wndMain:FindChild("BuffLeftProgress"):SetProgress((140-self.run), 360)
				self.wndMain:FindChild("CdTextLeft"):SetText((140-self.run).." s")
			end
end

function Medikit:Attrition(unitPlayer)
local found 			= false

	for key , value in pairs(GameLib.GetPlayerUnit():GetBuffs().arBeneficial) do
		if value["splEffect"]:GetId() == 60756 then -- ATTRITION = 60756
			found = true
		end		
	end

		self.wndMain:FindChild("BuffRight"):Show(true)
		self.wndMain:FindChild("AttritionIcon"):Show(true)
		self.wndMain:FindChild("TriggerEffectRight"):Show(found)
	

		if self.inCombat then
				self.attTimer:Start()
				self.wndMain:FindChild("BuffRightProgress"):SetMax(120)
				self.wndMain:FindChild("BuffRightProgress"):SetProgress((120-self.att), 360)
				self.wndMain:FindChild("CdTextRight"):SetText((120-self.att).." s")
				self.wndMain:FindChild("TriggerEffectRight"):Show(found)
				self.wndMain:FindChild("BuffRightProgress"):Show(not found)
		else
			self.wndMain:FindChild("BuffRight"):Show(false)
		end
end

function Medikit:onEmpTimer(unitPlayer)
	local found			= false

	
	for key, value in pairs(GameLib.GetPlayerUnit():GetBuffs().arBeneficial) do
		if value["splEffect"]:GetId() == 58984 then -- EMPOWRING AURA = 58984
			found = true
		end
	end
	
	if found then
		return
	else
		if not GameLib.GetPlayerUnit():IsDead() then
			local CurLas = ActionSetLib.GetCurrentActionSet()
			ActionSetLib.RequestActionSetChanges(CurLas)

		else
			return
		end
	end
end

function Medikit:EmpoweringRadius(unitPlayer)
	local rad					= math.rad
	local sin					= math.sin
	local cos					= math.cos
	
	local unit 					= GameLib.GetPlayerUnit()
	local uface 				= unit:GetFacing()
	local uangle 				= math.atan2(uface.x, uface.z)
	local tPoss 				= unit:GetPosition()
	
	local originPositionVector	= Vector3.New(tPoss.x,tPoss.y,tPoss.z)
	
	local firstVector			= Vector3.New(tPoss.x+(11)*sin(uangle), tPoss.y, tPoss.z+(11)*cos(uangle))
	local previousVector		= firstVector
	local startPoint 			= GameLib.WorldLocToScreenPoint(previousVector)
	local pPoints 				= {0,0,0,0}

	local color					= "FF"..self.Settings.clrRadius
	
	for i=1, 8 do 
		local rotation_point 		= uangle + rad(-360 / (8 / i))
		
		local currentVector 		= Vector3.New(tPoss.x+(11)*sin(rotation_point), tPoss.y, tPoss.z+(11)*cos(rotation_point))
		local endPoint 				= GameLib.WorldLocToScreenPoint(currentVector)

		self.Overlay:AddPixie({
  			bLine = true, fWidth = 2,
 			cr = color,
  			loc = {
    			fPoints = pPoints,
    			nOffsets = {startPoint.x, startPoint.y, endPoint.x, endPoint.y}
 				  },
		})
		previousVector				= currentVector
		startPoint 					= endPoint
	
	end
end
	
	
-----------------------------------------------------------------------------------------------
-- Medikit Events
-----------------------------------------------------------------------------------------------

function Medikit:OnRunTimer()
	self.run=self.run+1
	if self.run == 140 then
		self.runningTimer:Stop()
		self.run = 0
	end
end

function Medikit:OnAttTimer()
	self.att=self.att+1
	if self.att == 120 or not self.inCombat then
		self.attTimer:Stop()
		self.att = 0
	end
end

function Medikit:OnEnteredCombat(unit, bInCombat)
	if unit:GetName() == GameLib.GetPlayerUnit():GetName() then
		self.inCombat = bInCombat
	end
end



-----------------------------------------------------------------------------------------------
-- Medikit Functions
-----------------------------------------------------------------------------------------------

function Medikit:SetOptions()
	local wnd = self.wndSettingsMain
	
	self.wndSettingsForm:FindChild("LockBtn"):SetCheck(self.Settings.bLocked)
	self.wndSettingsForm:FindChild("HideBtn"):SetCheck(self.Settings.bHide)
	
	-- Innate
	wnd:FindChild("InnateBtn"):SetCheck(self.Settings.bInnate)
	wnd:FindChild("InnateTextBtn"):SetCheck(self.Settings.bInnateText)
	wnd:FindChild("InnateBarBtn"):SetCheck(self.Settings.bInnateBar)
	wnd:FindChild("InnateMsg"):SetText(self.Settings.sInnateText)
	wnd:FindChild("InnateHex"):SetText(self.Settings.clrInnate)
	wnd:FindChild("InnateHex"):SetTextColor("FF"..self.Settings.clrInnate)
	
	-- Resource
	wnd:FindChild("PowerBtn"):SetCheck(self.Settings.bShowCharge)
	wnd:FindChild("LowActBtn"):SetCheck(self.Settings.bLowAct)
	wnd:FindChild("ActHex"):SetText(self.Settings.clrAct)
	wnd:FindChild("ActHex"):SetTextColor("FF"..self.Settings.clrAct)
	wnd:FindChild("LowActHex"):SetText(self.Settings.clrLowAct)
	wnd:FindChild("LowActHex"):SetTextColor("FF"..self.Settings.clrLowAct)
	wnd:FindChild("PowerChargeHex"):SetText(self.Settings.clrCharge)
	wnd:FindChild("PowerChargeHex"):SetTextColor("FF"..self.Settings.clrCharge)
	wnd:FindChild("ActBGHex"):SetText(self.Settings.clrBgAct)
	wnd:FindChild("ActBGHex"):SetTextColor("FF"..self.Settings.clrBgAct)
	
	-- Focus
	wnd:FindChild("FocusBtn"):SetCheck(self.Settings.bFocus)
	wnd:FindChild("FocusTextBtn"):SetCheck(self.Settings.bFocusText)
	wnd:FindChild("LowFocusBtn"):SetCheck(self.Settings.bLowFocus)
	wnd:FindChild("FocusHex"):SetText(self.Settings.clrFocus)
	wnd:FindChild("FocusHex"):SetTextColor("FF"..self.Settings.clrFocus)
	wnd:FindChild("LowFocusHex"):SetText(self.Settings.clrLowFocus)
	wnd:FindChild("LowFocusHex"):SetTextColor("FF"..self.Settings.clrLowFocus)
	wnd:FindChild("FocusBGHex"):SetText(self.Settings.clrBgFocus)
	wnd:FindChild("FocusBGHex"):SetTextColor("FF"..self.Settings.clrBgFocus)
	wnd:FindChild("FocusTextHex"):SetText(self.Settings.clrFocusText)
	wnd:FindChild("FocusTextHex"):SetTextColor("FF"..self.Settings.clrFocusText)
	
	-- Core Damage
	wnd:FindChild("CoreBtn"):SetCheck(self.Settings.bReplaceFocus)
	wnd:FindChild("HighStacksBtn"):SetCheck(self.Settings.bCoreChange)
	wnd:FindChild("CDTextBtn"):SetCheck(self.Settings.bCoreText)
	wnd:FindChild("CDHex"):SetText(self.Settings.clrCore)
	wnd:FindChild("CDHex"):SetTextColor("FF"..self.Settings.clrCore)
	wnd:FindChild("HighCDHex"):SetText(self.Settings.clrMaxCore)
	wnd:FindChild("HighCDHex"):SetTextColor("FF"..self.Settings.clrMaxCore)
	wnd:FindChild("CDBGHex"):SetText(self.Settings.clrBgCore)
	wnd:FindChild("CDBGHex"):SetTextColor("FF"..self.Settings.clrBgCore)
	wnd:FindChild("CDTextHex"):SetText(self.Settings.clrCoreText)
	wnd:FindChild("CDTextHex"):SetTextColor("FF"..self.Settings.clrCoreText)
	
	-- Buffs Tracking
	wnd:FindChild("DangerBtn"):SetCheck(self.Settings.bDangerZone)
	wnd:FindChild("RoEBtn"):SetCheck(self.Settings.bRoE)
	wnd:FindChild("eProbesBtn"):SetCheck(self.Settings.beProbes)
	wnd:FindChild("AttritionBtn"):SetCheck(self.Settings.bAttrition)
	wnd:FindChild("EmpoweringBtn"):SetCheck(self.Settings.bRefresh)
	wnd:FindChild("RefreshTime"):SetText(self.Settings.sEmpTimer)
	
	-- Misc Settings
	wnd:FindChild("FocusPercent"):SetText(self.Settings.sFocusHeight)
	wnd:FindChild("RadiusBtn"):SetCheck(self.Settings.bRadius)
	wnd:FindChild("RadiusHex"):SetTextColor("FF"..self.Settings.clrRadius)
	wnd:FindChild("RadiusHex"):SetText(self.Settings.clrRadius)
	wnd:FindChild("LowActAlertBtn"):SetCheck(self.Settings.bActAlert)
end	


function Medikit:GetOptions()
	local wnd = self.wndSettingsMain
	
	self.Settings.bLocked		= self.wndSettingsForm:FindChild("LockBtn"):IsChecked()
	self.Settings.bHide			= self.wndSettingsForm:FindChild("HideBtn"):IsChecked()
	
	-- Innate
	self.Settings.bInnate 		= wnd:FindChild("InnateBtn"):IsChecked()
	self.Settings.bInnateText	= wnd:FindChild("InnateTextBtn"):IsChecked()
	self.Settings.bInnateBar	= wnd:FindChild("InnateBarBtn"):IsChecked()
	self.Settings.sInnateText	= wnd:FindChild("InnateMsg"):GetText()
	self.Settings.clrInnate		= wnd:FindChild("InnateHex"):GetText()
	
	-- Resource
	self.Settings.bShowCharge	= wnd:FindChild("PowerBtn"):IsChecked()
	self.Settings.bLowAct		= wnd:FindChild("LowActBtn"):IsChecked()
	self.Settings.clrAct		= wnd:FindChild("ActHex"):GetText()
	self.Settings.clrLowAct		= wnd:FindChild("LowActHex"):GetText()
	self.Settings.clrCharge		= wnd:FindChild("PowerChargeHex"):GetText()
	self.Settings.clrBgAct		= wnd:FindChild("ActBGHex"):GetText()
	
	-- Focus
	self.Settings.bFocus		= wnd:FindChild("FocusBtn"):IsChecked()
	self.Settings.bFocusText	= wnd:FindChild("FocusTextBtn"):IsChecked()
	self.Settings.bLowFocus		= wnd:FindChild("LowFocusBtn"):IsChecked()
	self.Settings.clrFocus		= wnd:FindChild("FocusHex"):GetText()
	self.Settings.clrLowFocus	= wnd:FindChild("LowFocusHex"):GetText()
	self.Settings.clrBgFocus	= wnd:FindChild("FocusBGHex"):GetText()
	self.Settings.clrFocusText	= wnd:FindChild("FocusTextHex"):GetText()
	
	-- Core Damage
	self.Settings.bReplaceFocus	= wnd:FindChild("CoreBtn"):IsChecked()
	self.Settings.bCoreChange	= wnd:FindChild("HighStacksBtn"):IsChecked()
	self.Settings.bCoreText		= wnd:FindChild("CDTextBtn"):IsChecked()
	self.Settings.clrCore		= wnd:FindChild("CDHex"):GetText()
	self.Settings.clrMaxCore	= wnd:FindChild("HighCDHex"):GetText()
	self.Settings.clrBgCore		= wnd:FindChild("CDBGHex"):GetText()
	self.Settings.clrcoreText	= wnd:FindChild("CDTextHex"):GetText()
	
	-- Buffs Tracking
	self.Settings.bDangerZone	= wnd:FindChild("DangerBtn"):IsChecked()
	self.Settings.bRoE			= wnd:FindChild("RoEBtn"):IsChecked()
	self.Settings.beProbes		= wnd:FindChild("eProbesBtn"):IsChecked()
	self.Settings.bAttrition	= wnd:FindChild("AttritionBtn"):IsChecked()
	self.Settings.bRefresh		= wnd:FindChild("EmpoweringBtn"):IsChecked()
	self.Settings.sEmpTimer		= wnd:FindChild("RefreshTime"):GetText()
	
	-- Misc Settings
	self.Settings.sFocusHeight	= wnd:FindChild("FocusPercent"):GetText()
	self.Settings.clrRadius		= wnd:FindChild("RadiusHex"):GetText()
	self.Settings.bRadius		= wnd:FindChild("RadiusBtn"):IsChecked()
	self.Settings.bActAlert		= wnd:FindChild("LowActAlertBtn"):IsChecked()
end	

function Medikit:ApplySettings()
	if self.Settings == nil then
		return
	end

	local tSettings = self.Settings
	
	self.Alert:SetStyle ("Sizable", not self.Settings.bLocked)
	self.Alert:SetStyle ("Moveable", not self.Settings.bLocked)
	self.Alert:SetStyle ("IgnoreMouse", self.Settings.bLocked)
	
	self.wndMain:SetStyle ("Sizable", not self.Settings.bLocked)
	self.wndMain:SetStyle ("Moveable", not self.Settings.bLocked)
	self.wndMain:SetStyle ("IgnoreMouse", self.Settings.bLocked)
	
	-- Apply Height
	if tSettings.bFocus == true or tSettings.bReplaceFocus == true then
		self.wndMain:FindChild("Medic"):SetAnchorPoints(0,0,1,1-(tSettings.sFocusHeight/100))
		self.wndMain:FindChild("Medic"):SetAnchorOffsets(1,1,-1,1)
		self.wndMain:FindChild("ManaBar"):SetAnchorPoints(0,1-(tSettings.sFocusHeight/100),1,1)
		self.wndMain:FindChild("ManaBar"):SetAnchorOffsets(1,0,-1,-1)
		self.wndMain:FindChild("CoreDamage"):SetAnchorPoints(0,1-(tSettings.sFocusHeight/100),1,1)
		self.wndMain:FindChild("CoreDamage"):SetAnchorOffsets(1,0,-1,-1)
		self.wndMain:FindChild("ManaBar"):Show(tSettings.bFocus)
		self.wndMain:FindChild("CoreDamage"):Show(tSettings.bReplaceFocus)
	else
		self.wndMain:FindChild("Medic"):SetAnchorPoints(0,0,1,1)
		self.wndMain:FindChild("Medic"):SetAnchorOffsets(1,1,-1,1)
		self.wndMain:FindChild("ManaBar"):Show(tSettings.bFocus)
		self.wndMain:FindChild("CoreDamage"):Show(tSettings.bReplaceFocus)
	end
	
	-- Apply Colors
	---- Innate
	self.wndMain:FindChild("Energize"):SetTextColor("FF"..tSettings.clrInnate)
	if tSettings.bInnateText == true then
		self.wndMain:FindChild("Energize"):SetText(tSettings.sInnateText)
	else
		self.wndMain:FindChild("Energize"):SetText("HARDCORE !")
	end
	self.wndMain:FindChild("InnateBar"):SetBarColor("FF"..tSettings.clrInnate)
	---- Actuators
	for i=1, 4, 1 do
		self.wndMain:FindChild("CoreContainer"..i):SetBGColor("FF"..tSettings.clrBgAct)
	end
	---- Focus
	self.wndMain:FindChild("ManaBar"):SetBGColor("FF"..tSettings.clrBgFocus)
	self.wndMain:FindChild("ManaText"):SetTextColor("FF"..tSettings.clrFocusText)
	self.wndMain:FindChild("ManaText"):Show(tSettings.bFocusText)
	---- Core Damage
	self.wndMain:FindChild("CoreDamage"):SetBGColor("FF"..tSettings.clrBgCore)
	self.wndMain:FindChild("CoreText"):Show(tSettings.bCoreText)
	self.wndMain:FindChild("CoreText"):SetTextColor("FF"..tSettings.clrCoreText)
	---- Buffs
	if tSettings.bDangerZone == true or tSettings.bRoE == true then
		self.wndMain:FindChild("BuffLeft"):Show(true)
	else
		self.wndMain:FindChild("BuffLeft"):Show(false)
	end
	if tSettings.beProbes == true or tSettings.bAttrition == true then
		self.wndMain:FindChild("BuffRight"):Show(true)
	else
		self.wndMain:FindChild("BuffRight"):Show(false)
	end
	---- Empowering Aura Timer
	if self.Settings.bRefresh then
		local empTimerSec = tonumber(tSettings.sEmpTimer)
		self.empTimer:Set(empTimerSec, true, "onEmpTimer", self)
		self.empTimer:Start()
	else
		self.empTimer:Stop()
	end
	
end


-----------------------------------------------------------------------------------------------
-- Medikit Options
-----------------------------------------------------------------------------------------------

function Medikit:SlashMedikit()
	self:OnConfigure()
end	

function Medikit:OnClose()
	self.wndSettingsForm:Show(false)
end

function Medikit:OnSaveBtn(wndHandler, wndControl, eMouseButton)
	if wndHandler ~= wndControl then return end

	self:GetOptions()
	self.Settings.bEditMode = false
	self:ApplySettings()
	self.SettingsOld = nil
	self.wndSettingsForm:Show(false)
end

function Medikit:OnLockBtn( wndHandler, wndControl, eMouseButton )
	self.Settings.bLocked = self.wndSettingsForm:FindChild("LockBtn"):IsChecked()
	if self.Settings.bActAlert then
		self.Alert:Show(not self.Settings.bLocked)
		self.Alert:SetStyle ("Sizable", not self.Settings.bLocked)
		self.Alert:SetStyle ("Moveable", not self.Settings.bLocked)
		self.Alert:SetStyle ("IgnoreMouse", self.Settings.bLocked)
	end
	self.wndMain:SetStyle ("Sizable", not self.Settings.bLocked)
	self.wndMain:SetStyle ("Moveable", not self.Settings.bLocked)
	self.wndMain:SetStyle ("IgnoreMouse", self.Settings.bLocked)
end

function Medikit:OnAlertCheck( wndHandler, wndControl, eMouseButton )
	self.Settings.bActAlert = self.wndSettingsForm:FindChild("LowActAlertBtn"):IsChecked()
	if self.Settings.bActAlert then
		self.Alert:Show(not self.Settings.bLocked)
		self.Alert:SetStyle ("Sizable", not self.Settings.bLocked)
		self.Alert:SetStyle ("Moveable", not self.Settings.bLocked)
		self.Alert:SetStyle ("IgnoreMouse", self.Settings.bLocked)
	else
		self.Alert:Show (self.Settings.bActAlert)
	end
end

function Medikit:OnReset ()
	self:ResetSettings()
	self:ApplySettings()
	self.wndSettingsForm:Show(false)
end

function Medikit:CopyTable(t)
	local o = {}

	for k,v in pairs(t) do
		if type(v) == 'table' then
			o[k] = self:CopyTable(v)
		else
			o[k] = v
		end
	end

	return o
end

function Medikit:ResetSettings()
	self.Settings = self:CopyTable(defaultSettings)
end

function Medikit:OnSave(eLevel)
    if eLevel == GameLib.CodeEnumAddonSaveLevel.Character then
	    return self.Settings
	end
end

function Medikit:OnRestore(eLevel, tData)
	
    if eLevel == GameLib.CodeEnumAddonSaveLevel.Character then
		if (tData.version ~= defaultSettings.version and defaultSettings.bOverrideSaved) or tData.bOverrideSaved == nil then

			local newData = {}
				for k,v in pairs(defaultSettings) do

				newData[k] = tData[k] or v
			end
			self.Settings = newData
		else 
			self.Settings = tData
		end
		self.bRestored = true
		self:ApplySettings()
	
	end
end

function Medikit:OnWindowManagementReady()
    Event_FireGenericEvent("WindowManagementRegister", {wnd = self.wndMain, strName = "Medikit"})
	Event_FireGenericEvent("WindowManagementAdd", {wnd = self.wndMain, strName = "Medikit"})
	Event_FireGenericEvent("WindowManagementRegister", {wnd = self.Alert, strName = "Medikit Alert"})
	Event_FireGenericEvent("WindowManagementAdd", {wnd = self.Alert, strName = "Medikit Alert"})
end

---------------------------------------------------------------------------------------------------
-- SettingsForm Functions
---------------------------------------------------------------------------------------------------
function Medikit:EditclrMenu(wndHandler, wndControl)
	local strSettingName = wndControl:GetData()
	local colorString = wndControl:GetText()
	
	if string.len(colorString) == 6 then
		wndControl:SetTextColor("FF"..colorString)
	end
end

-----------------------------------------------------------------------------------------------
-- Medikit Instance
-----------------------------------------------------------------------------------------------
local MedikitInst = Medikit:new()
MedikitInst:Init()
