-----------------------------------------------------------------------------------------------
-- Client Lua Script for Ayth_Quest
-- Copyright (c) NCsoft. All rights reserved
-----------------------------------------------------------------------------------------------
 
require "Window"
require "QuestLib"
require "GameLib"
require "Vector3"
 
-----------------------------------------------------------------------------------------------
-- Ayth_Quest Module Definition
-----------------------------------------------------------------------------------------------
local Ayth_Quest = {}



-- I don't know why I need to do this, but I do.  I couldn't get the way the default nameplates preload units to work for me
--Ayth_Quest_Preload = {}
--Ayth_Quest_Preload.units = {}

--function Ayth_Quest_Preload_Event(unit)
--	if Ayth_Quest_Preload then
--		table.insert(Ayth_Quest_Preload.units, unit)
--	else
--		Apollo.RemoveEventHandler("UnitCreated", self)
--	end
--end


--Apollo.RegisterEventHandler("UnitCreated", "Ayth_Quest_Preload_Event")


-----------------------------------------------------------------------------------------------
-- Constants
-----------------------------------------------------------------------------------------------
-- e.g. local kiExampleVariableMax = 999
 
-----------------------------------------------------------------------------------------------
-- Initialization
-----------------------------------------------------------------------------------------------
function Ayth_Quest:new(o)
    o = o or {}
    setmetatable(o, self)
    self.__index = self 
	
    -- initialize variables here
	self.tUnits = {} -- ID, type
	self.tTracked = {giver = {}, objective = {}, path = {}, harvest = {}, farm = {}, none = {}}
	
	self.tUnitsDrawn = {}
	
	self.markerSets = {}
	self.unusedMarkerSets = {}
	
	self.lastPosition = nil
	self.wndObjectivesList = {}
	self.quest = nil
	self.shouldUpdatePossibleLines = false
	self.curPosition = nil
	self.player = nil
	self.playerVector = nil
	self.shouldUpdateUnits = false
	self.lineUsedCount = 0
	self.inCombat = false
	self.pvp = false
	self.questCount = 0
	self.tQuestList = {}
	self.tQuestsActive = {}
	self.questCarbine = nil
	self.lastObjectiveNum = nil
	self.bIsMiner, self.bIsRelicHunter, self.bIsSurvivalist, self.bIsFarmer = false, false, false, false
	self.pathName = ""
	self.preloadUnits = {}
	self.unitsToCheck = {}
	self.time = nil
	
	
	self.miniMapMarker =
		{
		IronNode				= "harvest",
		TitaniumNode			= "harvest",
		ZephyriteNode			= "harvest",
		PlatinumNode			= "harvest",
		HydrogemNode			= "harvest",
		XenociteNode			= "harvest",
		ShadeslateNode			= "harvest",
		GalactiumNode			= "harvest",
		NovaciteNode			= "harvest",
		StandardRelicNode		= "harvest",
		AcceleratedRelicNode	= "harvest",
		AdvancedRelicNode		= "harvest",
		DynamicRelicNode		= "harvest",
		KineticRelicNode		= "harvest",
		SpirovineNode			= "farm",
		BladeleafNode			= "farm",
		YellowbellNode			= "farm",
		PummelgranateNode		= "farm",
		SerpentlilyNode			= "farm",
		GoldleafNode			= "farm",
		HoneywheatNode			= "farm",
		CrowncornNode			= "farm",
		CoralscaleNode			= "farm",
		LogicleafNode			= "farm",
		StoutrootNode			= "farm",
		GlowmelonNode			= "farm",
		FaerybloomNode			= "farm",
		WitherwoodNode			= "farm",
		FlamefrondNode			= "farm",
		GrimgourdNode			= "farm",
		MourningstarNode		= "farm",
		BloodbriarNode			= "farm",
		OctopodNode				= "farm",
		HeartichokeNode			= "farm",
		SmlGrowthshroomNode		= "farm",
		MedGrowthshroomNode		= "farm",
		LrgGrowthshroomNode		= "farm",
		SmlHarvestshroomNode	= "farm",
		MedHarvestshroomNode	= "farm",
		LrgHarvestshroomNode	= "farm",
		SmlRenewshroomNode		= "farm",
		MedRenewshroomNode		= "farm",
		LrgRenewshroomNode		= "farm",
		AlgorocTreeNode			= "harvest",
		CelestionTreeNode		= "harvest",
		DeraduneTreeNode		= "harvest",
		EllevarTreeNode			= "harvest",
		GalerasTreeNode			= "harvest",
		AuroriaTreeNode			= "harvest",
		WhitevaleTreeNode		= "harvest",
		DreadmoorTreeNode		= "harvest",
		FarsideTreeNode			= "harvest",
		CoralusTreeNode			= "harvest",
		MurkmireTreeNode		= "harvest",
		WilderrunTreeNode		= "harvest",
		MalgraveTreeNode		= "harvest",
		HalonRingTreeNode		= "harvest",
		GrimvaultTreeNode		= "harvest"
		}

	
	local ccObjectives = CColor.new(0, 0, 0, 1)
	local ccGivers = CColor.new(0, 0, 0, 1)
	local ccPath = CColor.new(0, 0, 0, 1)
	local ccHarvest = CColor.new(0, 0, 0, 1)
	local ccFarm = CColor.new(0, 0, 0, 1)
	
	self.tColor = {giver = ccGivers, objective = ccObjectives, path = ccPath, harvest = ccHarvest, farm = ccFarm}
	
	self.textNumberToString = {"CRB_Interface14", "CRB_InterfaceMedium_B", "CRB_InterfaceSmall", "CRB_InterfaceLarge"}
	self.textStringToNumber = {CRB_Interface14 = 1, CRB_InterfaceMedium_B = 2, CRB_InterfaceSmall = 3, CRB_InterfaceLarge = 4}


	
	
	-- changes to these are saved and restored
	self.tUserSettings = {}
	self.tUserSettings.lineCounts = {giver = 1, objective = 3, path = 1, harvest = 1, farm = 1}
	self.tUserSettings.wipe6 = false -- used to wipe old data from a point on
	self.tUserSettings.arrowTimer = 10
	self.tUserSettings.showLinesInCombat = true
	self.tUserSettings.showDrag = true
	self.tUserSettings.showAythTracker = true
	self.tUserSettings.cnObjectives = {red = 1, green = 1, blue = 1, alpha = 1}
	self.tUserSettings.cnGivers = {red = 0, green = 1, blue = 0, alpha = 1}
	self.tUserSettings.cnPath = {red = 0, green = 0, blue = 1, alpha = 1}
	self.tUserSettings.cnHarvest = {red = 1, green = 0, blue = 1, alpha = 1}
	self.tUserSettings.cnFarm = {red = 1, green = 0, blue = 1, alpha = 1}
	self.tUserSettings.neverArrow = false
	self.tUserSettings.countChallenge = false
	self.tUserSettings.textChoice = { Ayth_QuestHeaderText = "CRB_Interface14", Ayth_QuestObjectiveText = "CRB_Interface14" }


	
	
	
	
	return o
end

function Ayth_Quest:Init()
	local bHasConfigureFunction = true
	local strConfigureButtonText = "Ayth_Quest"
	local tDependencies = {
		-- "UnitOrPackageName",
	}
    Apollo.RegisterAddon(self, bHasConfigureFunction, strConfigureButtonText, tDependencies)
end



 

-----------------------------------------------------------------------------------------------
-- Ayth_Quest OnLoad
-----------------------------------------------------------------------------------------------
function Ayth_Quest:OnLoad()
	Apollo.RegisterEventHandler("UnitCreated", "OnPreloadUnitCreated", self)

    -- load our form file
	self.xmlDoc = XmlDoc.CreateFromFile("Ayth_Quest.xml")
	self.xmlDoc:RegisterCallback("OnDocLoaded", self)
end

function Ayth_Quest:OnPreloadUnitCreated(unitNew)
	self.unitsToCheck[unitNew:GetId()] = unitNew
end


function Ayth_Quest:OnSave(eType)
	if eType ~= GameLib.CodeEnumAddonSaveLevel.Character then
		return
	end
	
	local tSavedData = self.tUserSettings

	tSavedData.nOL, tSavedData.nOT, tSavedData.nOR, tSavedData.nOB = self.wndMain:GetAnchorOffsets()	
			
		
	return tSavedData
end

function Ayth_Quest:OnRestore(eType, tSavedData)
	if eType ~= GameLib.CodeEnumAddonSaveLevel.Character then
		return
	end

	if tSavedData ~= nil then
		--self.tUserSettings = tSavedData
		if tSavedData.wipe6 then 
			for idx, item in pairs(tSavedData) do
				self.tUserSettings[idx] = item
			end	
		end
			
	end
	self.tUserSettings.wipe6 = true
	self.tUserSettings.givers = nil
	self.tUserSettings.SAVEDUNITS = nil
	self.tUserSettings.lineCounts["farm"] = self.tUserSettings.lineCounts["farm"] or 1

end



-----------------------------------------------------------------------------------------------
-- Ayth_Quest OnDocLoaded
-----------------------------------------------------------------------------------------------
function Ayth_Quest:OnDocLoaded()

	if self.xmlDoc ~= nil and self.xmlDoc:IsLoaded() then
	    self.wndOptions = Apollo.LoadForm(self.xmlDoc, "Ayth_QuestForm", nil, self)
		if self.wndOptions == nil then
			Apollo.AddAddonErrorText(self, "Could not load the main window for some reason.")
			return
		end
		
	    self.wndOptions:Show(false, true)

		Apollo.RegisterSlashCommand("ayth", "OnAyth_QuestOn", self)

		self.timer = ApolloTimer.Create(self.tUserSettings.arrowTimer, true, "OnTimer", self)
		self.timer:Stop()
		--self.timer:Set(self.tUserSettings.arrowTimer)
		if self.tUserSettings.arrowTimer ~= 0 then
			self.timer:Start()
		end
	
		

		-- Do additional Addon initialization here
		--Apollo.RegisterEventHandler("QuestInit", "OnSomethingChanged", self)
		--Apollo.RegisterEventHandler("EpisodeStateChanged", "OnSomethingChanged", self)
		Apollo.RegisterEventHandler("QuestStateChanged", "OnQuestStateChanged", self)
		Apollo.RegisterEventHandler("QuestObjectiveUpdated", "OnQuestObjectiveUpdated", self)
		Apollo.RegisterEventHandler("GenericEvent_QuestLog_TrackBtnClicked", "OnSomethingChanged", self)
		--Apollo.RegisterEventHandler("UnitMiniMapMarkerChanged", "OnSomethingChanged", self)
		
		Apollo.RegisterEventHandler("ChangeWorld", "OnWorldChanged", self)
		--Apollo.RegisterEventHandler("VarChange_ZoneName", "OnWorldChanged", self)
		--Apollo.RegisterEventHandler("SubZoneChanged", "OnWorldChanged", self)


		
		Apollo.RemoveEventHandler("UnitCreated", self)
		Apollo.RegisterEventHandler("UnitCreated", "OnUnitCreated", self)
		Apollo.RegisterEventHandler("UnitDestroyed", "OnUnitDestroyed", self)
		Apollo.RegisterEventHandler("UnitActivationTypeChanged", "OnUnitChanged", self)
		Apollo.RegisterEventHandler("UnitGibbed", "OnUnitChanged", self)

		
		Apollo.RegisterEventHandler("UnitEnteredCombat", "OnEnterCombat", self)
		
		Apollo.RegisterEventHandler("MatchEntered", "OnEnterPvP", self)
		Apollo.RegisterEventHandler("PVPMatchFinished", "OnLeavePvP", self)
		Apollo.RegisterEventHandler("MatchExited", 	"OnLeavePvP", self)
		Apollo.RegisterEventHandler("Ayth_Quest_Config", "OnAyth_QuestOn", self)

		
		
			
		self.wndMain = Apollo.LoadForm(self.xmlDoc, "QuestContainer", "FixedHudStratum", self)
		if self.tUserSettings.nOL then
			self.wndMain:SetAnchorOffsets(self.tUserSettings.nOL, self.tUserSettings.nOT, self.tUserSettings.nOR, self.tUserSettings.nOB)
		end
		self.wndTitleContainer = self.wndMain:FindChild("TitleContainer")
		self.wndTitleText = self.wndTitleContainer:FindChild("TitleText")
		self.wndObjectiveContainer = self.wndMain:FindChild("ObjectiveContainer")
		self.wndSpacer = self.wndMain:FindChild("MoveSpacer")
		self.wndSpacer:Show(self.tUserSettings.showDrag, true)
		
		
		self.mapTextOptions = {
			{
				wnd = self.wndOptions:FindChild("btnHeaderText"),
				radio = "Ayth_QuestHeaderText"
			},
			{
				wnd = self.wndOptions:FindChild("btnObjectiveText"),
				radio = "Ayth_QuestObjectiveText"
			}
		}
		
		for idx, wndDD in pairs(self.mapTextOptions) do
			wndDD.wnd:AttachWindow(wndDD.wnd:FindChild("ChoiceContainer"))
			wndDD.wnd:FindChild("ChoiceContainer"):Show(false)
		end

		
		for idx, parent in pairs(self.mapTextOptions) do
			if parent.wnd ~= nil and parent.radio ~= nil then
	
				local arBtns = parent.wnd:FindChild("ChoiceContainer"):GetChildren()
	
				for idxBtn = 1, #arBtns do
					arBtns[idxBtn]:SetCheck(false)
				end
				
				local idxBtn = self.textStringToNumber[self.tUserSettings.textChoice[parent.radio]]
							
				
				self.wndOptions:SetRadioSel(parent.radio, idxBtn )
				arBtns[idxBtn]:SetCheck(true)
				
				parent.wnd:SetFont(self.tUserSettings.textChoice[parent.radio])
				
			end
		end
	
		
		
				
					
		
		
		self.wndMain:Show(self.tUserSettings.showAythTracker, true)
		
		self.drawTimer = ApolloTimer.Create(0.01, true, "OnDrawTimer", self)
		
		self.delayStartTime = ApolloTimer.Create(0.5, true, "OnDelayedStart", self)
		
		self.questUpdateTimer = ApolloTimer.Create(5, true, "OnQuestUpdateTimer", self)
		
				
					
	end
end




function Ayth_Quest:OnDelayedStart()
	self.player = GameLib.GetPlayerUnit()
	if not self.player then return end
	
	self.delayStartTime:Stop()
	
	self:UpdateCarbineClosest(false)
	self:OnTimer()

	local nPath = PlayerPathLib.GetPlayerPathType()
	if nPath == 0 then
		self.pathName = "Soldier"
	elseif nPath == 1 then
		self.pathName = "Settler"
	elseif nPath == 2 then
		self.pathName = "Scientist"
	elseif nPath == 3 then
		self.pathName = "Explorer" 
	end
	
	self:UpdateLineColors()
	
	self.shouldUpdatePossibleLines = true
	
	
	Event_FireGenericEvent("InterfaceMenuList_NewAddOn", "Ayth_Quest", {"Ayth_Quest_Config", "", "CRB_Basekit:kitIcon_Holo_Exclamation"})

end

function Ayth_Quest:OnWorldChanged()
	self.player = nil
	self.shouldUpdateUnits = true
	self.shouldUpdatePossibleLines = true
	
end



function Ayth_Quest:OnSomethingChanged()
	
	self.shouldUpdateUnits = true	
	self.shouldUpdatePossibleLines = true

	
end

function Ayth_Quest:OnQuestStateChanged(que)

	self:UpdateCarbineClosest(false)
	self:ArrowIfCan()
	self.shouldUpdateUnits = true	
	self.shouldUpdatePossibleLines = true

	
end

function Ayth_Quest:OnQuestObjectiveUpdated(que, objNum)
	if que == self.questCarbine then
		self:UpdateQuestCurrent(que)
		if self.lastObjectiveNum ~= objNum then
			self.lastObjectiveNum = objNum
			self:ArrowIfCan()
		end
	end
	self.shouldUpdateUnits = true
	self.shouldUpdatePossibleLines = true

end

function Ayth_Quest:OnEnterPvP()
	self.wndMain:Show(false, true)
	self.pvp = true

end

function Ayth_Quest:OnLeavePvP()
	self.wndMain:Show(self.tUserSettings.showAythTracker, true)
	self.pvp = false
end


function Ayth_Quest:OnEnterCombat(unit, inCombat)
	if unit == GameLib.GetPlayerUnit() then
		self.inCombat = inCombat
	end
end

function Ayth_Quest:OnUnitCreated(unit)
	-- Hopefully filter out 'used Item quest givers that can't be used atm'
	if not unit then return end
		
	self.unitsToCheck[unit:GetId()] = unit
		
	
end

function Ayth_Quest:OnUnitChanged(unit)
	
	--if self.trackedUnits[unit:GetId()] then
	--	self:OnUnitDestroyed(unit)
	--end
	--
	
	self:CheckTracking(unit)
		
	self.shouldUpdatePossibleLines = true 
		
end

function Ayth_Quest:OnUnitDestroyed(unit)
	local id = unit:GetId()
	
	local trackedType = self.tUnits[id]
	
	if trackedType then
		self.tTracked[trackedType][id] = nil
		self.tUnits[id] = nil
		self.shouldUpdatePossibleLines = true
	end
		
end



function Ayth_Quest:OnQuestUpdateTimer()
	local lastQue = self.questCarbine
	self:UpdateCarbineClosest(false)
	if lastQue ~= self.questCarbine then
		self:ArrowIfCan()
	end
end




function Ayth_Quest:OnTimer()
	-- Do your timer-related stuff here.
	if self.lineUsedCount < 1 then
		self:ArrowIfCan()
	end
end

function Ayth_Quest:UpdateCarbineClosest(force)

	local epis = QuestLib.GetTrackedEpisodes(true)
	if epis[1] then
		local quests = epis[1]:GetTrackedQuests(0, true)
		local que = quests[1]
		if que then
			if self.questCarbine == que and not force then
				-- do anything here?
			else
				self.questCarbine = que
				self:UpdateQuestCurrent(que)
			end
			return 
		end
	end
	
	-- no quests?  delete in case old
	self.quest = nil
	self.wndTitleText:SetText("No Quests Tracked - Find a quest or Track one in your Quest Log")
	self.wndTitleText:SetHeightToContentHeight()
	local h = self.wndTitleText:GetHeight()+20
	self.wndTitleContainer:SetAnchorOffsets(0, 20, 0, h)
	for idx, wnd in ipairs(self.wndObjectivesList) do
		wnd:Destroy()
	end

	
end


	

function Ayth_Quest:ArrowIfCan()
	if self.tUserSettings.neverArrow then return end
	if self.questCarbine then
		local reg = self.questCarbine:GetMapRegions()
		
		if #reg > 0 and reg[1].tIndicator then
			self.questCarbine:ShowHintArrow()
		end

	end
		
end

function Ayth_Quest:UpdateQuestCurrent(quest)
	-- todo handle timers, but really we should figure out if any quest has a timer and prioritize that over distance shouldn't we?  bleh
	-- first up title
	local strTitle = quest:GetTitle()
	local eQuestState = quest:GetState()
	if eQuestState == Quest.QuestState_Botched then
		strTitle = String_GetWeaselString(Apollo.GetString("QuestTracker_Failed"), strTitle)
		--self.wndTitleText:SetTextColor(self.red)
	elseif eQuestState == Quest.QuestState_Achieved then
		strTitle = String_GetWeaselString(Apollo.GetString("QuestTracker_Complete"), strTitle)
		--self.wndTitleText:SetTextColor(self.ccGivers )
	else
		--self.wndTitleText:SetTextColor(self.ccObjectives)
	end
	strTitle = String_GetWeaselString(Apollo.GetString("QuestTracker_ConDisplay"), strTitle, quest:GetConLevel())
	self.wndTitleText:SetFont(self.tUserSettings.textChoice["Ayth_QuestHeaderText"])
	self.wndTitleText:SetText(strTitle)
	self.wndTitleText:SetHeightToContentHeight()
	
	local h = self.wndTitleText:GetHeight() + 25
	self.wndTitleContainer:SetAnchorOffsets(0, 20, 0, h)
	
	
	--next up objectives
	
	for idx, wnd in ipairs(self.wndObjectivesList) do
		wnd:Destroy()
	end
	
	self.wndObjectivesList = {}
	
	if eQuestState == Quest.QuestState_Achieved then
		local strResult = quest:GetCompletionObjectiveShortText()
		if not strResult or string.len(strResult) <= 0 then
			strResult = quest:GetCompletionObjectiveText()
		end
		local wnd = Apollo.LoadForm(self.xmlDoc, "Objective", self.wndObjectiveContainer, self)
		table.insert(self.wndObjectivesList, wnd)
		wnd:SetFont(self.tUserSettings.textChoice["Ayth_QuestObjectiveText"])
		wnd:SetText(strResult)
	else
		for idObjective, tObjective in ipairs(quest:GetVisibleObjectiveData()) do
			if tObjective.nCompleted < tObjective.nNeeded then
				local wnd = Apollo.LoadForm(self.xmlDoc, "Objective", self.wndObjectiveContainer, self)
				table.insert(self.wndObjectivesList, wnd)
				local strResult = quest:GetObjectiveShortDescription(tObjective.nIndex)
				if not strResult or string.len(strResult) <= 0 then
					strResult = tObjective.strDescription
				end
				
				wnd:FindChild("BtnObjective"):SetData({q = quest, i = tObjective.nIndex})
				
				
				-- check for stuff to add to text
				local pre = ""
				if tObjective and not tObjective.bIsRequired then
					pre = Apollo.GetString("QuestLog_Optional")
				end
				if tObjective.nNeeded > 1 and quest:DisplayObjectiveProgressBar(tObjective.nIndex) then
					pre = pre .. String_GetWeaselString(Apollo.GetString("QuestTracker_PercentComplete"), tObjective.nCompleted)
				elseif tObjective.nNeeded > 1 then 
					pre = pre .. String_GetWeaselString(Apollo.GetString("QuestTracker_ValueComplete"), tObjective.nCompleted, tObjective.nNeeded)
				end
				
				if quest:IsObjectiveTimed(tObjective.nIndex) then
					pre = pre .. math.floor(quest:GetObjectiveTimeRemaining(tObjective.nIndex) / 1000) .. "s"
				end
				
				strResult = pre .. " " .. strResult
				
				
				--damn buttons
				local spellbtn = Apollo.LoadForm(self.xmlDoc, "SpellItemObjectiveBtn", wnd, self)
				spellbtn:SetData("SpellItemObjectiveBtn"..tObjective.nIndex)
				spellbtn:SetContentId(quest, tObjective.nIndex)
				
				
				wnd:SetFont(self.tUserSettings.textChoice["Ayth_QuestObjectiveText"])
				wnd:SetText(strResult)
				wnd:SetHeightToContentHeight()

			end
		end
	end
	
	
	--self.wndMain:ArrangeChildrenVert()
	self.wndObjectiveContainer:ArrangeChildrenVert()
	self.wndMain:ArrangeChildrenVert()
		
	
	
	
end


function Ayth_Quest:CheckTracking(unit)
	
	if not self.player then return end
	if not unit or not unit:IsValid() then return end
	local shouldTrack = "none"

	local tRewardInfo = nil
	local reward = false
	tRewardInfo = unit:GetRewardInfo()
	if tRewardInfo and type(tRewardInfo) == "table" then
		local count = #tRewardInfo
		for idx = 1, count do
			local type = tRewardInfo[idx].strType
			if type == "Quest" then
				shouldTrack = "objective"
				reward = true
			elseif type == self.pathName then
				if tRewardInfo[idx].pmMission then
					shouldTrack = "path"
				end
			elseif type == "PublicEvent" then
				if tRewardInfo[idx].peoObjective then
					if tRewardInfo[idx].peoObjective:GetEvent():GetName() ~= nil then
						shouldTrack = "objective"
						reward = true
					end
				end
			elseif self.tUserSettings.countChallenge and type == "Challenge" then
				for index, clgCurr in pairs(ChallengesLib.GetActiveChallengeList()) do
					if tRewardInfo[idx].idChallenge == clgCurr:GetId() and clgCurr:IsActivated() and not clgCurr:IsInCooldown() and not clgCurr:ShouldCollectReward() then
						shouldTrack = "objective"
						break
					end
				end		
			end
			
		end
	end
	
	
	
	local tActivation = unit:GetActivationState()
			
	if tActivation.QuestNew ~= nil or tActivation.QuestNewMain ~= nil then
		shouldTrack = "giver" 
	elseif tActivation.QuestNewRepeatable ~= nil then
		shouldTrack = "giver"
	elseif tActivation.QuestReward ~= nil then
		shouldTrack = "objective"
	elseif tActivation.Datacube ~= nil then
		if self.pathName == "Scientist" then
			shouldTrack = "path"
		end
	elseif self.pathName == "Settler" and tActivation.Collect ~= nil and unit:GetAffiliationName() ~= "" then
		shouldTrack = "path"
	elseif self.pathName == "Settler" and tActivation.SettlerImprovement ~= nil then
		shouldTrack = "path"
	elseif self.pathName == "Explorer" and tActivation.ExplorerInterest ~= nil then
		shouldTrack = "path"
	end
		
	
	if tActivation.Busy ~= nil then
		shouldTrack = "none"
	--elseif reward and tActivation.Interact == nil and not unit:ShouldShowNamePlate() then
		--shouldTrack = "none"
	end


		
	if shouldTrack == "none" then
		if unit:CanBeHarvestedBy(self.player) then
			local minimapMarkers = unit:GetMiniMapMarkers()
			for i, marker in ipairs(minimapMarkers) do
				if self.miniMapMarker[marker] then
					shouldTrack = self.miniMapMarker[marker]
				end
			end
		end
	end
	
	if shouldTrack == "none" then
		if unit:GetType() == "Pickup" then
			local pName = self.player:GetName();
			if string.sub(unit:GetName(), 1, string.len(pName)) == pName then
				shouldTrack = "objective"
			end
		end
	end

		
			
	if unit:IsDead() then
		shouldTrack = "none"
	end
		
	
	local id = unit:GetId()
	if self.tUnits[id] then
		local old = self.tUnits[id]
		if old ~= shouldTrack then
			self.tTracked[old][id] = nil
		end	
	end
	self.tUnits[id] = shouldTrack
	self.tTracked[shouldTrack][id] = {unit = unit}
	
end


function Ayth_Quest:StopUsingMarkerSet(id)
	local markerSet = self.markerSets[id]
	if markerSet then
		for i = 1, 7 do
			markerSet[i]:Show(false, true)
		end
	end
		-- we'll reuse old marker sets cause i suspsect it's better performance
	self.markerSets[id] = nil
	if markerSet then
		table.insert(self.unusedMarkerSets, markerSet)
	end

end

function Ayth_Quest:DrawLineTo(id, targetVec, dist, which)
	
	local color = self.tColor[which]
	
	local markerSet = nil
	if self.markerSets[id] then
		markerSet = self.markerSets[id] 
	end
	
	
	if markerSet == nil then
		if self.unusedMarkerSets[1] then
			markerSet = self.unusedMarkerSets[1]
			table.remove(self.unusedMarkerSets, 1)
		else
			markerSet = {}
			for i = 1, 7 do
				--if i == 1 then
				--	markerSet[i] = Apollo.LoadForm("Ayth_Quest.xml", "AythArrow", "InWorldHudStratum", self)
				if i == 3 then
					markerSet[i] = Apollo.LoadForm("Ayth_Quest.xml", "AythDist", "InWorldHudStratum", self)
				else
					markerSet[i] = Apollo.LoadForm("Ayth_Quest.xml", "AythMarker", "InWorldHudStratum", self)
				end
			end
		end
		self.markerSets[id] = markerSet
		
	end
	
	markerSet[3]:SetText(tostring(math.floor(dist)))
	
	for i = 1, 7 do
		local fraction = i/10
		markerSet[i]:SetBGColor(color)
		markerSet[i]:SetWorldLocation(Vector3.InterpolateLinear(self.playerVector, targetVec, fraction))
		if markerSet[i]:IsOnScreen() then
			markerSet[i]:Show(true, true)
		else
			markerSet[i]:Show(false, true)
		end
			

	end
	
	self.tUnitsDrawn[id] = 1
	
		
end


function Ayth_Quest:OnDrawTimer()

	--if self.pvp then return end	

	if not self.player then
		self.player = GameLib.GetPlayerUnit()	
		return
	end
	
	for id, unit in pairs(self.unitsToCheck) do
		self:CheckTracking(unit)
		self.unitsToCheck[id] = nil
	end
	
	
	self.curPosition = self.player:GetPosition()
	if self.curPosition == nil then return end
	if self.lastPosition == nil then
		self.lastPosition = self.curPosition
	end
	
	local moving = true
	if  math.abs(self.lastPosition.x - self.curPosition.x) < 0.01 and 
		math.abs(self.lastPosition.y - self.curPosition.y) < 0.01 and 
		math.abs(self.lastPosition.z - self.curPosition.z) < 0.01 then	
		moving = false
	end
	self.lastPosition = self.curPosition
	
	if moving then
		self.shouldUpdatePossibleLines = true
	end
	
	
	if self.time and Time.SecondsElapsed(self.time) > 5 then
		self.shouldUpdateUnits = true
		self.shouldUpdatePossibleLines = true
	end
	
	
	if self.shouldUpdateUnits then
		self.shouldUpdateUnits = false

		for id, trackingType in pairs(self.tUnits) do
			self:CheckTracking(self.tTracked[trackingType][id]["unit"])
		end
		
				
	end
	

	if self.shouldUpdatePossibleLines then
		self.shouldUpdatePossibleLines = false
		self.time = Time.Now()
				
		self.playerVector = Vector3.New(self.curPosition.x, self.curPosition.y, self.curPosition.z)
		
		self.haveNoDist = false
		self.tUnitsDrawn = {}
		
		self.lineUsedCount = 0
		self:UpdateTrackingLines("objective")		
		self:UpdateTrackingLines("giver")
		self:UpdateTrackingLines("harvest")
		self:UpdateTrackingLines("path")
		self:UpdateTrackingLines("farm")
			
		for id, set in pairs(self.markerSets) do
			if not self.tUnitsDrawn[id] then
				self:StopUsingMarkerSet(id)
			end
		end
		
		
	end
end

function Ayth_Quest:UpdateDistances(which)
	for id, blob in pairs(self.tTracked[which]) do
		local targetPos = blob["unit"]:GetPosition()
		blob["targetVec"] = Vector3.New(targetPos.x, targetPos.y, targetPos.z)
		blob["dist"] = (self.playerVector - blob["targetVec"]):Length()
		blob["id"] = id
		if not blob["dist"] then self.haveNoDist = true end
	end
end

function Ayth_Quest:UpdateTrackingLines(which)

	if self.tUserSettings.lineCounts[which] > 0 then
		
		self:UpdateDistances(which)
		
		local blobList = {}
		for id, unitBlob in pairs(self.tTracked[which]) do
			table.insert(blobList, unitBlob)
		end
		
		if not self.player.IsInCCState(Unit.CodeEnumCCState.Blind) and not self.haveNoDist then
			table.sort(blobList, function(a, b) return a["dist"] < b["dist"] end)
			
			for i = 1, self.tUserSettings.lineCounts[which] do
				if blobList[i] then
					if which == "objective" then self.lineUsedCount = self.lineUsedCount + 1 end
					self:DrawLineTo(blobList[i]["id"], blobList[i]["targetVec"], blobList[i]["dist"], which)
				end	
			end
		end

	end

end

function Ayth_Quest:UpdateLineColors()
	self.tColor["objective"] = CColor.new(self.tUserSettings.cnObjectives["red"], self.tUserSettings.cnObjectives["green"], self.tUserSettings.cnObjectives["blue"], self.tUserSettings.cnObjectives["alpha"])
	self.tColor["giver"] = CColor.new(self.tUserSettings.cnGivers["red"], self.tUserSettings.cnGivers["green"], self.tUserSettings.cnGivers["blue"], self.tUserSettings.cnGivers["alpha"])
	self.tColor["path"] = CColor.new(self.tUserSettings.cnPath["red"], self.tUserSettings.cnPath["green"], self.tUserSettings.cnPath["blue"], self.tUserSettings.cnPath["alpha"])
	self.tColor["harvest"] = CColor.new(self.tUserSettings.cnHarvest["red"], self.tUserSettings.cnHarvest["green"], self.tUserSettings.cnHarvest["blue"], self.tUserSettings.cnHarvest["alpha"])
	self.tColor["farm"] = CColor.new(self.tUserSettings.cnFarm["red"], self.tUserSettings.cnFarm["green"], self.tUserSettings.cnFarm["blue"], self.tUserSettings.cnFarm["alpha"])

end


function Ayth_Quest:OnQuestCloseBtn(wndHandler, wndControl)
	if self.questCarbine == nil then return end
	self.questCarbine:SetActiveQuest(false)
	if self.questCarbine:GetState() == Quest.QuestState_Botched then
		self.questCarbine:Abandon()
	else
		self.questCarbine:ToggleTracked()
	end
	self:UpdateCarbineClosest(false)
end

function Ayth_Quest:OnAyth_QuestOn()
	self.wndOptions:FindChild("inputObjectiveCount"):SetText(tostring(self.tUserSettings.lineCounts["objective"]))
	self.wndOptions:FindChild("inputGiverCount"):SetText(tostring(self.tUserSettings.lineCounts["giver"]))
	self.wndOptions:FindChild("inputPathCount"):SetText(tostring(self.tUserSettings.lineCounts["path"]))
	self.wndOptions:FindChild("inputHarvestCount"):SetText(tostring(self.tUserSettings.lineCounts["harvest"]))
	self.wndOptions:FindChild("inputFarmCount"):SetText(tostring(self.tUserSettings.lineCounts["farm"]))

	--self.wndOptions:FindChild("btnQuestGiversAlways"):SetCheck(self.tUserSettings.showPriorityLines)
	self.wndOptions:FindChild("inputArrowTimer"):SetText(tostring(self.tUserSettings.arrowTimer))
	self.wndOptions:FindChild("btnshowDrag"):SetCheck(self.tUserSettings.showDrag)
	self.wndOptions:FindChild("btnshowAythTracker"):SetCheck(self.tUserSettings.showAythTracker)
	self.wndOptions:FindChild("btnNeverArrow"):SetCheck(self.tUserSettings.neverArrow)
	self.wndOptions:FindChild("btnChallenges"):SetCheck(self.tUserSettings.countChallenge)
	
	self.wndOptions:FindChild("cnObjectivesRed"):SetText(self.tUserSettings.cnObjectives["red"])
	self.wndOptions:FindChild("cnObjectivesGreen"):SetText(self.tUserSettings.cnObjectives["green"])
	self.wndOptions:FindChild("cnObjectivesBlue"):SetText(self.tUserSettings.cnObjectives["blue"])
	self.wndOptions:FindChild("cnObjectivesAlpha"):SetText(self.tUserSettings.cnObjectives["alpha"])
	
	self.wndOptions:FindChild("cnGiversRed"):SetText(self.tUserSettings.cnGivers["red"])
	self.wndOptions:FindChild("cnGiversGreen"):SetText(self.tUserSettings.cnGivers["green"])
	self.wndOptions:FindChild("cnGiversBlue"):SetText(self.tUserSettings.cnGivers["blue"])
	self.wndOptions:FindChild("cnGiversAlpha"):SetText(self.tUserSettings.cnGivers["alpha"])
	
	self.wndOptions:FindChild("cnPathRed"):SetText(self.tUserSettings.cnPath["red"])
	self.wndOptions:FindChild("cnPathGreen"):SetText(self.tUserSettings.cnPath["green"])
	self.wndOptions:FindChild("cnPathBlue"):SetText(self.tUserSettings.cnPath["blue"])
	self.wndOptions:FindChild("cnPathAlpha"):SetText(self.tUserSettings.cnPath["alpha"])
	
	self.wndOptions:FindChild("cnHarvestRed"):SetText(self.tUserSettings.cnHarvest["red"])
	self.wndOptions:FindChild("cnHarvestGreen"):SetText(self.tUserSettings.cnHarvest["green"])
	self.wndOptions:FindChild("cnHarvestBlue"):SetText(self.tUserSettings.cnHarvest["blue"])
	self.wndOptions:FindChild("cnHarvestAlpha"):SetText(self.tUserSettings.cnHarvest["alpha"])
	
	self.wndOptions:FindChild("cnFarmRed"):SetText(self.tUserSettings.cnFarm["red"])
	self.wndOptions:FindChild("cnFarmGreen"):SetText(self.tUserSettings.cnFarm["green"])
	self.wndOptions:FindChild("cnFarmBlue"):SetText(self.tUserSettings.cnFarm["blue"])
	self.wndOptions:FindChild("cnFarmAlpha"):SetText(self.tUserSettings.cnFarm["alpha"])

	
	self.wndOptions:FindChild("ccObjectivesShow"):SetBGColor(self.tColor["objective"])
	self.wndOptions:FindChild("ccGiversShow"):SetBGColor(self.tColor["giver"])
	self.wndOptions:FindChild("ccPathShow"):SetBGColor(self.tColor["path"])
	self.wndOptions:FindChild("ccHarvestShow"):SetBGColor(self.tColor["harvest"])
	self.wndOptions:FindChild("ccFarmShow"):SetBGColor(self.tColor["farm"])

	
		
	self.wndOptions:Invoke() -- show the window
end

function Ayth_Quest:OnConfigure()
	self:OnAyth_QuestOn()
end



function Ayth_Quest:OnOK()

	self.tUserSettings.lineCounts["objective"] = tonumber(self.wndOptions:FindChild("inputObjectiveCount"):GetText()) or 0
	self.tUserSettings.lineCounts["giver"] = tonumber(self.wndOptions:FindChild("inputGiverCount"):GetText()) or 0
	self.tUserSettings.lineCounts["path"] = tonumber(self.wndOptions:FindChild("inputPathCount"):GetText()) or 0
	self.tUserSettings.lineCounts["harvest"] = tonumber(self.wndOptions:FindChild("inputHarvestCount"):GetText()) or 0
	self.tUserSettings.lineCounts["farm"] = tonumber(self.wndOptions:FindChild("inputFarmCount"):GetText()) or 0

	
	
	self.tUserSettings.arrowTimer = tonumber(self.wndOptions:FindChild("inputArrowTimer"):GetText()) or 0
	self.tUserSettings.showDrag = self.wndOptions:FindChild("btnshowDrag"):IsChecked()
	self.tUserSettings.showAythTracker = self.wndOptions:FindChild("btnshowAythTracker"):IsChecked()
	self.tUserSettings.neverArrow = self.wndOptions:FindChild("btnNeverArrow"):IsChecked()
	self.tUserSettings.countChallenge = self.wndOptions:FindChild("btnChallenges"):IsChecked()



	-- valid input or default
	self.tUserSettings.arrowTimer = self.tUserSettings.arrowTimer or 10
	self.tUserSettings.lineCount = self.tUserSettings.lineCount or 3

	
	
	-- actions with new stuff
	self.wndSpacer:Show(self.tUserSettings.showDrag, true)
	
	self.timer:Set(self.tUserSettings.arrowTimer)
	self.timer:Stop()
		if self.tUserSettings.arrowTimer ~= 0 then
		self.timer:Start()
	end
	
	self.wndMain:Show(self.tUserSettings.showAythTracker, true)
		
	self:UpdateCarbineClosest(true)
	self.wndOptions:Close() -- hide the window
end

-- when the Cancel button is clicked
function Ayth_Quest:OnCancel()
	self.wndOptions:Close() -- hide the window
end


function Ayth_Quest:onColorOptionsChanged( wndHandler, wndControl, strText )
	-- I know what you're gonna think, and I don't wanna talk about it.  I don't.  Don't bring it up.  Just leave me to my shame.
	
	if wndHandler:GetName() == "cnObjectivesRed" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnObjectives["red"] = n
	elseif wndHandler:GetName() == "cnObjectivesGreen" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnObjectives["green"] = n
	elseif wndHandler:GetName() == "cnObjectivesBlue" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnObjectives["blue"] = n
	elseif wndHandler:GetName() == "cnObjectivesAlpha" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnObjectives["alpha"] = n
	
	elseif wndHandler:GetName() == "cnGiversRed" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnGivers["red"] = n
	elseif wndHandler:GetName() == "cnGiversGreen" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnGivers["green"] = n
	elseif wndHandler:GetName() == "cnGiversBlue" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnGivers["blue"] = n
	elseif wndHandler:GetName() == "cnGiversAlpha" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnGivers["alpha"] = n
	
	elseif wndHandler:GetName() == "cnPathRed" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnPath["red"] = n
	elseif wndHandler:GetName() == "cnPathGreen" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnPath["green"] = n
	elseif wndHandler:GetName() == "cnPathBlue" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnPath["blue"] = n
	elseif wndHandler:GetName() == "cnPathAlpha" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnPath["alpha"] = n
		
	elseif wndHandler:GetName() == "cnHarvestRed" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnHarvest["red"] = n
	elseif wndHandler:GetName() == "cnHarvestGreen" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnHarvest["green"] = n
	elseif wndHandler:GetName() == "cnHarvestBlue" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnHarvest["blue"] = n
	elseif wndHandler:GetName() == "cnHarvestAlpha" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnHarvest["alpha"] = n

		
	elseif wndHandler:GetName() == "cnFarmRed" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnFarm["red"] = n
	elseif wndHandler:GetName() == "cnFarmGreen" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnFarm["green"] = n
	elseif wndHandler:GetName() == "cnFarmBlue" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnFarm["blue"] = n
	elseif wndHandler:GetName() == "cnFarmAlpha" then
		local n = tonumber(wndHandler:GetText())
		n = Ayth_Quest.ValidateCN(n)
		self.tUserSettings.cnFarm["alpha"] = n

	end
	
	
	self:UpdateLineColors()
	self.wndOptions:FindChild("ccObjectivesShow"):SetBGColor(self.tColor["objective"])
	self.wndOptions:FindChild("ccGiversShow"):SetBGColor(self.tColor["giver"])
	self.wndOptions:FindChild("ccPathShow"):SetBGColor(self.tColor["path"])
	self.wndOptions:FindChild("ccHarvestShow"):SetBGColor(self.tColor["harvest"])
	self.wndOptions:FindChild("ccFarmShow"):SetBGColor(self.tColor["farm"])


end

function Ayth_Quest.ValidateCN(n)
	if not n then n = 0
	elseif n > 1 then n = 1
	elseif n < 0 then n = 0
	end
	return n
end

---------------------------------------------------------------------------------------------------
-- Objective Functions
---------------------------------------------------------------------------------------------------

function Ayth_Quest:onObjectiveBtn( wndHandler, wndControl, eMouseButton )
	local d = wndHandler:GetData()
	if d and d.q and d.i then
		d.q:ShowHintArrow(d.i)
	end
	
end

---------------------------------------------------------------------------------------------------
-- Ayth_QuestForm Functions
---------------------------------------------------------------------------------------------------

function Ayth_Quest:OnAythRadio( wndHandler, wndControl, eMouseButton )
	for idx, wndDD in pairs(self.mapTextOptions) do
		if wndDD.wnd == wndControl:GetParent():GetParent() then
			local btnidx =  wndControl:GetParent():GetRadioSel(wndDD.radio)
			local font = self.textNumberToString[btnidx]
			self.tUserSettings.textChoice[wndDD.radio] = font
			wndControl:GetParent():GetParent():SetFont(font)
			
			break
		end
	end
	
	wndControl:GetParent():Close()
	self:UpdateCarbineClosest(true)


end

-----------------------------------------------------------------------------------------------
-- Ayth_Quest Instance
-----------------------------------------------------------------------------------------------
local Ayth_QuestInst = Ayth_Quest:new()
Ayth_QuestInst:Init()
