﻿/*
*@brief : 调用壳支持的接口接口
*/
var KVIP_METHOD = {
    settitle			: 'settitle',
	closewnd			: 'closewnd',
	getlocalvipinfo		: 'getlocalvipinfo',
	validate			: 'validate',
	accounthasactive	: 'accounthasactive',
	showmsg				: 'showmsg',
	jserror				: 'jserror',
	pay					: 'pay',
	apply				: 'apply',
	openurl				: 'openurl',
	callvipfunction		: 'callvipfunction',
	getpath				: 'getpath',
	chsid				: 'chsid',
	show				: 'show',
	infoc				: 'infoc',	
	movewnd				: 'movewnd',
	callwizard			: 'callwizard',	
	movetocorner		: 'movetocorner',
	setpopshowtime		: 'setpopshowtime',
	adjustwndtohtmlsize	: 'adjustwndtohtmlsize',
	disablepaletewnd	: 'disablepaletewnd',
	centerwnd	        : 'centerwnd',
	btndown	            : 'btndown',
	movewnddx	        : 'movewnddx',
	requestaccount		: 'requestaccount',
	getaccount			: 'getaccount',
	setaccount			: 'setaccount',
	kvipprotocol		: 'kvipprotocol',
	kvipremote			: 'kvipremote',
	luckdraw			: 'luckdraw',
	weibo				: 'weibo'
};

var KVIP_POPRET = {
    emPushinfoPopFullScreen 	: -2,
	emPushinfoPopError 			: -1,
	emPushinfoPopTimeOut 		: 0,
	emPushinfoPopClose 			: 1,
    emPushinfoPopleftButtom 	: 2,
    emPushinfoPopRightButtom 	: 3
};

var KDEFMACRO = {	
	//页面定义		
	_PAGE_INSTALL_FINISH_				: "installfinish",
	_PAGE_LOGIN_  						: "login",
	_PAGE_REGESTERNEW_OR_CHANGEP_		: "re_ch",
	_PAGE_VALIDATE_						: "validate",
	_PAGE_SUSSCESS_NOEMAIL_				: "snoe",
	_PAGE_SUSSCESS_HASEMAIL_			: "shase", 
	_PAGE_PAY_							: "pay", 
	_PAGE_APPLY_						: "apply",
	
	_PATH_KISCOMMON_					: 1,
	_PATH_PRODUCT_						: 2,
	
	_LOGIN_SUCCESS_						: 0X10001,
	
	// 通行证信息
	KVIP_SEX                           : "sex",
	KVIP_SMS                           : "sms",
	KVIP_EBB1                          : "ebb1",
	KVIP_EBB2                          : "ebb2",
	KVIP_EMAIL                         : "email",
	KVIP_ISEND                         : "isend",
	KVIP_BIRTH                         : "birth",
	KVIP_GROWTH                        : "growth",
	KVIP_ADDRESS                       : "address",
	KVIP_EBCTYPE                       : "ebctype",
	KVIP_END_TIME                      : "endtime",
	KVIP_ANNUELFEE					   : "annuelfee",
	KVIP_NICKNAME                      : "nickname",
	KVIP_PASSPORT                      : "passport",
	KVIP_PASSWORD                      : "password",
	KVIP_VIP_LEVEL                     : "viplevel",
	KVIP_VIP_LEVEL_STR				   : "vipstrlevel",
	KVIP_GROWSPEED                     : "growspeed",
	KVIP_CURRENT_TIME                  : "currenttime",
	KVIP_PHOTOADDRESS                  : "photoaddress",
	KVIP_VALIDATESID_ENDTIME           : "validateendtime",
	KVIP_EXTRASERVICE_CURRENT_TIME     : "extrasevice_curtime",
	KVIP_GIFT_PACKAGE              	   : "giftpackver",
	
	// vip功能
	KVipFunction_CustomFace  		   : 1,     
	KVipFunction_NickName              : 2,
	KVipFunction_RemoteHelp            : 3,
	KVipFunction_PhotoRecovery         : 4,
	KVipFunction_DataRecovery          : 5,
	KVipFunction_Duba_VipUpdate        : 6,
	KVipFunction_Duba_VipSkin          : 7,
	KVipFunction_Duba_PopSetting       : 8,
	KVipFunction_Duba_PortableSetting  : 9,
	KVipFunction_Duba_CloudAnalysis    : 10,
	KVipFunction_Duba_VIPKeFu		   : 11,
	KVipFunction_PCInsure			   : 12,    // 电脑保险
    KVipFunction_Shopping			   : 13,    // 购物享优惠
    KVipFunction_Game                  : 14,    // 游戏特权
    KVipFunction_Movice 			   : 15,    // 电影特权
	KVipFunction_KSpeeder			   : 16,	// 网游加速器
	
	// wizardid
	KVipWizardLogin 				   : 100,
	KVipWizardApply					   : 101,
	KVipWizardInstall				   : 102,
	KVipWizardRegister				   : 103,
	KVipSetEmailAccount				   : 104,
	KVipVipCenter                      : 105,	
	
	// product id
	KVIP_CID_KIS                	   : 10001,    // 毒霸
    KVIP_CID_KSAFE              	   : 11002,    // 金山卫士
    KVIP_CID_TPAN_CLIENT        	   : 12001,    // T盘
	KVIP_CID_XUNYOU					   : 90014,    // 迅游
	
	// path
	KVIP_HEADPATH					   : 1,
	
	// 年费会员状态
	KVIP_ANNUELFEE_ISNOT     		   : 0,
    KVIP_ANNUELFEE_SERVICE			   : 1,
    KVIP_ANNUELFEE_EXPIRED			   : 2,


	// 页面链接
	_frame_title_ 				 		: "金山毒霸2011",
	_register_	 				 		: "http://pass.duba.net/reg",
	_bindemail_							: "http://pass.duba.net/route.php?act=bindingn",
	_repic_url_							: "http://vip.duba.net/space.php?do=repic",
	_kefu_url_ 							: "http://www.duba.net/imkefu?SourceID=141003102&passport=",
	_datarecovery_url_					: "http://vip.duba.net/space.php?do=datarecovery",
	_remote_url_						: "http://vip.duba.net/space.php?do=remote_help",
	_changeskin_url_					: "http://vip.duba.net/space.php?do=skin",
	_roaming_url_						: "http://vip.duba.net/space.php?do=easyset",
	_customface_url_					: "http://vip.duba.net/space.php?do=userface",
	_pcinsure_url_						: "http://ebao.duba.net/?source=13clienthyzq",
	_upgrade_url_						: "http://vip.duba.net/space.php?do=upgrade",
	_movie_url_							: "http://dianying.duba.net/index.php?",
	_msgset_url_						: "http://vip.duba.net/space.php?do=set_message"
	
};
	
var toJson = function(obj)
{
    switch (typeof(obj))
    {
        case 'string':
			var strRet ="";
			for (var i = 0; i < obj.length; i++)
			{
				if (obj.charAt(i) == '\"' || obj.charAt(i) == '\\')
					strRet += '\\';
				strRet += obj.charAt(i);
			}
            return '"' + strRet + '"';
			
        case 'number':
        case 'boolean':
            return obj.toString();
        case 'object':
            if (obj instanceof Array) 
            {
                var p = new Array();
                for (i = 0; i < obj.length; i++) 
                {
                    var v = obj[i];
                    if (null == v)
                        p.push('"' + i + '":null');
                    else if (v instanceof Function) 
                        continue;
                    else
                        p.push(toJson(v));
                }
                return '[' + p.join(',') + ']';
            }
            else if (obj instanceof Object) 
            {
                var p = new Array();
                for (i in obj) 
                {
                    var v = obj[i];
                    if (null == v)
                        p.push('"' + i + '":null');
                    else if (v instanceof Function) 
                        continue;
                    else
                        p.push('"' + i + '":' + toJson(v));
                }
                return '{' + p.join(',') + '}';
            }
            else
                return 'null';
        default:
            alert('type:' + typeof(obj));
    }
}	

function _kieframe_callback(param)
{
	try
	{
		return eval(param);
	}
	catch(e){

		}    
}
	
var KVIPImpl = {

	_Cid_			: 0,
	_SubVersion_ 	: 0,
	
	_getinterface : function()
	{
		var	IKVipObject = 0;
			
		try
		{
			var r = window.external.call('kieframe', 'testisshell', '');
			
			IKVipObject = window.external;
			
			return IKVipObject;
		}
		catch(e)
		{			
			try
			{
				if(window.ActiveXObject)   
				{			
					IKVipObject = new ActiveXObject('kvip.KVipActiveXCtrl');

					var params = {
						cid : KVIPImpl._Cid_,
						sv	: KVIPImpl._SubVersion_
						};
			
					IKVipObject.init(params);
					IKVipObject.callback = _kieframe_callback;
					
					return IKVipObject;
				}
				else  
				{
					
				}
			}
			catch(e)
			{
				alert(e.message);
			}
		}
	},	
							
	_call: function (method, param) {
        var ret = null; 
        
        try 
        {
            var strparam = '';
            if (null != param) 
                strparam = toJson(param);
			var clientinterface = KVIPImpl._getinterface();
            var r = clientinterface.call('kieframe', method, strparam);
            if (0 != r.length) 
                ret = eval('(' + r + ')');
        } 
        catch (e) 
        {
            ret = null;
        }
    
        return ret;
    },
	
	init : function(nCid, nSubVersion)
	{
		KVIPImpl._Cid_ = nCid;
		KVIPImpl._SubVersion_ = nSubVersion;
	},

	/*
	*@brief :　设置窗口标题 
	*/
	setTitle : function(title)
	{
		var params = {
			wndtitle : title
			};
		this._call(KVIP_METHOD.settitle, params);		
	},	
	
	/*
	*@brief : 关闭窗口
	*/
	closeWnd : function(nCloseType)
	{
		 var params = {
            closetype: nCloseType
			};
		try
		{
			this._call(KVIP_METHOD.closewnd, params);
		}
		catch (e){}		
	},
	
	/*
	*@brief : 获取本地通行证所有信息，以json格式返回
	*/	
	getLocalVipInfo : function()
	{		
        try 
        {
			var ret = this._call(KVIP_METHOD.getlocalvipinfo);
			return ret;
        }
        catch (e)  {}			
	},	

	/*
	*@brief : 调用viplogin
	*@param : viplogin完成后，调用finishCallback回调函数 ，如：valdidatefinish(#param#) 其中#param# 为viplogin请求返回的错误码
	*/
	login : function(passport, password, finishCallback)
	{
		 var params = {
            pp: passport,
            pwd: password,
            callfunc: finishCallback
        };
        try 
        {
			var ret = this._call(KVIP_METHOD.validate, params);
        }
        catch (e) {}			
	},	

	/* 更换SID */
    changeSid: function () {
        try 
        {
			var jsonRet = this._call(KVIP_METHOD.chsid);
			eval(jsonRet); 
			return jsonRet["sid"];
        }
        catch (e) {}
    },
	/*nPathID为1获取头像路径，其他的还没使用*/
    getPath: function (nPathID) {
        var params = {
            id: nPathID
        };
        
        try 
        {
			var jsonRet = this._call(KVIP_METHOD.getpath, params);
			eval(jsonRet); 
			return jsonRet["path"];
        }
        catch (e) {}
    },
	
	/*
	*@brief : 注册账号成功，保存账号密码到本地，保存到账号密码到桌面，然后进行viplogin
	*/
    accountHasActive: function (account, password) {
        var params = {
            a: account, // 账号
            p: password// 密码
        };
        
        try 
        {
			 var ret = this._call(KVIP_METHOD.accounthasactive, params);
        }
        catch (e) {}
    },

	/*
	*@brief : 弹出消息窗口
	*/
    showMsg: function (msg) {
        var params = {
            msg: msg
        };
        
        try 
        {
			this._call(KVIP_METHOD.showmsg, params);
        }
        catch (e) {}
    },

	/*
	*@brief : 充值窗口
	*@param : key1=value1&key2=value2
	*/
    pay: function (source) {
        var params = {
            source: source
        };
        
        try 
        {
			this._call(KVIP_METHOD.pay, params);
        }
        catch (e) {}
    },
	
	/* 调用会员向导，具体参数可以参考 KDEFMACRO wizardid */
    callWizard: function (nWizardID) {
        var params = {
            wid: nWizardID
        };
        
        try 
        {
			this._call(KVIP_METHOD.callwizard, params);
        }
        catch (e) {}
    },
	
	apply : function(finishCallback)
	{
		 var params = {
            callfunc: finishCallback
        };
		
		try
		{
			var ret = this._call(KVIP_METHOD.apply, params);
		}
		catch(e){}
	},
	
	/*
	*@brirf : 用默认浏览器打开网页
	*@param : bPPSid 链接是否需要加&pp=*&sid=*
	*/
	openUrl: function(strUrl, bPPSid)
	{
		var nsid = bPPSid ? 1 : 0;
		 var params = {
            url: strUrl,
			ppsid : nsid
        };
		
		try
		{
			var ret = this._call(KVIP_METHOD.openurl, params);
		}
		catch(e){}
	},
	
	/* 调用会员功能，具体参数可以参考 KDEFMACRO vip功能 */
	callVipFunction : function(nFunctionID)
	{
		 var params = {
            fid: nFunctionID
        };
		
		try
		{
			var ret = this._call(KVIP_METHOD.callvipfunction, params);
		}
		catch(e){}
	},	
	
	/*
	*@brief : 屏蔽脚本错误
	*/
	noJsError : function(){
		window.onerror = function(msg,url,lineno){
			var params = {
				msg : msg,
				url : url,
				lineno : lineno
				};
			this._call(KVIP_METHOD.jserror, params);	
				
			return true;
		};		
	},

	/*移动窗口*/
	moveWnd : function(nLeft, nRight, nWidth, nHeight)
	{
		 var params = {
            left	: nLeft,
			right	: nRight,
			width	: nWidth,
			height	: nHeight
			};
		try
		{
			this._call(KVIP_METHOD.movewnd, params);
		}
		catch (e){}		
	},
	
	/*
	*@brief : 移到右下角，nMarginRight右偏差，nMarginBottom下偏差
	*/
	moveToCorner : function(nMarginRight, nMarginBottom)
	{
		 var params = {
            marginright		: nMarginRight,
			marginbottom	: nMarginBottom
			};
		try
		{
			this._call(KVIP_METHOD.movetocorner, params);
		}
		catch (e){}		
	},
	
	/*显示窗口*/
	show : function()
	{
		try
		{
			this._call(KVIP_METHOD.show);
		}
		catch (e){}	
	},
	
	/*
	*@brief : infoc统计
	*@param : strTable 表名，strParam统计内容，如：key1=value1&key2=value2
	*/
	infoc : function(strTable, strParam)
	{
		 var params = {
            tablename		: strTable,
			param 			: strParam
			};
			
		try
		{
			this._call(KVIP_METHOD.infoc, params);
		}
		catch (e){}	
	},
	
	/*
	*@ brief : nShowTime 单位:分钟，-1为永久显示
	*/
	setPopShowTime : function(nShowTime)
	{
		var params = {
			showtime:nShowTime
		};
		try
		{
			this._call(KVIP_METHOD.setpopshowtime, params);
		}
		catch (e){}	
	},
	/*调整外部窗口适应网页大小*/	
	adjustWndToHtmlSize : function()
	{
		try
		{
			this._call(KVIP_METHOD.adjustwndtohtmlsize);
		}
		catch (e){}		
	},
	/*任务栏显示程序*/
	disablePaleteWnd : function()
	{
		try
		{
			this._call(KVIP_METHOD.disablepaletewnd);
		}
		catch (e){}		
	},
	/*窗口居中*/
	centerWnd : function()
	{
		try
		{
			this._call(KVIP_METHOD.centerwnd);
		}
		catch (e){}		
	},

	btnDown : function(clientX, clientY)
	{
		var params = {
			xpos:clientX,
			ypos:clientY
		};
		
		try
		{
			this._call(KVIP_METHOD.btndown, params);
		}
		catch (e){}		
	},			
	
	moveWndDx : function(clientX, clientY)
	{
		var params = {
			xpos:clientX,
			ypos:clientY
		};
		
		try
		{
			this._call(KVIP_METHOD.movewnddx, params);
		}
		catch (e){}		
	},	
	/*申请帐号*/
	requestAccount : function(finishCallback)
	{
		var params = {
            callback: finishCallback
        };
		try
		{
			this._call(KVIP_METHOD.requestaccount, params);
		}
		catch (e){}		
	},

	/*
	*@brief : 获取帐号，优先读取产品本身帐号，如果获取不到，则按下面顺序获取，毒霸，卫士，T盘，迅游
	*@return : jsonRet
	Ret[L"cid"] 		读到帐号所在的cid
	jRet[L"passport"] 	帐号
	*/
    getAccount: function(nCid) 
	{
        try 
        {
			var params = {
				cid:nCid
			};
			
			var jsonRet = this._call(KVIP_METHOD.getaccount, params);
			eval(jsonRet); 
			return jsonRet;
        }
        catch (e) {}
    },

	/*
	*@brief : 写入产品帐号
	*/
    setAccount: function (nCid, strAccount) {
        try 
        {
			var params = {
				cid:nCid,
				passport:strAccount
			};
		
			this._call(KVIP_METHOD.setaccount, params);
        }
        catch (e) {}
    },
	
	kvipProtocol : function(strCmd)
	{
		var params = {
			cmd		:	strCmd
		};			
        this._call(KVIP_METHOD.kvipprotocol, params);
	},
		
	/*
	*@brief : 调用远程,strParam远程参数，结果base64加密
	*/
    kvipRemote: function (strParam) {
        try 
        {
			var params = {
				param:strParam
			};
		
			this._call(KVIP_METHOD.kvipremote, params);
        }
        catch (e) {}
    },
    
    	/*
	*@brief :　 
	*/
	OnLuckDraw : function(nType, strCmd)
	{
        var params = {
			type:nType,
			cmd:strCmd
		};
		var jsonRet = this._call(KVIP_METHOD.luckdraw, params);
        eval(jsonRet); 
		return jsonRet;
	},

    	/*
	*@brief :　 
	*/
	OnWeibo : function(strCallback)
	{
        var params = {
			callfunc:strCallback
		};
		var jsonRet = this._call(KVIP_METHOD.weibo, params);
        eval(jsonRet); 
		return jsonRet;
	}
	// KVIPImpl end
};

KVIPImpl.noJsError();

//
function formatString(TempString, nLen)
{
	if (TempString.length > nLen)
	{
		TempString = TempString.substring(0, nLen - 3);
		TempString += "...";
	}
	return TempString;		
}
	
var KCommon = {
	
	/**
	 * @brief 		获取URL中参数值
	 * @param[in]	参数名
	 * @return 		参数值
	 */
	queryString: function (name) {
		var reg = new RegExp("(^|\\?|&)"+ name +"=([^&]*)( \\s|&|$)", "i");
		if (reg.test(location.href))
			return unescape(RegExp.$2.replace(/\+/g, " "));
		return "";
	},
	
	/*
	*@brief : 支持窗口移动
	*@param : id 为网页元素id
	*/
	CaptionMouseMove : function(id)
	{
		//加入鼠标拖动窗口
		KCommon.m_bMouseDown = false;
		var docTitle = document.getElementById(id);

		docTitle.onmouseup = function(){
		    KCommon.m_bMouseDown = false;
			docTitle.releaseCapture();
		};
		
		docTitle.onblur = function(){
		
		    KCommon.m_bMouseDown = false;
			docTitle.releaseCapture();
		};
		
		docTitle.onmousedown = function(){
			if( KCommon.m_bMouseDown == false )
			{
			    evt = window.event;
				m_xPos = evt.clientX;
				m_yPos = evt.clientY;
				
				KVIPImpl.btnDown( evt.clientX, evt.clientY );
			
				KCommon.m_bMouseDown = true;
			}
			
			docTitle.setCapture();
		};
		
		docTitle.onmousemove = function(event){
			if( KCommon.m_bMouseDown )
			{
			    evt = window.event; 
				var nDx = parseInt( evt.clientX - m_xPos );
				var nDy = parseInt( evt.clientY - m_yPos );
				
				if( Math.abs( nDx ) > 0 || Math.abs( nDy ) > 0 )
				{									
					m_xPos = evt.clientX;
					m_yPos = evt.clientY;	
					
					KVIPImpl.moveWndDx( evt.clientX, evt.clientY );	
				}
			}
		};
	} 
}; 