
// ==UserScript==
// @name       HiWifi Hosts 编辑增强工具
// @namespace  http://www.fishlee.net/
// @version    0.1
// @description  HiWifi Hosts 编辑增强工具，提供针对Hosts列表的增强编辑功能，支持导入文件、批量编辑等增强功能
// @match      https://app.hiwifi.com/store.php*
// @require		http://static.fishlee.net/resources/lib/jquery/jquery-2.0.3.js
// @copyright  2014, 木鱼
// @run-at document-idle
// ==/UserScript==

(function (w) {
	if (!/sid=37/i.test(w.location.search) || !/m=hosts/i.test(w.location.search))
		return;

	//增加按钮
	$("#pf_add").before("<button type='button' id='cmdExport' style='float:right;'>导出记录</button><div style='float:right;position:relative;'><input type='file' style='position:absolute;display:block;width:100%;height:100%;left:0;top:0;opacity:0;z-index:100;' id='iptfile'><button type='button'>导入文件</button></div><button id='changeMode' style='float:right;' type='button'>切换编辑模式</button>");
	//高级编辑
	$("#pf_box").before("<div style='display:none;' id='textEditArea'><textarea id='textEdit' style='width:100%; height:300px;'></textarea>" +
		"<div style='margin-top:10px;'><button type='button' id='cmdSelectAll'>全部选择</button> <button type='button' id='cmdClear'>清空记录</button></div></div>");

	$("#cmdSelectAll").click(function () {
		$("#textEdit")[0].select();
	});
	$("#cmdClear").click(function () {
		if (!confirm("确定要清空整个Hosts编辑器吗？"))
			return;

		$("#textEdit").val("");
	});

	//分析函数
	var parseHosts = function (txt, result) {
		var lines = txt.split(/[\r\n]/);
		result = result || {};

		for (var lindex in lines) {
			var line = lines[lindex];
			if (!line) continue;

			var args = line.split(/\s+/);
			if (args.length < 2 || !args[0] || args[0][0] == '#' || !/^[\d\.\:a-f]+$/i.test(args[0]))
				continue;

			var ip = args[0];
			var arr = result[ip] || (result[ip] = {});
			for (var i = 1; i < args.length; i++) {
				var domain = args[i];
				if (!domain || domain[0] == '#')
					continue;

				arr[domain] = null;
			}
		}

		return result;
	};

	//切换编辑模式
	$("#changeMode").click(function () {
		if ($("#textEditArea:visible").length) {
			//切换回原编辑模式
			var data = parseHosts($("#textEdit").val());
			$("tr.pf_box_v").remove();

			var html = [];
			for (var ip in data) {
				for (var domain in data[ip]) {
					html.push('<tr class="pf_box_v"><td><input type="text" class="ip txt" name="ips[]" value="' + ip + '" mouseev="true" keyev="true"></td><td><input type="text" class="port txt" name="domains[]" value="' + domain + '"></td><td><input type="button" class="pf_del" value="删除"></td></tr>');
				}
			}
			$("#pf_box tr:first").after(html.join(""));

			$("#textEditArea").hide();
			$("#pf_box").show();
		} else {
			//将内容同步到编辑框
			var ips = $("input.ip");
			var domains = $("input.port");
			var count = ips.length;
			var buffer = [];

			for (var i = 0; i < count; i++) {
				var ip = ips.eq(i).val();
				var domain = domains.eq(i).val();
				if (!ip || !domain)
					continue;

				buffer.push(ip + (ip.length <= 8 ? "\t" : "") + "\t" + domain);
			}
			$("#textEdit").val(buffer.join("\n"));


			$("#textEditArea").show();
			$("#pf_box").hide();
		}
	});

	//导出文件
	$("#cmdExport").click(function () {
		var content;
		if ($("#textEditArea:visible").length) {
			content = $("#textEdit").val();
		} else {
			//将内容同步到编辑框
			var ips = $("input.ip");
			var domains = $("input.port");
			var count = ips.length;
			var buffer = [];

			for (var i = 0; i < count; i++) {
				var ip = ips.eq(i).val();
				var domain = domains.eq(i).val();
				if (!ip || !domain)
					continue;

				buffer.push(ip + (ip.length <= 8 ? "\t" : "") + "\t" + domain);
			}
			content = buffer.join("\r\n");
		}

		var url = window.webkitURL || window.URL || window.mozURL || window.msURL;
		var a = document.createElement('a');
		a.download = 'hosts_export.txt';
		a.href = url.createObjectURL(new Blob([content], { type: 'application/octet-stream' }));
		a.textContent = '';
		a.click();
	});

	//导入文件
	$("#iptfile").change(function () {
		var files = $("#iptfile")[0].files;
		var data = {};
		var reader = new FileReader();
		var fileindex = 0;

		if (!files.length)
			return;

		reader.onerror = function () {
			alert("文件【" + files[fileindex].name + "】读取失败！");
			fileindex++;
			processFile();
		};
		reader.onload = function (e) {
			parseHosts(e.target.result, data);
			fileindex++;
			processFile();
		};
		var processFile = function () {
			if (fileindex < files.length)
				reader.readAsText(files[fileindex]);
			else {
				doImport();
			}
		};
		var doImport = function () {
			if ($("#textEditArea:visible").length) {
				parseHosts($("#textEdit").val(), data);
				var buffer = [];
				for (var ip in data) {
					buffer.push(ip);
					if (ip.length <= 8)
						buffer.push("\t");

					var count = 0;
					for (var domain in data[ip]) {
						if (count++ >= 5) {
							count = 0;
							buffer.push("\n");
							buffer.push(ip);
							if (ip.length <= 8)
								buffer.push("\t");
						}
						buffer.push("\t");
						buffer.push(domain);
					}
					buffer.push("\n");
				}
				$("#textEdit").val(buffer.join(""));
			} else {
				var html = [];
				var existsDomain = {};
				$.each($("input.port"), function () {
					existsDomain[this.value] = true;
				});

				for (var ip in data) {
					for (var domain in data[ip]) {
						if (existsDomain[domain])
							continue;
						existsDomain[domain] = true;
						html.push('<tr class="pf_box_v"><td><input type="text" class="ip txt" name="ips[]" value="' + ip + '" mouseev="true" keyev="true"></td><td><input type="text" class="port txt" name="domains[]" value="' + domain + '"></td><td><input type="button" class="pf_del" value="删除"></td></tr>');
					}
				}
				$("#pf_box tr:last").after(html.join(""));
			}

			alert("导入成功！");
		};

		processFile();
	});
})(window);