_G=GLOBAL
rawget = _G.rawget
require = _G.require



local KnownModIndex = rawget(_G,"KnownModIndex") or rawget(_G,"ModIndex")
if not KnownModIndex then
	print("ERROR: No ModIndex.")
	return --No mod index? LOL?
end

local old_IsModCompatibleWithMode = KnownModIndex.IsModCompatibleWithMode
if not old_IsModCompatibleWithMode then
	print("ERROR: No ModIndex.IsModCompatibleWithMode.")
	return
end

local really_bad_mods = {
	SmartCrockPot={name="SmartCrockPot", version="1.0",author="Nadevill"},
	["Thunder Party"]={name="Thunder Party", version="4.2",author="Brainy"},
	Link={name="Link", version="1.10",author="Dana Addams"},
	Satori={name="Satori", version="1.1.1",author="Shia and Terri"},
	
}

local function NormalMod(modinfo)
	local data = really_bad_mods[modinfo.name]
	if data~=nil then
		if data.name ~= nil then
			if modinfo.name == data.name and modinfo.version == data.version and modinfo.author == data.author then
				print("CHECKED BAD MOD - "..data.name)
				return
			end
		else
			--array of mods.
		end
	end
	return true
end

local function SW_Screen() --SW game lobby
	return _G.IsDLCEnabled(_G.REIGN_OF_GIANTS) and _G.IsDLCEnabled(_G.CAPY_DLC)
end

local known_bad_mods = {} --bad visual mods after checking modinfo (dynamic)
local old_Enable = KnownModIndex.Enable
function KnownModIndex:Enable(modname,...)
	if known_bad_mods[modname] and _G.IsDLCEnabled(_G.CAPY_DLC) then
		return
	end
	return old_Enable(self,modname,...)
end

local old_IsModCompatibleWithMode = KnownModIndex.IsModCompatibleWithMode
function KnownModIndex:IsModCompatibleWithMode(modname, dlcmode,...)
	local old = old_IsModCompatibleWithMode(self,modname, dlcmode,...)
	if old then
		return old --It's ok
	end
	local res
	local known_mod = self.savedata.known_mods[modname]
	if known_mod and not NormalMod(known_mod.modinfo) --means really bad mod
	then
		--print("Found really bad mod: ",modname) --or just lobby screen
		--local res = old_IsModCompatibleWithMode(self,modname, dlcmode,...)
		--print("Result: ",tostring(res))
		res = nil
	elseif not (KnownModIndex:IsModEnabled(modname) or KnownModIndex:IsModForceEnabled(modname)) then
		res = nil
	elseif _G.RUN_GLOBAL_INIT then --means lobby screen
		res = old
	else
		res = true
	end
	if res ~= old then
		print("CHANGED_COMPATIBLE: ",modname,known_mod and known_mod.modinfo.name,tostring(old).."->"..tostring(res))
	end
	return res
	--return true --Always true.
end--]]


local detect_bad_mod = GetModConfigData("detect_bad_mod")
if not detect_bad_mod then
	return --Do not patch the game. We do not want to see bad mods.
end

Assets =
{
	Asset("IMAGE", "images/bad_mod.tex"),
	Asset("ATLAS", "images/bad_mod.xml"),
}



--[[----------------- Add a sign to main screen on MODS button ---------
--[local OldStart=GLOBAL.Start
function Start()
	OldStart()
	AddClassPostConstruct(]
	local OldStart=GLOBAL.Start
function Start()
if true then
	local main = require "screens/mainscreen" --, function(self) --Выполняем подмену,
	--local main = self
	--_G.arr(main,2)
	local old_ShowMenu = main.ShowMenu
	function main:ShowMenu(menu_items, posX, posY,...)
		--print("old_show")
		old_ShowMenu(self,menu_items, posX, posY,...)
		for i,v in ipairs(self.menu.items) do
			--print("menu",i,v.text.string)
			if v.text.string == _G.STRINGS.UI.MAINSCREEN.MODS then
				--print("Menu!")
				local sign = v:AddChild(_G.Image("images/bad_mod.xml", "mods_enabler_krest.tex"))
				--print(sign)
				--local p = v:GetPosition()
				--print(p.x,p.y,p.z)
				sign:SetClickable(false)
				sign:SetScale(.5,.5,1)
				sign:SetPosition(-100, 5, 0)
				local sign2 = v:AddChild(_G.Image("images/bad_mod.xml", "mods_enabler_krest.tex"))
				sign2:SetClickable(false)
				sign2:SetScale(.5,.5,1)
				sign2:SetPosition(94, 5, 0)
			end
		end
	end
--end)
	end
--end
--GLOBAL.Start=Start
end
GLOBAL.Start=Start
--]]


--------------------Mark bad mods------------------






--Compatibility info
modimport("compatibility_info.lua")

local cache_mod_status = {}

io=_G.io
local function CheckCompatibilityInfo(modname)
	if cache_mod_status[modname] ~= nil then
		return cache_mod_status[modname]
	end
	for folder_name,folder in pairs(compatible_info) do
		for file_name,_ in pairs(folder) do
			local filename = folder_name == "scripts"
				and "../mods/"..modname.."/scripts/"..file_name..".lua"
				or  "../mods/"..modname.."/scripts/"..folder_name.."/"..file_name..".lua"
				
			--local f=io.open(filename,"r")
			--if f then
			if _G.kleifileexists(filename) then
				--f:close()
				cache_mod_status[modname] = fakse
				return false --Bad mod. Possible incompatibility issues.
			end
		end
	end
	cache_mod_status[modname] = true
	return true --Compatible. Good mod.
end

--Patch Mods Screen
do
	local display_rows = 5 --hard coded, sadly
	
	local scr = _G.require "screens/modsscreen"
	local old_RefreshOptions = scr.RefreshOptions
	function scr:RefreshOptions(...)
		local res = old_RefreshOptions(self,...)
		known_bad_mods = {}
		if not (self.optionspanel and self.optionspanel.items and self.option_offset and self.modnames) then
			print("ERROR: Unknown mods screen class.")
			return res
		end
		local page_total = #self.optionspanel.items
		for k = 1, page_total do
			local opt = self.optionspanel.items[k]
			local idx = self.option_offset+k
			if idx ~= opt.idx then
				print("ERROR: Something goes wrong. Avoiding possible crash...")
				break
			end
			local modname = self.modnames[idx]
			local modinfo = KnownModIndex:GetModInfo(modname)
			--_G.arr(modinfo)
			if modinfo then
				local bad = not NormalMod(modinfo)
				local image = "risky_mod.tex"
				if bad then
					known_bad_mods[modname] = true
					image = "bad_mod.tex"
				end
				if not CheckCompatibilityInfo(modname) then
					if modinfo.dont_starve_compatible and opt.DScompatible then
						opt.DScompatible:SetTexture("images/bad_mod.xml", image )
					end
					if modinfo.reign_of_giants_compatible and opt.RoGcompatible then
						opt.RoGcompatible:SetTexture("images/bad_mod.xml", image)
					end
					if modinfo.shipwrecked_compatible and opt.SWcompatible then
						opt.SWcompatible:SetTexture("images/bad_mod.xml", "sw_green_mod.tex")
					end
				end
			end
		end
		return res
	end
end

