/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.update;

import com.testin.itestin.business.actions.utils.a;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.os.c;
import com.testin.itestin.util.l;
import com.testin.javafx.b;
import com.testin.javafx.update.Updater;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import org.apache.log4j.Logger;

public class UpdateController
extends AnchorPane
implements Updater.a,
Initializable {
    static Logger log = Logger.getLogger(UpdateController.class);
    @FXML
    private ProgressBar progressBar;
    @FXML
    Label label;
    @FXML
    Label downLab;
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    com.testin.itestin.os.a handler = new com.testin.itestin.os.a(){

        @Override
        public void handleMessage(c msg) {
            switch (msg.getStatus()) {
                case 1: {
                    UpdateController.this.fileInfo(msg.getContent(), msg.V(), msg.W());
                    break;
                }
                case 2: {
                    UpdateController.this.processInfo(msg.V(), msg.W());
                    break;
                }
                case 3: {
                    UpdateController.this.hidenWindow();
                    break;
                }
                case 4: {
                    UpdateController.this.closeWindow();
                    break;
                }
                case 5: {
                    UpdateController.this.setUpdateStatus();
                }
            }
        }
    };

    private void fileInfo(String fn, int fileCount, int fileIndex) {
        this.progressBar.setProgress(0.0);
        String info = String.format(" (%s/%s)", fileIndex, fileCount);
        UIController.setLabelTextStyle(this.downLab, info);
    }

    private void setUpdateStatus() {
        UIController.setLabelTextStyle(this.label, a.n("updatecontroller.setUpdateStatus.text"));
    }

    private void processInfo(long length, long transferred) {
        if (length > 0L) {
            double d2 = (double)transferred / (double)length;
            this.progressBar.setProgress(d2);
        }
    }

    private void hidenWindow() {
        this.setVisible(false);
        UIController.setLabelTextStyle(this.label, a.n("updatecontroller.processInfo.text"));
        this.downLab.setVisible(false);
    }

    private void closeWindow() {
        b.a().a().close();
        System.exit(0);
    }

    @FXML
    public void updateOnMouseDragged(MouseEvent event) {
        if (b.a().a() == null) {
            return;
        }
        b.a().a().setX(event.getScreenX() - this.mouseDragOffsetX);
        b.a().a().setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void updateOnMousePressed(MouseEvent event) {
        if (b.a().a() == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.downLab.setVisible(true);
    }

    @FXML
    public void miniWindow(MouseEvent event) {
        b.a().a().setIconified(!b.a().a().isIconified());
    }

    @FXML
    public void updateCloseWindow(MouseEvent event) {
        this.exitWindow();
    }

    public void update() {
        Updater.getInstance().setUpdaterListener(this);
        Thread t2 = new Thread("Updater"){

            @Override
            public void run() {
                try {
                    try {
                        com.testin.itestin.business.actions.utils.c.sleep(2000L);
                        boolean res = Updater.getInstance().update();
                        if (res) {
                            UpdateController.this.hidenUpdate();
                        }
                    }
                    catch (Exception e2) {
                        log.error((Object)e2.getMessage(), (Throwable)e2);
                        UpdateController.this.exitWindow();
                        l.gc();
                    }
                }
                finally {
                    l.gc();
                }
            }
        };
        com.testin.itestin.threadpool.a.a(t2, "Update Thread");
    }

    private void hidenUpdate() {
        c msg = new c();
        msg.setStatus(3);
        this.handler.sendMessage(msg);
    }

    private void exitWindow() {
        c msg = new c();
        msg.setStatus(4);
        this.handler.sendMessage(msg);
    }

    @Override
    public void download(String fn, int fileCount, int fileIndex) {
        c msg = new c();
        msg.setStatus(1);
        msg.setContent(fn);
        msg.W(fileCount);
        msg.X(fileIndex);
        this.handler.sendMessage(msg);
    }

    @Override
    public void transferred(long length, long transferred) {
        c msg = new c();
        msg.setStatus(2);
        msg.W((int)length);
        msg.X((int)transferred);
        this.handler.sendMessage(msg);
    }

    @Override
    public void updateError() {
        c msg = new c();
        msg.setStatus(5);
        this.handler.sendMessage(msg);
    }
}

