/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.testin.itestin.business.actions.utils.a;
import com.testin.itestin.business.actions.utils.c;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;

public class ImageSetController
extends AnchorPane
implements Initializable {
    @FXML
    static Label warn;
    @FXML
    static Slider rangeSlider;
    @FXML
    static Slider unsemSlider;
    @FXML
    static Slider timeoutSlider;
    @FXML
    static TextField range;
    @FXML
    static TextField unSemblance;
    @FXML
    static TextField timeOut;
    @FXML
    static RadioButton scrollNo;
    @FXML
    static RadioButton scrollYes;
    @FXML
    ImageView image;

    @Override
    public void initialize(URL arg0, ResourceBundle arg1) {
        scrollYes.setSelected(true);
        warn.setText("");
        rangeSlider.valueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                range.setText(String.format("%.3s", arg2));
            }
        });
        unsemSlider.valueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                unSemblance.setText(String.format("%.4s", arg2));
            }
        });
        timeoutSlider.valueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                timeOut.setText(String.format("%.2s", arg2.intValue()));
            }
        });
        range.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (!c.isNumber(range.getText())) {
                    warn.setText(a.n("imagescriptalterdialog.check"));
                    range.setText("1.0");
                    return;
                }
                rangeSlider.setValue(Double.valueOf(range.getText()));
            }
        });
        unSemblance.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (!c.isNumber(unSemblance.getText())) {
                    warn.setText(a.n("imagescriptalterdialog.check"));
                    unSemblance.setText("0.35");
                    return;
                }
                unsemSlider.setValue(Double.valueOf(unSemblance.getText()));
            }
        });
        timeOut.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (!c.isNumber(timeOut.getText())) {
                    warn.setText(a.n("imagescriptalterdialog.check"));
                    timeOut.setText("30");
                    return;
                }
                timeoutSlider.setValue(Double.valueOf(timeOut.getText()));
                System.out.println("timeOut:" + timeOut.getText());
                System.out.println("timeoutSlider:" + timeoutSlider.getValue());
            }
        });
    }

    @FXML
    public void yesClick(MouseEvent event) {
        if (scrollNo.isSelected()) {
            scrollNo.setSelected(false);
        }
    }

    @FXML
    public void noClick(MouseEvent event) {
        if (scrollYes.isSelected()) {
            scrollYes.setSelected(false);
        }
    }

    public static float getImageRange() {
        return Float.valueOf(range.getText()).floatValue();
    }

    public static float getImageUnSemblance() {
        return Float.valueOf(unSemblance.getText()).floatValue();
    }

    public static int getImagetimeOut() {
        return Integer.valueOf(timeOut.getText()) * 1000;
    }

    public static Boolean getImageScroll() {
        return scrollYes.isSelected();
    }

    public void setImageRange(String rangeStr) {
        range.setText(rangeStr);
    }

    public void setImageUnSemblance(String unsem) {
        unSemblance.setText(unsem);
    }

    public void setImagetimeOut(String timeout) {
        timeOut.setText(String.valueOf(Integer.valueOf(timeout) / 1000));
    }

    public void setImageScroll(Boolean scroll) {
        scrollYes.setSelected(scroll);
        scrollNo.setSelected(scroll == false);
    }

    public void setImg(String imgFile) {
        File f2 = new File(imgFile);
        if (!f2.exists()) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(f2);
            Image icon = new Image(input);
            ((InputStream)input).close();
            this.image.setImage(icon);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }
}

