/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.alibaba.fastjson.JSONArray;
import com.testin.itestin.business.actions.coord.b;
import com.testin.itestin.business.actions.coord.j;
import com.testin.itestin.business.actions.coord.k;
import com.testin.itestin.business.actions.coord.m;
import com.testin.itestin.business.actions.coord.p;
import com.testin.itestin.business.actions.coord.r;
import com.testin.itestin.business.actions.coord.s;
import com.testin.itestin.business.minicap.d;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.device.i;
import com.testin.itestin.device.j;
import com.testin.itestin.entitys.e;
import com.testin.itestin.util.h;
import com.testin.itestin.util.l;
import com.testin.javafx.ui.control.a;
import com.testin.javafx.ui.control.g;
import com.testin.javafx.ui.control.q;
import com.testin.javafx.ui.control.z;
import com.testin.javafx.ui.include.ScriptShowController;
import com.testin.javafx.ui.include.a;
import com.testin.javafx.ui.include.c;
import com.testin.javafx.ui.include.logic.CoordEmulatorControllerLogic;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.ResourceBundle;
import java.util.concurrent.LinkedBlockingQueue;
import javafx.application.Platform;
import javafx.embed.swing.SwingFXUtils;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.input.ContextMenuEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import org.apache.log4j.Logger;

public class CoordEmulatorController
extends AnchorPane
implements com.testin.itestin.device.event.g,
ScriptShowController.ScriptShowMouseEventListener,
c,
Initializable {
    @FXML
    AnchorPane emulator;
    @FXML
    AnchorPane emulatorToolBar;
    @FXML
    AnchorPane emulatorMobile;
    @FXML
    Label screenrecord_indicator;
    @FXML
    public Label auto_refresh_indicator;
    @FXML
    Label btnMenu;
    @FXML
    Label btnBack;
    @FXML
    Label switchMinicap;
    @FXML
    static Label checkShot;
    private static boolean isChecked;
    static Logger log;
    private CoordEmulatorControllerLogic logic;
    private boolean isReplaying;
    public a canvas;
    private Thread threadCoordSendTestAction;
    private Thread threadExecActions;
    public Queue<com.testin.itestin.os.c> queueActions = new LinkedBlockingQueue<com.testin.itestin.os.c>();
    private Queue<com.testin.itestin.business.actions.m> queueExecActions = new LinkedBlockingQueue<com.testin.itestin.business.actions.m>();
    private boolean isTakeScreenShoting;
    private ContextMenu contextMenu = new ContextMenu();
    private static List<MenuItem> MenuItems;
    private static List<MenuItem> ImageMenuItems;
    private com.testin.itestin.os.a handler = new com.testin.itestin.os.a(){

        @Override
        public void handleMessage(com.testin.itestin.os.c msg) {
            switch (msg.getStatus()) {
                case 769: {
                    com.testin.itestin.business.k.a().f(true);
                    UIController.setLastActionTimeToCurrentTime();
                    CoordEmulatorController.this.updateScreen();
                    CoordEmulatorController.this.initDatas();
                    UIController.setScreenEventListener(CoordEmulatorController.this);
                    CoordEmulatorController.setCheckShotDisable(false);
                    break;
                }
                case 770: {
                    com.testin.itestin.business.k.a().f(false);
                    UIController.setLastActionTime(0L);
                    CoordEmulatorController.this.handleClearScreen();
                    CoordEmulatorController.setCheckShotDisable(true);
                    CoordEmulatorController.setCheckShot(false, false);
                    break;
                }
                case 1025: {
                    CoordEmulatorController.this.isReplaying = true;
                    UIController.setLastActionTimeToCurrentTime();
                    CoordEmulatorController.this.updateScreen();
                    break;
                }
                case 1026: {
                    CoordEmulatorController.this.isReplaying = false;
                    UIController.setLastActionTime(0L);
                    CoordEmulatorController.this.handleClearScreen();
                    break;
                }
                case 771: {
                    if (!com.testin.itestin.business.k.a().isRecording()) break;
                    UIController.setLastActionTimeToCurrentTime();
                    break;
                }
                case 772: {
                    com.testin.itestin.entitys.b image = (com.testin.itestin.entitys.b)msg.a(com.testin.itestin.entitys.b.class);
                    if (image == null || !image.isValid()) break;
                    CoordEmulatorController.this.canvas.b(image);
                    break;
                }
                case 768: {
                    CoordEmulatorController.this.handleClearScreen();
                    break;
                }
                case 1283: {
                    CoordEmulatorController.this.updateScreenRecordIndicator();
                    break;
                }
                case 1557: {
                    CoordEmulatorController.this.switchOffMinicap();
                    break;
                }
            }
        }
    };

    static {
        log = Logger.getLogger(CoordEmulatorController.class);
        MenuItems = new ArrayList<MenuItem>();
        MenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems1"), "text"));
        MenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems2"), "username"));
        MenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems3"), "password"));
        MenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems4"), "randomtext"));
        MenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems6"), "enter"));
        MenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems7"), "clicktext"));
        ImageMenuItems = new ArrayList<MenuItem>();
        ImageMenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems.image.click"), "imageClick"));
        ImageMenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems.image.longtouch"), "imageLongTouch"));
        ImageMenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems.image.doubleclick"), "imageDoubleClick"));
        ImageMenuItems.add(CoordEmulatorController.createSeparatorMenuItem());
        ImageMenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.menuitems5"), "imageAssert"));
        ImageMenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("emulatorcontroller.menuitems.if"), "imageIf"));
        ImageMenuItems.add(CoordEmulatorController.createMenuItem(com.testin.itestin.business.actions.utils.a.n("emulatorcontroller.menuitems.for"), "imageFor"));
    }

    public CoordEmulatorController() {
        UIController.setCoordEmulatorHandler(this.handler);
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        this.logic = new CoordEmulatorControllerLogic(this);
        this.initContextMenu();
        this.btnBack.setTooltip(UIController.getInternationalTooltip("coordemulator.button.back"));
        this.btnMenu.setTooltip(UIController.getInternationalTooltip("coordemulator.button.menu"));
        String OSName = System.getProperty("os.name");
        if (OSName.startsWith("Mac")) {
            checkShot.setTooltip(UIController.getInternationalTooltip("coordscriptshowcontoller.scriptshowinTable.takeimage.holdcommand"));
        } else if (OSName.startsWith("Windows")) {
            checkShot.setTooltip(UIController.getInternationalTooltip("coordscriptshowcontoller.scriptshowinTable.takeimage.holdcontrol"));
        }
        CoordEmulatorController.setCheckShotDisable(true);
        int width = com.testin.itestin.business.actions.utils.c.b(this.emulatorMobile.getPrefWidth());
        int height = com.testin.itestin.business.actions.utils.c.b(this.emulatorMobile.getPrefHeight());
        this.canvas = new a(width, height, this);
        ScriptShowController.SetScriptShowListener(this);
        this.emulatorMobile.getChildren().add(this.canvas);
    }

    private static MenuItem createMenuItem(String text, String id) {
        MenuItem menuItem = new MenuItem();
        menuItem.setId(id);
        menuItem.setText(text);
        menuItem.setStyle("-fx-font-size: 12px;-fx-font-family: \"Microsoft Yahei\",Tahoma,Arial,Helvetica,STHeiti;-fx-padding:0px 50px 0px 0px;");
        return menuItem;
    }

    private static SeparatorMenuItem createSeparatorMenuItem() {
        SeparatorMenuItem menuItem = new SeparatorMenuItem();
        return menuItem;
    }

    private void initDatas() {
        if (this.threadCoordSendTestAction != null) {
            this.threadCoordSendTestAction = null;
        }
        if (this.threadExecActions != null) {
            this.threadExecActions = null;
        }
        if (this.queueActions != null) {
            this.queueActions.clear();
        }
        if (this.queueExecActions != null) {
            this.queueExecActions.clear();
        }
    }

    @FXML
    public void autoRefreshBtnClick() {
    }

    private void updateScreen() {
        Thread screenUpdater = new Thread(){

            @Override
            public void run() {
                while (com.testin.itestin.business.k.a().isRecording() || CoordEmulatorController.this.isReplaying) {
                    long wait_time_for_next_screenshot;
                    if (!CoordEmulatorController.this.isTakeScreenShoting && (wait_time_for_next_screenshot = System.currentTimeMillis() - l.g()) > (long)l.cI) {
                        try {
                            if (!i.a(i.a())) {
                                log.info((Object)"\u8bbe\u5907\u5df2\u7ecf\u6389\u7ebf\uff01");
                                break;
                            }
                            com.testin.itestin.entitys.b screenshot = com.testin.itestin.business.utils.a.b();
                            if (screenshot != null && screenshot.isValid()) {
                                CoordEmulatorController.this.canvas.b(screenshot);
                            }
                        }
                        catch (Exception ex) {
                            log.error((Object)ex.getMessage(), (Throwable)ex);
                        }
                    }
                    com.testin.itestin.business.actions.utils.c.sleep(l.cI);
                }
                l.gc();
            }
        };
        com.testin.itestin.threadpool.a.a(screenUpdater, "Update Screen");
    }

    private void sendActionTakeScreenshot() {
        if (this.isTakeScreenShoting) {
            return;
        }
        Thread t2 = new Thread("Coord-  "){

            @Override
            public void run() {
                try {
                    CoordEmulatorController.this.isTakeScreenShoting = true;
                    int delay = 500;
                    com.testin.itestin.business.actions.utils.c.sleep(500L);
                    com.testin.itestin.entitys.b screenshot = com.testin.itestin.business.utils.a.b();
                    if (screenshot != null && screenshot.isValid()) {
                        CoordEmulatorController.this.canvas.b(screenshot);
                    }
                }
                finally {
                    CoordEmulatorController.this.isTakeScreenShoting = false;
                }
            }
        };
        com.testin.itestin.threadpool.a.a(t2, "Take Screenshot");
    }

    private void handleClearScreen() {
        this.canvas.a(0, null);
    }

    private void initContextMenu() {
        this.contextMenu.setOnAction(new EventHandler<ActionEvent>(){

            @Override
            public void handle(ActionEvent event) {
                MenuItem item = (MenuItem)event.getTarget();
                CoordEmulatorController.this.handleMenuItem(item.getId());
                CoordEmulatorController.this.hideContextMenu();
            }
        });
        this.contextMenu.getItems().addAll((Collection<MenuItem>)MenuItems);
    }

    private void handleMenuItem(String id) {
        if (id == null) {
            return;
        }
        this.startShowAndExecuteThreadIfNotAlreadyRun();
        if (id.equals("text")) {
            g response = q.a(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.handlemenuitem.text1"), "");
            if (response.a == g.a.b) {
                String value = response.value;
                com.testin.itestin.business.actions.coord.l inputAction = new com.testin.itestin.business.actions.coord.l(com.testin.itestin.business.actions.b.m, value);
                this.sendTestAction(inputAction);
                return;
            }
        } else if (id.equals("username")) {
            g response = q.a(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.handlemenuitem.text2"), "");
            if (response.a == g.a.b) {
                String value = response.value;
                com.testin.itestin.business.actions.coord.l inputAction = new com.testin.itestin.business.actions.coord.l(com.testin.itestin.business.actions.b.p, value);
                this.sendTestAction(inputAction);
                return;
            }
        } else if (id.equals("password")) {
            g response = q.a(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.handlemenuitem.text3"), "");
            if (response.a == g.a.b) {
                String value = response.value;
                com.testin.itestin.business.actions.coord.l inputAction = new com.testin.itestin.business.actions.coord.l(com.testin.itestin.business.actions.b.q, value);
                this.sendTestAction(inputAction);
                return;
            }
        } else if (id.equals("randomtext")) {
            g response = q.a(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.handlemenuitem.text4"), "4");
            if (response.a == g.a.b) {
                int len;
                String value = response.value;
                if (l.isNumber(value) && (len = Integer.parseInt(value)) > 0 && len < 20) {
                    value = com.testin.itestin.business.actions.utils.c.b(Integer.parseInt(value));
                }
                com.testin.itestin.business.actions.coord.l inputAction = new com.testin.itestin.business.actions.coord.l(com.testin.itestin.business.actions.b.n, value);
                this.sendTestAction(inputAction);
                return;
            }
        } else if (id.equals("assert")) {
            g response = q.a(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.handlemenuitem.text5"), "");
            if (response.a == g.a.b) {
                String value = response.value;
                com.testin.itestin.business.actions.coord.a assertAction = new com.testin.itestin.business.actions.coord.a(value);
                this.sendTestAction(assertAction);
                return;
            }
        } else if (id.equals("enter")) {
            p action = new p(66);
            this.sendTestAction(action);
        } else if (id.equals("clicktext")) {
            g response = q.a(com.testin.itestin.business.actions.utils.a.n("coordemulatorcontroller.handlemenuitem.text1"), "");
            if (response.a == g.a.b) {
                String value = response.value;
                b clickTextAction = new b(value);
                this.sendTestAction(clickTextAction);
                return;
            }
        } else if (id.startsWith("image")) {
            this.generateImageAction(id);
        }
    }

    private void generateLoopStartAction(int width, int height, int rotation) {
        try {
            g response = z.a(com.testin.itestin.business.actions.utils.a.n("emulatorcontroller.handlemenuitem.select.if"), "", null);
            if (response.a != g.a.b) {
                return;
            }
            int times = Integer.parseInt(response.iy.trim());
            j cfs = new j();
            if (response.selected) {
                e rec = this.logic.getRecForDragViaOkResponse(width, height, response);
                cfs = (j)this.logic.getCoordImageTouchActionByType(width, height, rotation, rec, com.testin.itestin.business.actions.d.I);
                cfs.s(true);
                cfs.s(times);
                cfs.setRange(String.valueOf(response.n));
                cfs.P(String.valueOf(response.o));
                cfs.setTimeout(5000);
                String timestamp = String.format("%s", System.currentTimeMillis());
                com.testin.itestin.business.utils.a.a(timestamp, null, (com.testin.itestin.business.actions.m)cfs);
                boolean match = this.logic.imageMatchCheck(rec, width, height, rotation, cfs);
                if (match) {
                    com.testin.itestin.business.utils.a.a.put(cfs.H(), this.logic.getThumb());
                    this.queueExecActions.offer(cfs);
                    this.logic.sendImageMatchAction(cfs);
                } else {
                    this.logic.deletRelatedPics(cfs);
                }
            } else {
                cfs.setTimeout(5000);
                cfs.s(times);
                cfs.s(false);
                this.logic.sendImageMatchAction(cfs);
            }
        }
        catch (Exception e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
    }

    private void generateImageAction(String menuCmd) {
        int w2 = i.a().G();
        int h2 = i.a().H();
        int rotation = UIController.getRotation();
        int mDockW = i.a().a().getWidth();
        int mDockH = i.a().a().getHeight();
        if (rotation == 0 || rotation == 2) {
            if (mDockW != 0 && mDockW != w2) {
                w2 = mDockW;
            }
            if (mDockH != 0 && mDockH != h2) {
                h2 = mDockH;
            }
        } else {
            if (mDockH != 0 && mDockH != h2) {
                w2 = mDockH;
            }
            if (mDockW != 0 && mDockW != w2) {
                h2 = mDockW;
            }
        }
        com.testin.itestin.business.actions.d actionType = this.logic.getActByName(menuCmd);
        System.err.println(String.format("generateImageAction W=%s, H=%s", w2, h2));
        if (actionType.equals((Object)com.testin.itestin.business.actions.d.I)) {
            this.generateLoopStartAction(w2, h2, rotation);
            return;
        }
        e rec = this.logic.getRectangleByPoints(w2, h2, actionType);
        System.err.println("~~~~~~~~RecForDrag\t" + rec);
        if (rec != null) {
            k imageAction = this.logic.getCoordImageTouchActionByType(w2, h2, rotation, rec, actionType);
            String timestamp = String.format("%s", System.currentTimeMillis());
            com.testin.itestin.business.utils.a.a(timestamp, null, (com.testin.itestin.business.actions.m)imageAction);
            boolean match = this.logic.imageMatchCheck(rec, w2, h2, rotation, imageAction);
            if (match) {
                com.testin.itestin.business.utils.a.a.put(imageAction.H(), this.logic.getThumb());
                this.queueExecActions.offer(imageAction);
                this.logic.sendImageMatchAction(imageAction);
            } else {
                this.logic.deletRelatedPics(imageAction);
            }
        }
    }

    private void sendTestAction(com.testin.itestin.business.actions.m action) {
        boolean needExecute = true;
        if (action.v()) {
            needExecute = false;
        }
        int rotation = i.a().a().getRotation();
        int mDockW = i.a().a().getWidth();
        int mDockH = i.a().a().getHeight();
        int width = i.a().G();
        int height = i.a().H();
        if (rotation == 0) {
            width = mDockW != 0 && mDockW != width ? mDockW : width;
            height = mDockH != 0 && mDockH != height ? mDockH : height;
        } else {
            width = mDockH != 0 && mDockH != height ? mDockH : height;
            height = mDockW != 0 && mDockW != width ? mDockW : width;
        }
        e rec = com.testin.itestin.business.utils.a.a(action, width, height);
        if (rec != null) {
            String timestamp = String.format("%s", System.currentTimeMillis());
            com.testin.itestin.business.utils.a.a(timestamp, null, action);
            com.testin.itestin.business.utils.a.a(this.canvas.b(), rec, action, null, false);
        }
        if (needExecute) {
            this.queueExecActions.offer(action);
        }
        if (UIController.getLastActionTime() != 0L) {
            long sleep = UIController.getActionTimeByData(action, needExecute);
            r sleepAction = new r(sleep);
            if (sleep <= 0L) {
                sleepAction = null;
            }
            if (UIController.getScriptShowHandler() != null) {
                com.testin.itestin.os.c tableMsg = new com.testin.itestin.os.c();
                if (sleepAction != null) {
                    tableMsg.setStatus(773);
                    tableMsg.setContent(sleepAction);
                    this.queueActions.offer(tableMsg);
                }
                if (com.testin.itestin.business.k.a().l()) {
                    com.testin.itestin.business.actions.coord.q takeScreenAction = new com.testin.itestin.business.actions.coord.q(UIController.getNextAutoImgName());
                    String timestamp = String.format("%s", System.currentTimeMillis());
                    String imgName = String.format("%s%s.%s", timestamp, "_shot", "png");
                    com.testin.itestin.business.utils.a.a.put(imgName, com.testin.itestin.business.utils.a.a(SwingFXUtils.fromFXImage(this.canvas.b(), null), imgName));
                    takeScreenAction.E(imgName);
                    tableMsg = new com.testin.itestin.os.c();
                    tableMsg.setStatus(773);
                    tableMsg.setContent(takeScreenAction);
                    this.queueActions.offer(tableMsg);
                }
            }
        }
        UIController.setLastActionTimeToCurrentTime();
        if (UIController.getScriptShowHandler() != null) {
            com.testin.itestin.os.c tableMsg = new com.testin.itestin.os.c();
            tableMsg.setStatus(773);
            tableMsg.setContent(action);
            this.queueActions.offer(tableMsg);
        }
        this.startShowAndExecuteThreadIfNotAlreadyRun();
    }

    private void startShowAndExecuteThreadIfNotAlreadyRun() {
        if (this.threadCoordSendTestAction == null) {
            this.threadCoordSendTestAction = new Thread("Coord-SendTestAction"){

                @Override
                public void run() {
                    while (com.testin.itestin.business.k.a().isRecording()) {
                        com.testin.itestin.os.c tableMsg = CoordEmulatorController.this.queueActions.poll();
                        if (tableMsg != null) {
                            UIController.getScriptShowHandler().sendMessage(tableMsg);
                        }
                        com.testin.itestin.business.actions.utils.c.sleep(5L);
                    }
                }
            };
            com.testin.itestin.threadpool.a.a(this.threadCoordSendTestAction, "Coord Send Test Action");
        }
        if (this.threadExecActions == null) {
            this.threadExecActions = new Thread("Coord-ExecActions"){

                @Override
                public void run() {
                    while (com.testin.itestin.business.k.a().isRecording()) {
                        com.testin.itestin.business.actions.m testaction = (com.testin.itestin.business.actions.m)CoordEmulatorController.this.queueExecActions.poll();
                        if (testaction != null) {
                            CoordEmulatorController.this.exeAction(testaction);
                            CoordEmulatorController.this.sendActionTakeScreenshot();
                        }
                        com.testin.itestin.business.actions.utils.c.sleep(5L);
                    }
                }
            };
            com.testin.itestin.threadpool.a.a(this.threadExecActions, "Coord Execute Action");
        }
    }

    private boolean exeAction(com.testin.itestin.business.actions.m action) {
        if (action.getActionType().equals((Object)com.testin.itestin.business.actions.d.h) || action.getActionType().equals((Object)com.testin.itestin.business.actions.d.z) || action.getActionType().equals((Object)com.testin.itestin.business.actions.d.g)) {
            return true;
        }
        return this.runCmd(action);
    }

    private boolean runCmd(com.testin.itestin.business.actions.m action) {
        if (!com.testin.itestin.business.k.a().isRecording()) {
            return false;
        }
        int scriptW = Integer.parseInt(com.testin.itestin.business.k.a().u().split("x")[0]);
        int scriptH = Integer.parseInt(com.testin.itestin.business.k.a().u().split("x")[1]);
        com.testin.itestin.business.a csh = new com.testin.itestin.business.a(i.a().D() == 1, i.a().G(), i.a().H(), scriptW, scriptH);
        return csh.a(action) == 0;
    }

    private boolean isSingleCaseIsRecording() {
        return com.testin.itestin.business.k.a().isRecording();
    }

    @FXML
    public void clickMenu(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseIsRecording()) {
                p action = new p(82);
                this.sendTestAction(action);
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass(this.btnMenu, "menubtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass(this.btnMenu, "menubtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass(this.btnMenu, "menubtnBkg");
            } else {
                UIController.updateNodeSytleClass(this.btnMenu, "menubtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass(this.btnMenu, "menubtnBkgPress");
            } else {
                UIController.updateNodeSytleClass(this.btnMenu, "menubtnBkgDisable");
            }
        }
    }

    @FXML
    public void clickBack(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            if (this.isSingleCaseIsRecording()) {
                p action = new p(4);
                this.sendTestAction(action);
            }
        } else if (eventType.equals("MOUSE_ENTERED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass(this.btnBack, "backbtnBkgEnter");
            } else {
                UIController.updateNodeSytleClass(this.btnBack, "backbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_EXITED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass(this.btnBack, "backbtnBkg");
            } else {
                UIController.updateNodeSytleClass(this.btnBack, "backbtnBkgDisable");
            }
        } else if (eventType.equals("MOUSE_PRESSED")) {
            if (this.isSingleCaseIsRecording()) {
                UIController.updateNodeSytleClass(this.btnBack, "backbtnBkgPress");
            } else {
                UIController.updateNodeSytleClass(this.btnBack, "backbtnBkgDisable");
            }
        }
    }

    @FXML
    public void clickScreenShot(MouseEvent event) {
        if (com.testin.itestin.business.k.a().isRecording()) {
            com.testin.itestin.business.actions.coord.q screenshot = new com.testin.itestin.business.actions.coord.q(UIController.getNextAutoImgName());
            this.sendTestAction(screenshot);
        }
    }

    @Override
    public void onMouseEvent(String json, boolean isLong) {
        System.out.println("~~~~~~~JSON: " + json);
        if (com.testin.itestin.business.k.a().isRecording()) {
            if (isLong) {
                m longTouchTA = new m(json);
                this.sendTestAction(longTouchTA);
                log.debug((Object)json);
            } else {
                s touchAction = new s(json);
                this.sendTestAction(touchAction);
                log.debug((Object)json);
            }
        }
    }

    @FXML
    public void clickEmulator(MouseEvent event) {
        block5: {
            block6: {
                if (!com.testin.itestin.business.k.a().isRecording()) break block5;
                String eventType = event.getEventType().getName();
                if (!eventType.equals("MOUSE_CLICKED")) break block6;
                MouseButton button = event.getButton();
                switch (button) {
                    case PRIMARY: {
                        this.hideContextMenu();
                        if (!CoordEmulatorController.isCheckShot() && this.canvas.a.av() && this.canvas.b(event.getX(), event.getY())) {
                            this.canvas.a.S(false);
                            break;
                        }
                        break block5;
                    }
                    case SECONDARY: {
                        break;
                    }
                }
                break block5;
            }
            event.getEventType().equals(MouseEvent.MOUSE_MOVED);
        }
    }

    private void hideContextMenu() {
        if (this.contextMenu.isShowing()) {
            this.contextMenu.hide();
        }
    }

    @FXML
    public void showContextMenu(ContextMenuEvent event) {
        if (com.testin.itestin.business.k.a().isRecording()) {
            if (CoordEmulatorController.isCheckShot() || this.canvas.a.av()) {
                this.contextMenu.getItems().clear();
                this.contextMenu.getItems().addAll((Collection<MenuItem>)ImageMenuItems);
            } else {
                this.contextMenu.getItems().clear();
                this.contextMenu.getItems().addAll((Collection<MenuItem>)MenuItems);
            }
            this.contextMenu.show(this.canvas, event.getScreenX(), event.getScreenY());
        }
    }

    @FXML
    public void clickScreenRecord(MouseEvent event) {
        if (!com.testin.itestin.business.k.a().isRecording()) {
            this.setScreenRecordAsNotReady();
            return;
        }
        if (l.ay) {
            this.setScreenRecordAsDisabled();
        } else {
            this.setScreenRecordAsEnabled();
        }
    }

    private void updateScreenRecordIndicator() {
        if (!com.testin.itestin.business.k.a().isRecording()) {
            this.setScreenRecordAsNotReady();
            return;
        }
        if (l.ay) {
            this.setScreenRecordAsEnabled();
        } else {
            this.setScreenRecordAsDisabled();
        }
    }

    private void setScreenRecordAsNotReady() {
        l.ay = false;
        Platform.runLater(new Runnable(){

            @Override
            public void run() {
                CoordEmulatorController.this.screenrecord_indicator.setTooltip(UIController.getInternationalTooltip("screen.event.detector.info"));
                CoordEmulatorController.this.screenrecord_indicator.getStyleClass().clear();
                CoordEmulatorController.this.screenrecord_indicator.getStyleClass().add("screenRecordNotReady");
            }
        });
    }

    private void setScreenRecordAsEnabled() {
        l.ay = true;
        if (UIController.isEventDetectorRunning()) {
            Platform.runLater(new Runnable(){

                @Override
                public void run() {
                    CoordEmulatorController.this.screenrecord_indicator.getStyleClass().clear();
                    CoordEmulatorController.this.screenrecord_indicator.getStyleClass().add("screenRecordEnabled");
                    CoordEmulatorController.this.screenrecord_indicator.setTooltip(UIController.getInternationalTooltip("screen.event.detector.enabled"));
                }
            });
        } else {
            log.info((Object)"screen detector thread is not running, still set indicator as not ready.");
            this.setScreenRecordAsNotReady();
        }
    }

    private void setScreenRecordAsDisabled() {
        l.ay = false;
        if (UIController.isEventDetectorRunning()) {
            Platform.runLater(new Runnable(){

                @Override
                public void run() {
                    CoordEmulatorController.this.screenrecord_indicator.getStyleClass().clear();
                    CoordEmulatorController.this.screenrecord_indicator.getStyleClass().add("screenRecordDisabled");
                    CoordEmulatorController.this.screenrecord_indicator.setTooltip(UIController.getInternationalTooltip("screen.event.detector.disabled"));
                }
            });
        } else {
            log.info((Object)"screen detector thread is not running, still set indicator as not ready.");
            this.setScreenRecordAsNotReady();
        }
    }

    @Override
    public void onDoubleClickEvent(String json) {
        if (com.testin.itestin.business.k.a().isRecording()) {
            com.testin.itestin.business.actions.coord.c action = new com.testin.itestin.business.actions.coord.c(json);
            this.sendTestAction(action);
            log.debug((Object)json);
        }
    }

    private JSONArray getRelativePointer(com.testin.itestin.device.event.i point, int rotation, long time, float pressure) {
        if (point != null && i.V()) {
            float screenwidth = i.a().G();
            float screenheight = i.a().H();
            float x2 = this.getXwithDock(point, screenwidth, screenheight, rotation);
            float y2 = this.getYWithDock(point, screenwidth, screenheight, rotation);
            JSONArray pointValue = new JSONArray();
            pointValue.add((Object)Float.valueOf(x2));
            pointValue.add((Object)Float.valueOf(y2));
            pointValue.add((Object)time);
            pointValue.add((Object)Float.valueOf(pressure));
            return pointValue;
        }
        if (point != null) {
            JSONArray pointValue = new JSONArray();
            pointValue.add((Object)Float.valueOf(point.getX()));
            pointValue.add((Object)Float.valueOf(point.getY()));
            return pointValue;
        }
        return null;
    }

    private float getXwithDock(com.testin.itestin.device.event.i point, float sourceWidth, float sourceHeight, int rotation) {
        if (com.testin.itestin.business.actions.utils.c.DEBUG) {
            System.err.println(String.format("getXXXXwithDock before W=%s, H=%s, rotation=%s", Float.valueOf(sourceWidth), Float.valueOf(sourceHeight), rotation));
        }
        float mDockW = i.a().a().getWidth();
        float mDockH = i.a().a().getHeight();
        if (rotation == 0 || rotation == 2) {
            if (mDockW != 0.0f && mDockW != sourceWidth) {
                sourceWidth = mDockW;
            }
            if (mDockH != 0.0f && mDockH != sourceHeight) {
                sourceHeight = mDockH;
            }
        } else {
            if (mDockW != 0.0f && mDockW != sourceHeight) {
                sourceHeight = mDockW;
            }
            if (mDockH != 0.0f && mDockH != sourceHeight) {
                sourceWidth = mDockH;
            }
        }
        if (com.testin.itestin.business.actions.utils.c.DEBUG) {
            System.err.println(String.format("getXXXXwithDock after W=%s, H=%s", Float.valueOf(sourceWidth), Float.valueOf(sourceHeight)));
        }
        if (rotation == 0) {
            if (point != null) {
                if (sourceWidth > 0.0f) {
                    return (float)point.getX() / sourceWidth;
                }
                return point.getX();
            }
        } else if (rotation == 1) {
            if (point != null) {
                if (sourceWidth > 0.0f) {
                    return (float)point.getY() / sourceWidth;
                }
                return point.getY();
            }
        } else if (rotation == 3 && point != null) {
            if (sourceWidth > 0.0f) {
                return (sourceHeight - (float)point.getY()) / sourceWidth;
            }
            return (sourceHeight - (float)point.getY()) / sourceWidth;
        }
        return 0.0f;
    }

    private float getYWithDock(com.testin.itestin.device.event.i point, float sourceWidth, float sourceHeight, int rotation) {
        if (com.testin.itestin.business.actions.utils.c.DEBUG) {
            System.err.println(String.format("getYYYYWithDock before W=%s, H=%s rotation=%s", Float.valueOf(sourceWidth), Float.valueOf(sourceHeight), rotation));
        }
        float mDockW = i.a().a().getWidth();
        float mDockH = i.a().a().getHeight();
        if (rotation == 0 || rotation == 2) {
            if (mDockW != 0.0f && mDockW != sourceWidth) {
                sourceWidth = mDockW;
            }
            if (mDockH != 0.0f && mDockH != sourceHeight) {
                sourceHeight = mDockH;
            }
        } else {
            if (mDockW != 0.0f && mDockW != sourceHeight) {
                sourceHeight = mDockW;
            }
            if (mDockH != 0.0f && mDockH != sourceHeight) {
                sourceWidth = mDockH;
            }
        }
        if (com.testin.itestin.business.actions.utils.c.DEBUG) {
            System.err.println(String.format("getYYYYWithDock after W=%s, H=%s", Float.valueOf(sourceWidth), Float.valueOf(sourceHeight)));
        }
        if (rotation == 0) {
            if (point != null) {
                if (sourceHeight > 0.0f) {
                    return (float)point.getY() / sourceHeight;
                }
                return point.getY();
            }
        } else if (rotation == 1) {
            if (point != null) {
                if (sourceHeight > 0.0f) {
                    return (sourceWidth - (float)point.getX()) / sourceHeight;
                }
                return (sourceWidth - (float)point.getX()) / sourceHeight;
            }
        } else if (rotation == 3 && point != null) {
            if (sourceHeight > 0.0f) {
                return (float)point.getX() / sourceHeight;
            }
            return (float)point.getX() / sourceHeight;
        }
        return 0.0f;
    }

    private JSONArray generateClickActionStr(com.testin.itestin.device.event.c event) {
        if (event != null && (event.getType() == 0 || event.getType() == 1 || event.getType() == 4)) {
            JSONArray action = new JSONArray();
            JSONArray rotation = new JSONArray();
            int rotationValue = event.Q();
            rotation.add((Object)rotationValue);
            action.add((Object)rotation);
            if (event.getType() == 1) {
                JSONArray timeUsed = new JSONArray();
                timeUsed.add((Object)(event.getEndTime() - event.getStartTime()));
                action.add((Object)timeUsed);
            }
            action.add((Object)this.getRelativePointer(event.c(), rotationValue, 0L, 0.0f));
            action.add((Object)this.getRelativePointer(event.c(), rotationValue, 0L, 0.0f));
            action.add((Object)this.getRelativePointer(event.c(), rotationValue, 0L, 0.0f));
            return action;
        }
        log.error((Object)"this is not click or long click event, cannot use it to generate click or long click action string.");
        return null;
    }

    private JSONArray generateDragActionStr(com.testin.itestin.device.event.c event) {
        if (event != null && event.getType() == 2) {
            JSONArray action = new JSONArray();
            JSONArray rotation = new JSONArray();
            int rotationValue = event.Q();
            rotation.add((Object)rotationValue);
            action.add((Object)rotation);
            ArrayList<com.testin.itestin.device.event.a> actionList = event.c();
            if (actionList != null) {
                for (com.testin.itestin.device.event.a a2 : actionList) {
                    JSONArray pointValue;
                    if (a2.a().isZero() || (pointValue = this.getRelativePointer(a2.a(), rotationValue, a2.getTime(), a2.k())) == null) continue;
                    action.add((Object)this.getRelativePointer(a2.a(), rotationValue, a2.getTime(), a2.k()));
                }
            }
            return action;
        }
        log.error((Object)"this is not drag event, cannot use it to generate drag action string.");
        return null;
    }

    @Override
    public void handleEvent(com.testin.itestin.device.event.c event) {
        s testAction;
        log.info((Object)("detected screen event: " + event));
        if (!com.testin.itestin.business.k.a().isRecording()) {
            log.info((Object)"It's not under recording state right now, ignore the event.");
            return;
        }
        if (event == null || !i.V()) {
            log.error((Object)"event is invalid, or device is not online, ignore this event.");
            return;
        }
        JSONArray action = new JSONArray();
        if (event.getType() == 0 || event.getType() == 1 || event.getType() == 4) {
            action = this.generateClickActionStr(event);
            testAction = null;
            if (event.getType() == 0) {
                testAction = new s(action);
            } else if (event.getType() == 1) {
                testAction = new m(action);
            } else if (event.getType() == 4) {
                testAction = new com.testin.itestin.business.actions.coord.c(action);
            }
            if (testAction != null) {
                testAction.n(true);
                this.sendTestAction(testAction);
            }
        }
        if (event.getType() == 2 && (action = this.generateDragActionStr(event)) != null) {
            testAction = new s(action);
            testAction.n(true);
            this.sendTestAction(testAction);
        }
        if (event.getType() == 3) {
            p keyPressAction = null;
            if (event.a().equals((Object)j.b.a)) {
                keyPressAction = new p(4);
            } else if (event.a().equals((Object)j.b.b)) {
                keyPressAction = new p(82);
            }
            if (keyPressAction != null) {
                keyPressAction.n(true);
                this.sendTestAction(keyPressAction);
            }
        }
    }

    public static boolean isCheckShotDisable() {
        return checkShot.isDisable();
    }

    public static void setCheckShotDisable(boolean disable) {
        checkShot.setDisable(disable);
    }

    public static boolean isCheckShot() {
        return isChecked;
    }

    public static void setCheckShot(boolean check, boolean wait) {
        isChecked = check;
        if (wait) {
            com.testin.itestin.business.actions.utils.c.sleep(600L);
            if (UIController.isSpaceKeyRelease()) {
                return;
            }
        }
        if (check) {
            UIController.updateNodeSytleClass(checkShot, "checkShotSelect");
        } else {
            UIController.updateNodeSytleClass(checkShot, "checkShotUnselect");
        }
    }

    @FXML
    public void clickShotCheck(MouseEvent event) {
        CoordEmulatorController.setCheckShot(!CoordEmulatorController.isCheckShot(), false);
    }

    @FXML
    public void clickSwitch(MouseEvent event) {
        if (!i.V()) {
            return;
        }
        if (!d.H()) {
            com.testin.javafx.ui.control.a.a(a.a.c, com.testin.itestin.business.actions.utils.a.n("minicap.not.support"));
        } else {
            d.x(!d.G());
            if (d.G()) {
                UIController.updateNodeSytleClass(this.switchMinicap, "switchMinicapOn");
            } else {
                this.switchOffMinicap();
            }
        }
    }

    private void switchOffMinicap() {
        d.x(false);
        UIController.updateNodeSytleClass(this.switchMinicap, "switchMinicapOff");
        d.F();
    }

    @Override
    public void onScriptShowMouseEvent(List<h> pointList, int touch) {
    }

    @Override
    public void setData(List<h> pointList, int touch) {
        System.out.println("setData: pointList");
        this.canvas.f(pointList);
        System.out.println("setData: touch=" + touch);
        a.aa(touch);
    }
}

