/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.include;

import com.testin.itestin.business.actions.utils.a;
import com.testin.itestin.business.actions.utils.c;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.Slider;
import javafx.scene.control.TextField;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;

public class ControllerSetController
extends AnchorPane
implements Initializable {
    @FXML
    static TextField con;
    @FXML
    TextField id;
    @FXML
    Slider conTimeoutSlider;
    @FXML
    static TextField timeOut;
    @FXML
    static RadioButton scrollNo;
    @FXML
    static RadioButton scrollYes;
    @FXML
    static Label warn;
    @FXML
    ImageView image;
    private String oldCon = "";

    @Override
    public void initialize(URL arg0, ResourceBundle arg1) {
        this.id.setDisable(true);
        scrollYes.setSelected(true);
        warn.setText("");
        this.conTimeoutSlider.valueProperty().addListener(new ChangeListener<Number>(){

            @Override
            public void changed(ObservableValue<? extends Number> arg0, Number arg1, Number arg2) {
                timeOut.setText(String.format("%.2s", arg2.intValue()));
            }
        });
        timeOut.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> arg0, String arg1, String arg2) {
                if (!c.isNumber(timeOut.getText())) {
                    warn.setText(a.n("imagescriptalterdialog.check"));
                    timeOut.setText("30");
                    return;
                }
                ControllerSetController.this.conTimeoutSlider.setValue(Double.valueOf(timeOut.getText()));
            }
        });
        con.focusedProperty().addListener(new ChangeListener<Boolean>(){

            @Override
            public void changed(ObservableValue<? extends Boolean> arg0, Boolean arg1, Boolean arg2) {
                if (!con.isFocused() && con.getText().isEmpty()) {
                    warn.setText(a.n("controllerset.warn"));
                    con.setText(ControllerSetController.this.oldCon);
                } else {
                    warn.setText("");
                }
            }
        });
    }

    @FXML
    public void yesClick(MouseEvent event) {
        if (scrollNo.isSelected()) {
            scrollNo.setSelected(false);
        }
    }

    @FXML
    public void noClick(MouseEvent event) {
        if (scrollYes.isSelected()) {
            scrollYes.setSelected(false);
        }
    }

    public static int getControllertimeOut() {
        return Integer.valueOf(timeOut.getText()) * 1000;
    }

    public static Boolean getControllerScroll() {
        return scrollYes.isSelected();
    }

    public void setControllertimeOut(String timeout) {
        timeOut.setText(String.valueOf(Integer.valueOf(timeout) / 1000));
    }

    public void setControllerScroll(Boolean scroll) {
        scrollYes.setSelected(scroll);
        scrollNo.setSelected(scroll == false);
    }

    public void setImg(String imgFile) {
        File f2 = new File(imgFile);
        if (!f2.exists()) {
            return;
        }
        try {
            FileInputStream input = new FileInputStream(f2);
            Image icon = new Image(input);
            ((InputStream)input).close();
            this.image.setImage(icon);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    public void setCon(String conStr) {
        con.setText(conStr);
        this.oldCon = conStr;
    }

    public static String getCon() {
        return con.getText();
    }

    public void setCId(String idStr) {
        this.id.setText(idStr);
    }

    public String getCId() {
        return this.id.getText();
    }

    public void setConDisable(Boolean isDisable) {
        con.setDisable(isDisable);
    }
}

