/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.utils.UIController;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.v;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TitledPane;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;

public class ProgressDialogController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    TitledPane title;
    @FXML
    Label message;
    @FXML
    ProgressBar progressBar;
    @FXML
    AnchorPane ProgressDialog;
    @FXML
    Button btnCancel;
    private boolean canceled;
    private v.a cancelListener;
    private Stage stage;

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public double getMyPreHeight() {
        return this.ProgressDialog.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.ProgressDialog.getPrefWidth();
    }

    public void setOptionType(v.b optionType) {
        if (optionType == v.b.b) {
            this.btnCancel.setVisible(true);
        } else {
            this.btnCancel.visibleProperty().set(false);
        }
    }

    public void setCancelListener(v.a cancelListener) {
        this.cancelListener = cancelListener;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public void show() {
        if (this.stage == null) {
            return;
        }
        this.stage.show();
    }

    public void setMessage(String message) {
        if (this.stage == null) {
            return;
        }
        this.message.setText(message);
    }

    public void setProgressValue(int value) {
        if (this.stage == null) {
            return;
        }
        double d2 = (double)value / 100.0;
        this.progressBar.setProgress(d2);
    }

    public void setProgressValue(double value) {
        if (this.stage == null) {
            return;
        }
        this.progressBar.setProgress(value);
    }

    public void close() {
        if (this.stage == null) {
            return;
        }
        this.stage.close();
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aM();
        this.ProgressDialog.getStylesheets().add(css);
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void canelBtnEnter(MouseEvent event) {
        UIController.updateNodeSytleClass(this.btnCancel, "buttonstyle_enter");
    }

    @FXML
    public void cacelBtnExit(MouseEvent event) {
        UIController.updateNodeSytleClass(this.btnCancel, "buttonstyle_normal");
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.canceled = true;
        if (this.cancelListener != null) {
            this.cancelListener.n();
        }
        this.stage.close();
    }
}

