/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.actions.utils.a;
import com.testin.itestin.business.actions.utils.c;
import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.util.l;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.g;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.EventType;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.apache.log4j.Logger;

public class InputDialogWithOptionsController
extends AnchorPane
implements Initializable {
    static Logger log = Logger.getLogger(InputDialogWithOptionsController.class);
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Label message;
    @FXML
    AnchorPane InputDialogWithOptions;
    @FXML
    TextField value;
    @FXML
    Button ok;
    @FXML
    Button cancelBtn;
    @FXML
    RadioButton usernameOpt;
    @FXML
    RadioButton passwordOpt;
    @FXML
    RadioButton normaltextOpt;
    @FXML
    RadioButton randomtextOpt;
    @FXML
    RadioButton typetextOpt;
    @FXML
    Label errorprompt;
    private Stage stage;
    private g response = new g();
    private ToggleGroup group = new ToggleGroup();
    private static /* synthetic */ int[] $SWITCH_TABLE$com$testin$itestin$business$actions$ActionRule;

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public double getMyPreHeight() {
        return this.InputDialogWithOptions.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.InputDialogWithOptions.getPrefWidth();
    }

    public void setMessage(String message) {
        if (this.stage == null) {
            return;
        }
        this.message.setText(message);
    }

    public g getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    public void setValue(String value) {
        if (this.stage == null) {
            return;
        }
        this.response.value = value;
        this.value.setText(value);
        try {
            Constructor con = MouseEvent.class.getDeclaredConstructor(EventType.class);
            con.setAccessible(true);
            Object obj = con.newInstance(MouseEvent.MOUSE_CLICKED);
            MouseEvent mouseEvent = (MouseEvent)obj;
            this.value.fireEvent(mouseEvent);
        }
        catch (NoSuchMethodException e2) {
            log.error((Object)e2.getMessage(), (Throwable)e2);
        }
        catch (SecurityException e3) {
            log.error((Object)e3.getMessage(), (Throwable)e3);
        }
        catch (InstantiationException e4) {
            log.error((Object)e4.getMessage(), (Throwable)e4);
        }
        catch (IllegalAccessException e5) {
            log.error((Object)e5.getMessage(), (Throwable)e5);
        }
        catch (IllegalArgumentException e6) {
            log.error((Object)e6.getMessage(), (Throwable)e6);
        }
        catch (InvocationTargetException e7) {
            log.error((Object)e7.getMessage(), (Throwable)e7);
        }
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass(this.ok, "buttonstyle_enter");
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass(this.ok, "buttonstyle_normal");
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass(this.cancelBtn, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass(this.cancelBtn, "buttonstyle_normal");
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aM();
        this.InputDialogWithOptions.getStylesheets().add(css);
        this.usernameOpt.setToggleGroup(this.group);
        this.usernameOpt.setUserData("username");
        this.passwordOpt.setToggleGroup(this.group);
        this.passwordOpt.setUserData("password");
        this.normaltextOpt.setToggleGroup(this.group);
        this.normaltextOpt.setUserData("text");
        this.randomtextOpt.setToggleGroup(this.group);
        this.randomtextOpt.setUserData("randomtext");
        this.typetextOpt.setToggleGroup(this.group);
        this.typetextOpt.setUserData("typetext");
        this.usernameOpt.setSelected(true);
        this.group.selectedToggleProperty().addListener((ChangeListener<Toggle>)new ChangeListener<Object>(){

            @Override
            public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
                InputDialogWithOptionsController.this.errorprompt.setText("");
            }
        });
        this.value.textProperty().addListener(new ChangeListener<String>(){

            @Override
            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                InputDialogWithOptionsController.this.checkInputValue(newValue);
            }
        });
    }

    private void checkInputValue(String newValue) {
        if (this.group.getSelectedToggle().getUserData().toString().equals("randomtext")) {
            this.checkRandomInput(newValue);
        } else if (this.group.getSelectedToggle().getUserData().toString().equals("typetext")) {
            if (c.a((CharSequence)newValue)) {
                this.errorprompt.setText(a.n("inputdialog.typetext.prompt"));
            } else {
                this.errorprompt.setText("");
            }
        } else if (newValue.length() > 100) {
            this.errorprompt.setText(a.n("inputdialog.text.toolong.prompt"));
        } else {
            this.errorprompt.setText("");
        }
    }

    @FXML
    public void clickOk(MouseEvent event) {
        this.submitInput();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.cancelInput();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyText(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.submitInput();
        }
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.submitInput();
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.cancelInput();
        }
    }

    private void submitInput() {
        this.checkInputValue(this.value.getText());
        if (this.stage == null || !this.errorprompt.getText().equals("")) {
            return;
        }
        this.response.a = g.a.b;
        this.response.value = this.value.getText();
        this.response.ix = this.group.getSelectedToggle().getUserData().toString();
        this.stage.close();
    }

    private void checkRandomInput(String value) {
        if (!l.isNumber(value)) {
            this.errorprompt.setText(a.n("inputdialog.randomtext.prompt"));
        } else {
            try {
                int len = Integer.parseInt(value);
                if (len > 0 && len <= 20) {
                    this.errorprompt.setText("");
                } else {
                    this.errorprompt.setText(a.n("inputdialog.randomtext.prompt"));
                }
            }
            catch (Exception e2) {
                e2.printStackTrace();
            }
        }
    }

    private void cancelInput() {
        this.response.a = g.a.c;
        this.response.value = null;
        this.stage.close();
    }

    public void setActionRule(com.testin.itestin.business.actions.b rule) {
        if (rule != null) {
            switch (InputDialogWithOptionsController.$SWITCH_TABLE$com$testin$itestin$business$actions$ActionRule()[rule.ordinal()]) {
                case 16: {
                    this.usernameOpt.setSelected(true);
                    break;
                }
                case 17: {
                    this.passwordOpt.setSelected(true);
                    break;
                }
                case 13: {
                    this.normaltextOpt.setSelected(true);
                    break;
                }
                case 14: {
                    this.randomtextOpt.setSelected(true);
                    break;
                }
                case 15: {
                    this.typetextOpt.setSelected(true);
                    break;
                }
            }
        }
    }

    static /* synthetic */ int[] $SWITCH_TABLE$com$testin$itestin$business$actions$ActionRule() {
        if ($SWITCH_TABLE$com$testin$itestin$business$actions$ActionRule != null) {
            return $SWITCH_TABLE$com$testin$itestin$business$actions$ActionRule;
        }
        int[] nArray = new int[com.testin.itestin.business.actions.b.a().length];
        try {
            nArray[com.testin.itestin.business.actions.b.k.ordinal()] = 11;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.b.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.f.ordinal()] = 6;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.t.ordinal()] = 20;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.g.ordinal()] = 7;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.c.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.v.ordinal()] = 22;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.i.ordinal()] = 9;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.w.ordinal()] = 23;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.u.ordinal()] = 21;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.q.ordinal()] = 17;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.d.ordinal()] = 4;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.n.ordinal()] = 14;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.h.ordinal()] = 8;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.a.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.j.ordinal()] = 10;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.m.ordinal()] = 13;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.o.ordinal()] = 15;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.l.ordinal()] = 12;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.e.ordinal()] = 5;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.p.ordinal()] = 16;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.r.ordinal()] = 18;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[com.testin.itestin.business.actions.b.s.ordinal()] = 19;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$com$testin$itestin$business$actions$ActionRule = nArray;
        return nArray;
    }
}

