/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui.control;

import com.testin.itestin.business.utils.UIController;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.a;
import com.testin.javafx.ui.control.g;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.RadioButton;
import javafx.scene.control.TextField;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleGroup;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.DirectoryChooser;
import javafx.stage.DirectoryChooserBuilder;
import javafx.stage.Stage;

public class ExportDialogWithTypeInnerController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    private static String directory = "";
    @FXML
    AnchorPane exportDialogInner;
    @FXML
    TextField value;
    @FXML
    TextField zipName;
    @FXML
    RadioButton cloudType;
    @FXML
    RadioButton localType;
    @FXML
    RadioButton innerType;
    @FXML
    Button ok;
    @FXML
    Button cancel;
    private String scriptName;
    private String appName;
    private Stage stage;
    private g response = new g();
    private ToggleGroup group = new ToggleGroup();

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public void updateZipName() {
        this.zipName.setText(String.format("%s(%s-%s)", this.scriptName, this.appName, com.testin.itestin.business.actions.utils.a.n("exporttypeselect.radiobutton1.text")));
    }

    public double getMyPreHeight() {
        return this.exportDialogInner.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.exportDialogInner.getPrefWidth();
    }

    public g getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aM();
        this.exportDialogInner.getStylesheets().add(css);
        this.cloudType.setSelected(true);
        this.cloudType.setToggleGroup(this.group);
        this.cloudType.setUserData("cloud");
        this.localType.setToggleGroup(this.group);
        this.localType.setUserData("local");
        this.innerType.setToggleGroup(this.group);
        this.innerType.setUserData("inner");
        this.group.selectedToggleProperty().addListener((ChangeListener<Toggle>)new ChangeListener<Object>(){

            @Override
            public void changed(ObservableValue<? extends Object> arg0, Object arg1, Object arg2) {
                ExportDialogWithTypeInnerController.this.updateZipName(ExportDialogWithTypeInnerController.this.group.getSelectedToggle().getUserData().toString());
            }
        });
    }

    private void updateZipName(String string) {
        if (string.equals("cloud")) {
            this.zipName.setText(String.format("%s(%s-%s)", this.scriptName, this.appName, com.testin.itestin.business.actions.utils.a.n("exporttypeselect.radiobutton1.text")));
        } else if (string.equals("local")) {
            this.zipName.setText(String.format("%s(%s-%s)", this.scriptName, this.appName, com.testin.itestin.business.actions.utils.a.n("exporttypeselect.radiobutton2.text")));
        } else if (string.equals("inner")) {
            this.zipName.setText(String.format("%s(%s-%s)", this.scriptName, this.appName, com.testin.itestin.business.actions.utils.a.n("exporttypeselect.radiobutton.inneruse.text")));
        }
    }

    @FXML
    public void clickOk(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        File f2 = new File(this.value.getText());
        if (!f2.exists()) {
            a.a(a.a.b, com.testin.itestin.business.actions.utils.a.n("folderselectdialogcontroller.selectClick.nodirectory"));
            return;
        }
        if (this.zipName.getText().equals("") || !com.testin.itestin.business.utils.a.m(this.zipName.getText())) {
            a.a(a.a.b, com.testin.itestin.business.actions.utils.a.n("apkfoldercontroller.handleMenuItem.scriptnameerror"));
            return;
        }
        if (com.testin.itestin.business.utils.a.a(this.value.getText(), String.valueOf(this.zipName.getText()) + ".zip").booleanValue()) {
            a.a(a.a.c, com.testin.itestin.business.actions.utils.a.n("folderselectdialogcontroller.selectClick.samename"));
            return;
        }
        this.response.a = g.a.b;
        this.response.value = this.value.getText();
        this.response.ix = this.zipName.getText();
        if (this.cloudType.isSelected()) {
            this.response.iy = "cloud";
        } else if (this.localType.isSelected()) {
            this.response.iy = "local";
        } else if (this.innerType.isSelected()) {
            this.response.iy = "inner";
        }
        System.err.println("select: " + this.response.iy);
        this.stage.close();
    }

    @FXML
    public void clickCancel(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.a = g.a.c;
        this.response.value = null;
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void keyOk(KeyEvent event) {
        if (event.getCharacter().equals("\r")) {
            this.clickOk(null);
        }
    }

    @FXML
    public void keyCancel(KeyEvent event) {
        if (this.stage == null) {
            return;
        }
        if (event.getCharacter().equals("\r")) {
            this.response.a = g.a.c;
            this.response.value = null;
            this.stage.close();
        }
    }

    @FXML
    public void selectClick(MouseEvent event) {
        String eventType = event.getEventType().getName();
        if (eventType.equals("MOUSE_CLICKED")) {
            DirectoryChooserBuilder builder = DirectoryChooserBuilder.create();
            String cwd = directory.isEmpty() ? System.getProperty("user.dir") : directory;
            File file = new File(cwd);
            builder.initialDirectory(file);
            DirectoryChooser chooser = builder.build();
            File chosenDir = chooser.showDialog(this.stage);
            if (chosenDir != null) {
                this.value.setText(chosenDir.getAbsolutePath());
                directory = chosenDir.getAbsolutePath();
            }
        }
    }

    @FXML
    public void nameKeyType(KeyEvent event) {
        this.keyOk(event);
    }

    @FXML
    public void cancelEnter(MouseEvent event) {
        UIController.updateNodeSytleClass(this.cancel, "buttonstyle_enter");
    }

    @FXML
    public void cancelExit(MouseEvent event) {
        UIController.updateNodeSytleClass(this.cancel, "buttonstyle_normal");
    }

    @FXML
    public void okEnter(MouseEvent event) {
        UIController.updateNodeSytleClass(this.ok, "buttonstyle_enter");
    }

    @FXML
    public void okExit(MouseEvent event) {
        UIController.updateNodeSytleClass(this.ok, "buttonstyle_normal");
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void setScriptName(String scriptName) {
        this.scriptName = scriptName;
    }

    public String getAppName() {
        return this.appName;
    }

    public void setAppName(String appName) {
        this.appName = appName;
    }
}

