/*
 * Decompiled with CFR 0.152.
 */
package com.testin.javafx.ui;

import com.testin.itestin.business.utils.UIController;
import com.testin.itestin.common.c;
import com.testin.javafx.b;
import com.testin.javafx.ui.control.a;
import com.testin.javafx.ui.control.g;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import org.apache.commons.lang.StringUtils;

public class NetDialogController
extends AnchorPane
implements Initializable {
    private double mouseDragOffsetX = 0.0;
    private double mouseDragOffsetY = 0.0;
    @FXML
    Button btnYes;
    @FXML
    Button btnNo;
    @FXML
    TextField textNetHost;
    @FXML
    TextField textNetPort;
    @FXML
    TextField textNetUser;
    @FXML
    TextField textNetPassword;
    @FXML
    ComboBox<NetType> choiceNetType;
    @FXML
    AnchorPane netDialog;
    private g response = new g();
    private Stage stage;

    public g getValue() {
        if (this.stage == null) {
            return null;
        }
        return this.response;
    }

    @Override
    public void initialize(URL location, ResourceBundle resources) {
        String css = b.a().aM();
        this.netDialog.getStylesheets().add(css);
        this.initChoiceItems();
        this.initDatas();
    }

    private void initChoiceItems() {
        this.choiceNetType.getItems().add(new NetType(0, com.testin.itestin.business.actions.utils.a.n("netset.item.proxy.no")));
        this.choiceNetType.getItems().add(new NetType(1, com.testin.itestin.business.actions.utils.a.n("netset.item.proxy.http")));
        this.choiceNetType.getItems().add(new NetType(2, "\u4f7f\u7528\u6d4f\u89c8\u5668\u4ee3\u7406"));
        this.choiceNetType.getSelectionModel().selectedItemProperty().addListener(new ChangeListener<NetType>(){

            @Override
            public void changed(ObservableValue<? extends NetType> observable, NetType oldValue, NetType newValue) {
                if (newValue.id == 0) {
                    NetDialogController.this.textNetHost.setDisable(true);
                    NetDialogController.this.textNetPort.setDisable(true);
                    NetDialogController.this.textNetUser.setDisable(true);
                    NetDialogController.this.textNetPassword.setDisable(true);
                } else if (newValue.id == 1) {
                    NetDialogController.this.textNetHost.setDisable(false);
                    NetDialogController.this.textNetPort.setDisable(false);
                    NetDialogController.this.textNetUser.setDisable(false);
                    NetDialogController.this.textNetPassword.setDisable(false);
                } else if (newValue.id == 2) {
                    NetDialogController.this.textNetHost.setDisable(true);
                    NetDialogController.this.textNetHost.setText("");
                    NetDialogController.this.textNetPort.setDisable(true);
                    NetDialogController.this.textNetPort.setText("0");
                    NetDialogController.this.textNetUser.setEditable(true);
                    NetDialogController.this.textNetPassword.setEditable(true);
                    NetDialogController.this.textNetUser.setDisable(true);
                    NetDialogController.this.textNetPassword.setDisable(true);
                }
            }
        });
    }

    private void initDatas() {
        if (c.by == 0) {
            this.choiceNetType.getSelectionModel().select(0);
            this.textNetHost.setText(c.eq);
            this.textNetPort.setText(String.valueOf(c.proxyPort));
            this.textNetUser.setText(c.er);
            this.textNetPassword.setText(c.es);
        } else if (c.by == 1) {
            this.choiceNetType.getSelectionModel().select(1);
            this.textNetHost.setText(c.eq);
            this.textNetPort.setText(String.valueOf(c.proxyPort));
            this.textNetUser.setText(c.er);
            this.textNetPassword.setText(c.es);
        } else if (c.by == 2) {
            this.choiceNetType.getSelectionModel().select(2);
            this.textNetUser.setText(c.er);
            this.textNetPassword.setText(c.es);
        }
    }

    public void setStage(Stage stage) {
        this.stage = stage;
    }

    public double getMyPreHeight() {
        return this.netDialog.getPrefHeight();
    }

    public double getMyPreWidth() {
        return this.netDialog.getPrefWidth();
    }

    public void show() {
        if (this.stage == null) {
            return;
        }
        this.stage.show();
    }

    public void close() {
        if (this.stage == null) {
            return;
        }
        this.stage.close();
    }

    @FXML
    public void topOnMouseDragged(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.stage.setX(event.getScreenX() - this.mouseDragOffsetX);
        this.stage.setY(event.getScreenY() - this.mouseDragOffsetY);
    }

    @FXML
    public void topOnMousePressed(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.mouseDragOffsetX = event.getSceneX();
        this.mouseDragOffsetY = event.getSceneY();
    }

    @FXML
    public void clickBtnYes(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        NetType netType = (NetType)this.choiceNetType.getSelectionModel().getSelectedItem();
        if (netType.id == 1) {
            if (StringUtils.isEmpty((String)this.textNetHost.getText())) {
                a.a(a.a.c, com.testin.itestin.business.actions.utils.a.n("netset.error.addr"));
                return;
            }
            if (StringUtils.isEmpty((String)this.textNetPort.getText())) {
                a.a(a.a.c, com.testin.itestin.business.actions.utils.a.n("netset.error.port.str"));
                return;
            }
            if (!StringUtils.isNumeric((String)this.textNetPort.getText())) {
                a.a(a.a.c, com.testin.itestin.business.actions.utils.a.n("netset.error.port.num"));
                return;
            }
            c.by = netType.id;
            c.eq = this.textNetHost.getText().trim();
            c.proxyPort = Integer.parseInt(this.textNetPort.getText().trim());
            c.er = this.textNetUser.getText().trim();
            c.es = this.textNetPassword.getText().trim();
            c.save();
        } else if (netType.id == 2) {
            c.by = netType.id;
            c.er = this.textNetUser.getText().trim();
            c.es = this.textNetPassword.getText().trim();
            c.save();
        } else {
            c.by = 0;
            c.eq = this.textNetHost.getText().trim();
            c.proxyPort = Integer.parseInt(this.textNetPort.getText().trim());
            c.er = this.textNetUser.getText().trim();
            c.es = this.textNetPassword.getText().trim();
            c.save();
        }
        this.response.a = g.a.b;
        this.stage.close();
    }

    @FXML
    public void btnNoEnter(MouseEvent event) {
        UIController.updateNodeSytleClass(this.btnNo, "buttonstyle_enter");
    }

    @FXML
    public void btnYesEnter(MouseEvent event) {
        UIController.updateNodeSytleClass(this.btnYes, "buttonstyle_enter");
    }

    @FXML
    public void btnNoExit(MouseEvent event) {
        UIController.updateNodeSytleClass(this.btnNo, "buttonstyle_normal");
    }

    @FXML
    public void btnYesExit(MouseEvent event) {
        UIController.updateNodeSytleClass(this.btnYes, "buttonstyle_normal");
    }

    @FXML
    public void clickBtnNo(MouseEvent event) {
        if (this.stage == null) {
            return;
        }
        this.response.a = g.a.d;
        this.stage.close();
    }

    class NetType {
        int id;
        String name;

        public NetType(int id, String name) {
            this.id = id;
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

