/*
 * Decompiled with CFR 0.152.
 */
package georegression.struct.point;

import georegression.geometry.GeometryMath_F64;
import georegression.geometry.UtilVector3D_F64;
import georegression.struct.GeoTuple3D_F64;
import georegression.struct.point.Point3D_F64;

public class Vector3D_F64
extends GeoTuple3D_F64<Vector3D_F64> {
    public Vector3D_F64(GeoTuple3D_F64 orig) {
        this(orig.x, orig.y, orig.z);
    }

    public Vector3D_F64(double x, double y, double z) {
        super(x, y, z);
    }

    public Vector3D_F64() {
    }

    public Vector3D_F64(Point3D_F64 a, Point3D_F64 b) {
        this.x = b.getX() - a.getX();
        this.y = b.getY() - a.getY();
        this.z = b.getZ() - a.getZ();
    }

    public void set(Vector3D_F64 v) {
        this.x = v.x;
        this.y = v.y;
        this.z = v.z;
    }

    public void minus(Point3D_F64 a, Point3D_F64 b) {
        this.x = a.x - b.x;
        this.y = a.y - b.y;
        this.z = a.z - b.z;
    }

    @Override
    public Vector3D_F64 copy() {
        return new Vector3D_F64(this.x, this.y, this.z);
    }

    public void cross(Vector3D_F64 a, Vector3D_F64 b) {
        GeometryMath_F64.cross(a, (GeoTuple3D_F64)b, (GeoTuple3D_F64)this);
    }

    public Vector3D_F64 cross(Vector3D_F64 b) {
        Vector3D_F64 c = new Vector3D_F64();
        GeometryMath_F64.cross(this, (GeoTuple3D_F64)b, (GeoTuple3D_F64)c);
        return c;
    }

    @Override
    public Vector3D_F64 createNewInstance() {
        return new Vector3D_F64();
    }

    public String toString() {
        return "V( " + this.x + " " + this.y + " " + this.z + " )";
    }

    public void normalize() {
        double r = this.norm();
        this.x /= r;
        this.y /= r;
        this.z /= r;
    }

    public double dot(Vector3D_F64 a) {
        return this.x * a.x + this.y * a.y + this.z * a.z;
    }

    public double acute(Vector3D_F64 a) {
        return UtilVector3D_F64.acute(this, a);
    }
}

