/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.struct.point.Vector3D_F32;
import java.util.Random;
import org.ejml.data.DenseMatrix64F;

public class UtilVector3D_F32 {
    public static Vector3D_F32 createRandom(float min, float max, Random rand) {
        float range = max - min;
        Vector3D_F32 a = new Vector3D_F32();
        a.x = range * rand.nextFloat() + min;
        a.y = range * rand.nextFloat() + min;
        a.z = range * rand.nextFloat() + min;
        return a;
    }

    public static boolean isIdentical(Vector3D_F32 a, Vector3D_F32 b, float tol) {
        if (Math.abs(a.x - b.x) > tol) {
            return false;
        }
        if (Math.abs(a.y - b.y) > tol) {
            return false;
        }
        return Math.abs(a.z - b.z) <= tol;
    }

    public static void normalize(Vector3D_F32 v) {
        float a = v.norm();
        v.x /= a;
        v.y /= a;
        v.z /= a;
    }

    public static DenseMatrix64F createMatrix(DenseMatrix64F R, Vector3D_F32 ... v) {
        if (R == null) {
            R = new DenseMatrix64F(3, v.length);
        }
        for (int i = 0; i < v.length; ++i) {
            R.set(0, i, (double)v[i].x);
            R.set(1, i, (double)v[i].y);
            R.set(2, i, (double)v[i].z);
        }
        return R;
    }

    public static Vector3D_F32 convert(DenseMatrix64F m) {
        Vector3D_F32 v = new Vector3D_F32();
        v.x = (float)m.data[0];
        v.y = (float)m.data[1];
        v.z = (float)m.data[2];
        return v;
    }

    public static float acute(Vector3D_F32 a, Vector3D_F32 b) {
        float dot = a.dot(b);
        float value = dot / (a.norm() * b.norm());
        if (value > 1.0f) {
            value = 1.0f;
        } else if (value < -1.0f) {
            value = -1.0f;
        }
        return (float)Math.acos(value);
    }
}

