/*
 * Decompiled with CFR 0.152.
 */
package georegression.geometry;

import georegression.geometry.GeometryMath_F64;
import georegression.misc.GrlConstants;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.so.Quaternion_F32;
import georegression.struct.so.Quaternion_F64;
import georegression.struct.so.Rodrigues_F32;
import georegression.struct.so.Rodrigues_F64;
import org.ejml.UtilEjml;
import org.ejml.data.Complex64F;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.decomposition.SingularValueDecomposition;
import org.ejml.ops.CommonOps;

public class RotationMatrixGenerator {
    public static DenseMatrix64F rodriguesToMatrix(Rodrigues_F64 rodrigues, DenseMatrix64F R) {
        R = RotationMatrixGenerator.checkDeclare3x3(R);
        double x = rodrigues.unitAxisRotation.x;
        double y = rodrigues.unitAxisRotation.y;
        double z = rodrigues.unitAxisRotation.z;
        double c = Math.cos(rodrigues.theta);
        double s = Math.sin(rodrigues.theta);
        double oc = 1.0 - c;
        R.data[0] = c + x * x * oc;
        R.data[1] = x * y * oc - z * s;
        R.data[2] = x * z * oc + y * s;
        R.data[3] = y * x * oc + z * s;
        R.data[4] = c + y * y * oc;
        R.data[5] = y * z * oc - x * s;
        R.data[6] = z * x * oc - y * s;
        R.data[7] = z * y * oc + x * s;
        R.data[8] = c + z * z * oc;
        return R;
    }

    public static DenseMatrix64F rodriguesToMatrix(Rodrigues_F32 rodrigues, DenseMatrix64F R) {
        R = RotationMatrixGenerator.checkDeclare3x3(R);
        double x = rodrigues.unitAxisRotation.x;
        double y = rodrigues.unitAxisRotation.y;
        double z = rodrigues.unitAxisRotation.z;
        double c = Math.cos(rodrigues.theta);
        double s = Math.sin(rodrigues.theta);
        double oc = 1.0 - c;
        R.data[0] = c + x * x * oc;
        R.data[1] = x * y * oc - z * s;
        R.data[2] = x * z * oc + y * s;
        R.data[3] = y * x * oc + z * s;
        R.data[4] = c + y * y * oc;
        R.data[5] = y * z * oc - x * s;
        R.data[6] = z * x * oc - y * s;
        R.data[7] = z * y * oc + x * s;
        R.data[8] = c + z * z * oc;
        return R;
    }

    public static Quaternion_F64 rodriguesToQuaternion(Rodrigues_F64 rodrigues, Quaternion_F64 quat) {
        if (quat == null) {
            quat = new Quaternion_F64();
        }
        quat.w = Math.cos(rodrigues.theta / 2.0);
        double s = Math.sin(rodrigues.theta / 2.0);
        quat.x = rodrigues.unitAxisRotation.x * s;
        quat.y = rodrigues.unitAxisRotation.y * s;
        quat.z = rodrigues.unitAxisRotation.z * s;
        return quat;
    }

    public static Quaternion_F64 quaternionToRodrigues(Quaternion_F64 quat, Rodrigues_F64 rodrigues) {
        if (rodrigues == null) {
            rodrigues = new Rodrigues_F64();
        }
        rodrigues.unitAxisRotation.set(quat.x, quat.y, quat.z);
        rodrigues.unitAxisRotation.normalize();
        rodrigues.theta = 2.0 * Math.acos(quat.w);
        return quat;
    }

    public static Quaternion_F64 matrixToQuaternion(DenseMatrix64F R, Quaternion_F64 quat) {
        Rodrigues_F64 r = RotationMatrixGenerator.matrixToRodrigues(R, (Rodrigues_F64)null);
        return RotationMatrixGenerator.rodriguesToQuaternion(r, quat);
    }

    public static Rodrigues_F64 matrixToRodrigues(DenseMatrix64F R, Rodrigues_F64 rodrigues) {
        double diagSum;
        double absDiagSum;
        if (rodrigues == null) {
            rodrigues = new Rodrigues_F64();
        }
        if ((absDiagSum = Math.abs(diagSum = (R.get(0, 0) + R.get(1, 1) + R.get(2, 2) - 1.0) / 2.0)) < 1.0) {
            rodrigues.theta = Math.acos(diagSum);
            double bottom = 2.0 * Math.sin(rodrigues.theta);
            rodrigues.unitAxisRotation.x = (R.get(2, 1) - R.get(1, 2)) / bottom;
            rodrigues.unitAxisRotation.y = (R.get(0, 2) - R.get(2, 0)) / bottom;
            rodrigues.unitAxisRotation.z = (R.get(1, 0) - R.get(0, 1)) / bottom;
            rodrigues.unitAxisRotation.normalize();
        } else {
            rodrigues.theta = 0.0;
            rodrigues.unitAxisRotation.set(1.0, 0.0, 0.0);
        }
        return rodrigues;
    }

    public static Rodrigues_F32 matrixToRodrigues(DenseMatrix64F R, Rodrigues_F32 rodrigues) {
        double diagSum;
        double absDiagSum;
        if (rodrigues == null) {
            rodrigues = new Rodrigues_F32();
        }
        if ((absDiagSum = Math.abs(diagSum = (R.get(0, 0) + R.get(1, 1) + R.get(2, 2) - 1.0) / 2.0)) < 1.0) {
            rodrigues.theta = (float)Math.acos(diagSum);
            double bottom = 2.0 * Math.sin(rodrigues.theta);
            rodrigues.unitAxisRotation.x = (float)((R.get(2, 1) - R.get(1, 2)) / bottom);
            rodrigues.unitAxisRotation.y = (float)((R.get(0, 2) - R.get(2, 0)) / bottom);
            rodrigues.unitAxisRotation.z = (float)((R.get(1, 0) - R.get(0, 1)) / bottom);
            rodrigues.unitAxisRotation.normalize();
        } else {
            rodrigues.theta = 0.0f;
            rodrigues.unitAxisRotation.set(1.0f, 0.0f, 0.0f);
        }
        return rodrigues;
    }

    public static Vector3D_F64 rotationAxis(DenseMatrix64F R, Vector3D_F64 ret) {
        EigenDecomposition eig;
        if (ret == null) {
            ret = new Vector3D_F64();
        }
        if (!(eig = DecompositionFactory.eig((int)R.numRows, (boolean)true)).decompose((Matrix64F)R)) {
            throw new RuntimeException("Decomposition failed");
        }
        int bestIndex = -1;
        double best = Double.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            double diff;
            Complex64F e = eig.getEigenvalue(i);
            if (!e.isReal() || !((diff = Math.abs(e.getReal() - 1.0)) < best)) continue;
            best = diff;
            bestIndex = i;
        }
        if (bestIndex == -1) {
            throw new RuntimeException("Couldn't find a valid eigenvalue.  If the matrix is valid report this as a bug.");
        }
        DenseMatrix64F v = (DenseMatrix64F)eig.getEigenVector(bestIndex);
        ret.set(v.get(0, 0), v.get(1, 0), v.get(2, 0));
        return ret;
    }

    public static double rotationAngle(DenseMatrix64F R, Vector3D_F64 axisOfRotation) {
        int row = 0;
        double smallestDot = Double.MAX_VALUE;
        for (int i = 0; i < 3; ++i) {
            double dot = R.get(i, 0) * axisOfRotation.getX() + R.get(i, 1) * axisOfRotation.getY() + R.get(i, 2) * axisOfRotation.getZ();
            double v = Math.abs(dot);
            if (!(v < smallestDot)) continue;
            row = i;
            smallestDot = v;
        }
        Vector3D_F64 a = new Vector3D_F64();
        a.set(R.get(row, 0), R.get(row, 1), R.get(row, 2));
        Vector3D_F64 b = axisOfRotation.cross(a);
        b.normalize();
        GeometryMath_F64.mult(R, b, a);
        double theta = Math.acos(GeometryMath_F64.dot(a, b));
        Vector3D_F64 c = b.cross(a);
        double dot = c.dot(axisOfRotation);
        if (dot < 0.0) {
            theta = -theta;
        }
        return theta;
    }

    public static DenseMatrix64F rotX(double ang, DenseMatrix64F R) {
        if (R == null) {
            R = new DenseMatrix64F(3, 3);
        }
        RotationMatrixGenerator.setRotX(ang, R);
        return R;
    }

    public static void setRotX(double ang, DenseMatrix64F r) {
        double c = Math.cos(ang);
        double s = Math.sin(ang);
        r.set(0, 0, 1.0);
        r.set(1, 1, c);
        r.set(1, 2, -s);
        r.set(2, 1, s);
        r.set(2, 2, c);
    }

    public static DenseMatrix64F rotY(double ang, DenseMatrix64F R) {
        if (R == null) {
            R = new DenseMatrix64F(3, 3);
        }
        RotationMatrixGenerator.setRotY(ang, R);
        return R;
    }

    public static void setRotY(double ang, DenseMatrix64F r) {
        double c = Math.cos(ang);
        double s = Math.sin(ang);
        r.set(0, 0, c);
        r.set(0, 2, s);
        r.set(1, 1, 1.0);
        r.set(2, 0, -s);
        r.set(2, 2, c);
    }

    public static DenseMatrix64F rotZ(double ang, DenseMatrix64F R) {
        if (R == null) {
            R = new DenseMatrix64F(3, 3);
        }
        RotationMatrixGenerator.setRotZ(ang, R);
        return R;
    }

    public static void setRotZ(double ang, DenseMatrix64F r) {
        double c = Math.cos(ang);
        double s = Math.sin(ang);
        r.set(0, 0, c);
        r.set(0, 1, -s);
        r.set(1, 0, s);
        r.set(1, 1, c);
        r.set(2, 2, 1.0);
    }

    public static DenseMatrix64F eulerArbitrary(int axisA, int axisB, int axisC, double rotA, double rotB, double rotC) {
        DenseMatrix64F R_a = RotationMatrixGenerator.createRot(axisA, rotA, null);
        DenseMatrix64F R_b = RotationMatrixGenerator.createRot(axisB, rotB, null);
        DenseMatrix64F R_c = RotationMatrixGenerator.createRot(axisC, rotC, null);
        DenseMatrix64F A = new DenseMatrix64F(3, 3);
        DenseMatrix64F R = new DenseMatrix64F(3, 3);
        CommonOps.mult((RowD1Matrix64F)R_b, (RowD1Matrix64F)R_a, (RowD1Matrix64F)A);
        CommonOps.mult((RowD1Matrix64F)R_c, (RowD1Matrix64F)A, (RowD1Matrix64F)R);
        return R;
    }

    private static DenseMatrix64F createRot(int axis, double angle, DenseMatrix64F R) {
        switch (axis) {
            case 0: {
                return RotationMatrixGenerator.rotX(angle, R);
            }
            case 1: {
                return RotationMatrixGenerator.rotY(angle, R);
            }
            case 2: {
                return RotationMatrixGenerator.rotZ(angle, R);
            }
        }
        throw new IllegalArgumentException("Unknown which");
    }

    public static DenseMatrix64F eulerXYZ(double rotX, double rotY, double rotZ, DenseMatrix64F R) {
        if (R == null) {
            R = new DenseMatrix64F(3, 3);
        }
        double c1 = Math.cos(rotX);
        double c2 = Math.cos(rotY);
        double c3 = Math.cos(rotZ);
        double s1 = Math.sin(rotX);
        double s2 = Math.sin(rotY);
        double s3 = Math.sin(rotZ);
        R.set(0, 0, c2 * c3);
        R.set(0, 1, c3 * s1 * s2 - c1 * s3);
        R.set(0, 2, c1 * c3 * s2 + s1 * s3);
        R.set(1, 0, c2 * s3);
        R.set(1, 1, c1 * c3 + s1 * s2 * s3);
        R.set(1, 2, c1 * s2 * s3 - c3 * s1);
        R.set(2, 0, -s2);
        R.set(2, 1, c2 * s1);
        R.set(2, 2, c1 * c2);
        return R;
    }

    public static double[] matrixToEulerXYZ(DenseMatrix64F M, double[] euler) {
        double rotX;
        double rotY;
        double rotZ;
        double m31;
        if (euler == null) {
            euler = new double[3];
        }
        if (Math.abs(Math.abs(m31 = M.get(2, 0)) - 1.0) < UtilEjml.EPS) {
            double m12 = M.get(0, 1);
            double m13 = M.get(0, 2);
            rotZ = 0.0;
            double gamma = Math.atan2(m12, m13);
            if (m31 < 0.0) {
                rotY = 1.5707963267948966;
                rotX = rotZ + gamma;
            } else {
                rotY = -1.5707963267948966;
                rotX = -rotZ + gamma;
            }
        } else {
            double m32 = M.get(2, 1);
            double m33 = M.get(2, 2);
            double m21 = M.get(1, 0);
            double m11 = M.get(0, 0);
            rotY = -Math.asin(m31);
            double cosRotY = Math.cos(rotY);
            rotX = Math.atan2(m32 / cosRotY, m33 / cosRotY);
            rotZ = Math.atan2(m21 / cosRotY, m11 / cosRotY);
        }
        euler[0] = rotX;
        euler[1] = rotY;
        euler[2] = rotZ;
        return euler;
    }

    public static float[] matrixToEulerXYZ(DenseMatrix64F M, float[] euler) {
        double rotX;
        double rotY;
        double rotZ;
        double m31;
        if (euler == null) {
            euler = new float[3];
        }
        if (Math.abs(Math.abs(m31 = M.get(2, 0)) - 1.0) < GrlConstants.EPS) {
            double m12 = M.get(0, 1);
            double m13 = M.get(0, 2);
            rotZ = 0.0;
            double gamma = Math.atan2(m12, m13);
            if (m31 < 0.0) {
                rotY = 1.5707963267948966;
                rotX = rotZ + gamma;
            } else {
                rotY = -1.5707963267948966;
                rotX = -rotZ + gamma;
            }
        } else {
            double m32 = M.get(2, 1);
            double m33 = M.get(2, 2);
            double m21 = M.get(1, 0);
            double m11 = M.get(0, 0);
            rotY = -Math.asin(m31);
            double cosRotY = Math.cos(rotY);
            rotX = Math.atan2(m32 / cosRotY, m33 / cosRotY);
            rotZ = Math.atan2(m21 / cosRotY, m11 / cosRotY);
        }
        euler[0] = (float)rotX;
        euler[1] = (float)rotY;
        euler[2] = (float)rotZ;
        return euler;
    }

    public static DenseMatrix64F approximateRotationMatrix(DenseMatrix64F orig, DenseMatrix64F R) {
        SingularValueDecomposition svd;
        if (R == null) {
            R = new DenseMatrix64F(3, 3);
        }
        if (!(svd = DecompositionFactory.svd((int)orig.numRows, (int)orig.numCols, (boolean)true, (boolean)true, (boolean)false)).decompose((Matrix64F)orig)) {
            throw new RuntimeException("SVD Failed");
        }
        CommonOps.mult((RowD1Matrix64F)((RowD1Matrix64F)svd.getU(null, false)), (RowD1Matrix64F)((RowD1Matrix64F)svd.getV(null, true)), (RowD1Matrix64F)R);
        double det = CommonOps.det((DenseMatrix64F)R);
        if (det < 0.0) {
            CommonOps.scale((double)-1.0, (D1Matrix64F)R);
        }
        return R;
    }

    public static void eulerToQuaternions(double[] euler, Quaternion_F64 quat) {
        double yaw = euler[0];
        double roll = euler[1];
        double pitch = euler[2];
        double cy = Math.cos(yaw * 0.5);
        double sy = Math.sin(yaw * 0.5);
        double cp = Math.cos(pitch * 0.5);
        double sp = Math.sin(pitch * 0.5);
        double cr = Math.cos(roll * 0.5);
        double sr = Math.sin(roll * 0.5);
        double ccc = cr * cp * cy;
        double ccs = cr * cp * sy;
        double css = cr * sp * sy;
        double sss = sr * sp * sy;
        double scc = sr * cp * cy;
        double ssc = sr * sp * cy;
        double csc = cr * sp * cy;
        double scs = sr * cp * sy;
        quat.w = ccc + sss;
        quat.x = scc - css;
        quat.y = csc + scs;
        quat.z = ccs - ssc;
    }

    public static double[] quaternionsToEuler(Quaternion_F64 quaternion, double[] euler) {
        return null;
    }

    public static DenseMatrix64F quaternionToMatrix(Quaternion_F64 quat, DenseMatrix64F R) {
        R = RotationMatrixGenerator.checkDeclare3x3(R);
        double q0 = quat.w;
        double q1 = quat.x;
        double q2 = quat.y;
        double q3 = quat.z;
        R.set(0, 0, q0 * q0 + q1 * q1 - q2 * q2 - q3 * q3);
        R.set(0, 1, 2.0 * (q1 * q2 - q0 * q3));
        R.set(0, 2, 2.0 * (q1 * q3 + q0 * q2));
        R.set(1, 0, 2.0 * (q1 * q2 + q0 * q3));
        R.set(1, 1, q0 * q0 - q1 * q1 + q2 * q2 - q3 * q3);
        R.set(1, 2, 2.0 * (q2 * q3 - q0 * q1));
        R.set(2, 0, 2.0 * (q1 * q3 - q0 * q2));
        R.set(2, 1, 2.0 * (q2 * q3 + q0 * q1));
        R.set(2, 2, q0 * q0 - q1 * q1 - q2 * q2 + q3 * q3);
        return R;
    }

    public static DenseMatrix64F quaternionToMatrix(Quaternion_F32 quat, DenseMatrix64F R) {
        R = RotationMatrixGenerator.checkDeclare3x3(R);
        double q0 = quat.w;
        double q1 = quat.x;
        double q2 = quat.y;
        double q3 = quat.z;
        R.set(0, 0, q0 * q0 + q1 * q1 - q2 * q2 - q3 * q3);
        R.set(0, 1, 2.0 * (q1 * q2 - q0 * q3));
        R.set(0, 2, 2.0 * (q1 * q3 + q0 * q2));
        R.set(1, 0, 2.0 * (q1 * q2 + q0 * q3));
        R.set(1, 1, q0 * q0 - q1 * q1 + q2 * q2 - q3 * q3);
        R.set(1, 2, 2.0 * (q2 * q3 - q0 * q1));
        R.set(2, 0, 2.0 * (q1 * q3 - q0 * q2));
        R.set(2, 1, 2.0 * (q2 * q3 + q0 * q1));
        R.set(2, 2, q0 * q0 - q1 * q1 - q2 * q2 + q3 * q3);
        return R;
    }

    private static DenseMatrix64F checkDeclare3x3(DenseMatrix64F R) {
        if (R == null) {
            R = new DenseMatrix64F(3, 3);
        } else if (R.numRows != 3 || R.numCols != 3) {
            throw new IllegalArgumentException("Expected 3 by 3 matrix.");
        }
        return R;
    }
}

