/*
 * Decompiled with CFR 0.152.
 */
package georegression.fitting.ellipse;

import georegression.struct.point.Point2D_F64;
import georegression.struct.shapes.EllipseQuadratic_F64;
import java.util.List;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.data.Matrix64F;
import org.ejml.data.RowD1Matrix64F;
import org.ejml.factory.DecompositionFactory;
import org.ejml.factory.LinearSolverFactory;
import org.ejml.interfaces.decomposition.EigenDecomposition;
import org.ejml.interfaces.linsol.LinearSolver;
import org.ejml.ops.CommonOps;

public class FitEllipseAlgebraic {
    private DenseMatrix64F D1 = new DenseMatrix64F(3, 1);
    private DenseMatrix64F D2 = new DenseMatrix64F(3, 1);
    private DenseMatrix64F S1 = new DenseMatrix64F(3, 3);
    private DenseMatrix64F S2 = new DenseMatrix64F(3, 3);
    private DenseMatrix64F S3 = new DenseMatrix64F(3, 3);
    private DenseMatrix64F M = new DenseMatrix64F(3, 3);
    private DenseMatrix64F T = new DenseMatrix64F(3, 3);
    private DenseMatrix64F Ta1 = new DenseMatrix64F(3, 1);
    private DenseMatrix64F S2_tran = new DenseMatrix64F(3, 3);
    private LinearSolver<DenseMatrix64F> solver = LinearSolverFactory.linear((int)3);
    private EigenDecomposition<DenseMatrix64F> eigen = DecompositionFactory.eig((int)3, (boolean)true, (boolean)false);
    private EllipseQuadratic_F64 ellipse = new EllipseQuadratic_F64();

    public boolean process(List<Point2D_F64> points) {
        int N = points.size();
        this.D1.reshape(N, 3);
        this.D2.reshape(N, 3);
        int index = 0;
        for (int i = 0; i < N; ++i) {
            Point2D_F64 p = points.get(i);
            this.D1.data[index] = p.x * p.x;
            this.D2.data[index++] = p.x;
            this.D1.data[index] = p.x * p.y;
            this.D2.data[index++] = p.y;
            this.D1.data[index] = p.y * p.y;
            this.D2.data[index++] = 1.0;
        }
        CommonOps.multTransA((RowD1Matrix64F)this.D1, (RowD1Matrix64F)this.D1, (RowD1Matrix64F)this.S1);
        CommonOps.multTransA((RowD1Matrix64F)this.D1, (RowD1Matrix64F)this.D2, (RowD1Matrix64F)this.S2);
        CommonOps.multTransA((RowD1Matrix64F)this.D2, (RowD1Matrix64F)this.D2, (RowD1Matrix64F)this.S3);
        if (!this.solver.setA((Matrix64F)this.S3)) {
            return false;
        }
        CommonOps.transpose((DenseMatrix64F)this.S2, (DenseMatrix64F)this.S2_tran);
        CommonOps.changeSign((D1Matrix64F)this.S2_tran);
        this.solver.solve((Matrix64F)this.S2_tran, (Matrix64F)this.T);
        CommonOps.mult((RowD1Matrix64F)this.S2, (RowD1Matrix64F)this.T, (RowD1Matrix64F)this.M);
        CommonOps.add((D1Matrix64F)this.M, (D1Matrix64F)this.S1, (D1Matrix64F)this.M);
        for (int col = 0; col < 3; ++col) {
            double m0 = this.M.unsafe_get(0, col);
            double m1 = this.M.unsafe_get(1, col);
            double m2 = this.M.unsafe_get(2, col);
            this.M.unsafe_set(0, col, m2 / 2.0);
            this.M.unsafe_set(1, col, -m1);
            this.M.unsafe_set(2, col, m0 / 2.0);
        }
        if (!this.eigen.decompose((Matrix64F)this.M)) {
            return false;
        }
        DenseMatrix64F a1 = this.selectBestEigenVector();
        if (a1 == null) {
            return false;
        }
        CommonOps.mult((RowD1Matrix64F)this.T, (RowD1Matrix64F)a1, (RowD1Matrix64F)this.Ta1);
        this.ellipse.a = a1.data[0];
        this.ellipse.b = a1.data[1] / 2.0;
        this.ellipse.c = a1.data[2];
        this.ellipse.d = this.Ta1.data[0] / 2.0;
        this.ellipse.e = this.Ta1.data[1] / 2.0;
        this.ellipse.f = this.Ta1.data[2];
        return true;
    }

    private DenseMatrix64F selectBestEigenVector() {
        int bestIndex = -1;
        double bestCond = Double.MAX_VALUE;
        for (int i = 0; i < this.eigen.getNumberOfEigenvalues(); ++i) {
            DenseMatrix64F v = (DenseMatrix64F)this.eigen.getEigenVector(i);
            if (v == null) continue;
            double cond = 4.0 * v.get(0) * v.get(2) - v.get(1) * v.get(1);
            double condError = (cond - 1.0) * (cond - 1.0);
            if (!(cond > 0.0) || !(condError < bestCond)) continue;
            bestCond = condError;
            bestIndex = i;
        }
        if (bestIndex == -1) {
            return null;
        }
        return (DenseMatrix64F)this.eigen.getEigenVector(bestIndex);
    }

    public EllipseQuadratic_F64 getEllipse() {
        return this.ellipse;
    }
}

