/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.image;

import boofcv.gui.image.VisualizeImageData;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.pyramid.ImagePyramid;
import boofcv.struct.pyramid.PyramidDiscrete;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class DiscretePyramidPanel<T extends ImageSingleBand>
extends JPanel {
    BufferedImage img;
    ImagePyramid<T> pyramid;
    BufferedImage[] layers;

    public DiscretePyramidPanel() {
    }

    public DiscretePyramidPanel(PyramidDiscrete<T> pyramid) {
        this.setPyramid(pyramid);
    }

    public void setPyramid(PyramidDiscrete<T> pyramid) {
        this.pyramid = pyramid;
        this.layers = new BufferedImage[pyramid.getNumLayers()];
        for (int i = 0; i < this.layers.length; ++i) {
            int width = pyramid.getWidth(i);
            int height = pyramid.getHeight(i);
            this.layers[i] = new BufferedImage(width, height, 5);
        }
        int width = pyramid.getWidth(0);
        int height = pyramid.getHeight(0);
        if (pyramid.getNumLayers() > 1) {
            width += pyramid.getWidth(1);
        }
        this.img = new BufferedImage(width, height, 5);
        this.setPreferredSize(new Dimension(width, height));
    }

    public void render() {
        for (int i = 0; i < this.layers.length; ++i) {
            VisualizeImageData.standard((ImageSingleBand)this.pyramid.getLayer(i), this.layers[i]);
        }
        Graphics2D g2 = (Graphics2D)this.img.getGraphics();
        g2.drawImage((Image)this.layers[0], 0, 0, this);
        int height = 0;
        int width = this.layers[0].getWidth();
        for (int i = 1; i < this.layers.length; ++i) {
            g2.drawImage((Image)this.layers[i], width, height, this);
            height += this.layers[i].getHeight();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.img != null) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setColor(Color.WHITE);
            g2.fillRect(0, 0, this.getWidth(), this.getHeight());
            double scale = (double)this.img.getWidth() / (double)this.getWidth();
            if (scale > 1.0) {
                AffineTransform tran = new AffineTransform();
                tran.setToScale(1.0 / scale, 1.0 / scale);
                g2.drawImage(this.img, tran, null);
            } else {
                g.drawImage(this.img, 0, 0, this);
            }
        }
    }
}

