/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.gui.feature.CompareTwoImagePanel;
import boofcv.gui.feature.VisualizeFeatures;
import boofcv.struct.feature.AssociatedIndex;
import boofcv.struct.geo.AssociatedPair;
import georegression.struct.point.Point2D_F64;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import org.ddogleg.struct.FastQueue;

public class AssociationPanel
extends CompareTwoImagePanel
implements MouseListener {
    private int[] assocLeft;
    private int[] assocRight;
    Color[] colors;

    public AssociationPanel(int borderSize) {
        super(borderSize, true);
    }

    public synchronized void setAssociation(List<Point2D_F64> leftPts, List<Point2D_F64> rightPts, FastQueue<AssociatedIndex> matches) {
        int i;
        this.setLocation(leftPts, rightPts);
        this.assocLeft = new int[leftPts.size()];
        this.assocRight = new int[rightPts.size()];
        for (i = 0; i < this.assocLeft.length; ++i) {
            this.assocLeft[i] = -1;
        }
        for (i = 0; i < this.assocRight.length; ++i) {
            this.assocRight[i] = -1;
        }
        for (i = 0; i < matches.size; ++i) {
            AssociatedIndex a = (AssociatedIndex)matches.get(i);
            this.assocLeft[a.src] = a.dst;
            this.assocRight[a.dst] = a.src;
        }
        Random rand = new Random(234L);
        this.colors = new Color[leftPts.size()];
        for (int i2 = 0; i2 < this.colors.length; ++i2) {
            this.colors[i2] = new Color(rand.nextInt() | 0xFF000000);
        }
    }

    public synchronized void setAssociation(List<AssociatedPair> matches) {
        ArrayList<Point2D_F64> leftPts = new ArrayList<Point2D_F64>();
        ArrayList<Point2D_F64> rightPts = new ArrayList<Point2D_F64>();
        for (AssociatedPair p : matches) {
            leftPts.add(p.p1);
            rightPts.add(p.p2);
        }
        this.setLocation(leftPts, rightPts);
        this.assocLeft = new int[leftPts.size()];
        this.assocRight = new int[rightPts.size()];
        for (int i = 0; i < this.assocLeft.length; ++i) {
            this.assocLeft[i] = i;
            this.assocRight[i] = i;
        }
        Random rand = new Random(234L);
        this.colors = new Color[leftPts.size()];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = new Color(rand.nextInt() | 0xFF000000);
        }
    }

    public synchronized void setAssociation(List<Point2D_F64> leftPts, List<Point2D_F64> rightPts) {
        this.setLocation(leftPts, rightPts);
        this.assocLeft = new int[leftPts.size()];
        this.assocRight = new int[rightPts.size()];
        for (int i = 0; i < this.assocLeft.length; ++i) {
            this.assocLeft[i] = i;
            this.assocRight[i] = i;
        }
        Random rand = new Random(234L);
        this.colors = new Color[leftPts.size()];
        for (int i = 0; i < this.colors.length; ++i) {
            this.colors[i] = new Color(rand.nextInt() | 0xFF000000);
        }
    }

    @Override
    protected void drawFeatures(Graphics2D g2, double scaleLeft, int leftX, int leftY, double scaleRight, int rightX, int rightY) {
        if (this.selected.isEmpty()) {
            this.drawAllFeatures(g2, scaleLeft, scaleRight, rightX);
        } else {
            Iterator i$ = this.selected.iterator();
            while (i$.hasNext()) {
                Color color;
                Point2D_F64 r;
                Point2D_F64 l;
                int selectedIndex = (Integer)i$.next();
                if (this.selectedIsLeft) {
                    l = (Point2D_F64)this.leftPts.get(selectedIndex);
                    if (this.assocLeft[selectedIndex] < 0) {
                        r = null;
                        color = null;
                    } else {
                        r = (Point2D_F64)this.rightPts.get(this.assocLeft[selectedIndex]);
                        color = this.colors[selectedIndex];
                    }
                } else {
                    r = (Point2D_F64)this.rightPts.get(selectedIndex);
                    if (this.assocRight[selectedIndex] < 0) {
                        l = null;
                        color = null;
                    } else {
                        l = (Point2D_F64)this.leftPts.get(this.assocRight[selectedIndex]);
                        color = this.colors[this.assocRight[selectedIndex]];
                    }
                }
                if (color == null) {
                    this.drawAllFeatures(g2, scaleLeft, scaleRight, rightX);
                    continue;
                }
                this.drawAssociation(g2, scaleLeft, scaleRight, rightX, l, r, color);
            }
        }
    }

    private void drawAllFeatures(Graphics2D g2, double scaleLeft, double scaleRight, int rightX) {
        if (this.assocLeft == null || this.rightPts == null || this.leftPts == null) {
            return;
        }
        for (int i = 0; i < this.assocLeft.length; ++i) {
            if (this.assocLeft[i] == -1) continue;
            Point2D_F64 l = (Point2D_F64)this.leftPts.get(i);
            Point2D_F64 r = (Point2D_F64)this.rightPts.get(this.assocLeft[i]);
            Color color = this.colors[i];
            this.drawAssociation(g2, scaleLeft, scaleRight, rightX, l, r, color);
        }
    }

    private void drawAssociation(Graphics2D g2, double scaleLeft, double scaleRight, int rightX, Point2D_F64 l, Point2D_F64 r, Color color) {
        if (r == null) {
            int x1 = (int)(scaleLeft * l.x);
            int y1 = (int)(scaleLeft * l.y);
            VisualizeFeatures.drawPoint(g2, x1, y1, Color.RED);
        } else if (l == null) {
            int x2 = (int)(scaleRight * r.x) + rightX;
            int y2 = (int)(scaleRight * r.y);
            VisualizeFeatures.drawPoint(g2, x2, y2, Color.RED);
        } else {
            int x1 = (int)(scaleLeft * l.x);
            int y1 = (int)(scaleLeft * l.y);
            VisualizeFeatures.drawPoint(g2, x1, y1, color);
            int x2 = (int)(scaleRight * r.x) + rightX;
            int y2 = (int)(scaleRight * r.y);
            VisualizeFeatures.drawPoint(g2, x2, y2, color);
            g2.setColor(color);
            g2.drawLine(x1, y1, x2, y2);
        }
    }

    @Override
    protected boolean isValidPoint(int index) {
        if (this.selectedIsLeft) {
            return this.assocLeft[index] >= 0;
        }
        return this.assocRight[index] >= 0;
    }
}

