/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSingleBand;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import javax.swing.JPanel;

public class ImageHistogramPanel
extends JPanel {
    protected int totalBins;
    protected double maxValue;
    protected int[] bins;

    public ImageHistogramPanel(int totalBins, double maxValue) {
        this.totalBins = totalBins;
        this.maxValue = maxValue;
        this.bins = new int[totalBins];
    }

    public void update(ImageSingleBand image) {
        for (int i = 0; i < this.bins.length; ++i) {
            this.bins[i] = 0;
        }
        if (image instanceof ImageFloat32) {
            this.update((ImageFloat32)image);
        } else if (ImageInteger.class.isAssignableFrom(image.getClass())) {
            this.update((ImageInteger)image);
        } else {
            throw new IllegalArgumentException("Image type not yet supported");
        }
    }

    private void update(ImageFloat32 image) {
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int index = (int)((double)this.totalBins * ((double)image.get(x, y) / this.maxValue));
                if (index >= this.totalBins || index < 0) {
                    System.err.println("Bad index in ImageHistogramPanel");
                    continue;
                }
                int n = index;
                this.bins[n] = this.bins[n] + 1;
            }
        }
    }

    private void update(ImageInteger image) {
        int max = (int)this.maxValue;
        for (int y = 0; y < image.height; ++y) {
            for (int x = 0; x < image.width; ++x) {
                int index = this.totalBins * image.unsafe_get(x, y) / max;
                if (index >= this.totalBins || index < 0) {
                    System.err.println("Bad index in ImageHistogramPanel");
                    continue;
                }
                int n = index;
                this.bins[n] = this.bins[n] + 1;
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.fillRect(0, 0, this.getWidth(), this.getHeight());
        int maxCount = 0;
        for (int i = 0; i < this.totalBins; ++i) {
            if (this.bins[i] <= maxCount) continue;
            maxCount = this.bins[i];
        }
        if (maxCount == 0) {
            return;
        }
        g2.setColor(Color.BLACK);
        int w = this.getWidth();
        int h = this.getHeight();
        for (int i = 0; i < this.totalBins; ++i) {
            int x1 = w * i / this.totalBins;
            int x2 = w * (i + 1) / this.totalBins;
            int y = h - h * this.bins[i] / maxCount;
            g2.fillRect(x1, y, x2 - x1, h - y);
        }
    }
}

