/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.struct.distort.PointTransform_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public class AddRadialPtoP_F64
implements PointTransform_F64 {
    private double cx;
    private double cy;
    private double[] radial;
    private DenseMatrix64F K_inv = new DenseMatrix64F(3, 3);
    private Point2D_F64 temp0 = new Point2D_F64();

    public AddRadialPtoP_F64() {
    }

    public AddRadialPtoP_F64(double fx, double fy, double skew, double cx, double cy, double ... radial) {
        this.set(fx, fy, skew, cx, cy, radial);
    }

    public void set(double fx, double fy, double skew, double cx, double cy, double[] radial) {
        this.K_inv.set(0, 0, fx);
        this.K_inv.set(1, 1, fy);
        this.K_inv.set(0, 1, skew);
        this.K_inv.set(0, 2, cx);
        this.K_inv.set(1, 2, cy);
        this.K_inv.set(2, 2, 1.0);
        CommonOps.invert((DenseMatrix64F)this.K_inv);
        this.cx = cx;
        this.cy = cy;
        if (radial == null) {
            this.radial = new double[0];
        } else {
            this.radial = new double[radial.length];
            for (int i = 0; i < radial.length; ++i) {
                this.radial[i] = radial[i];
            }
        }
    }

    public void compute(double x, double y, Point2D_F64 out) {
        double r2;
        float sum = 0.0f;
        this.temp0.x = x;
        this.temp0.y = y;
        GeometryMath_F64.mult((DenseMatrix64F)this.K_inv, (GeoTuple2D_F64)this.temp0, (GeoTuple2D_F64)out);
        double r = r2 = out.x * out.x + out.y * out.y;
        for (int i = 0; i < this.radial.length; ++i) {
            sum = (float)((double)sum + this.radial[i] * r);
            r *= r2;
        }
        out.x = x + (x - this.cx) * (double)sum;
        out.y = y + (y - this.cy) * (double)sum;
    }
}

