/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.tracker;

import boofcv.abst.feature.associate.AssociateDescription;
import boofcv.abst.feature.detdesc.DetectDescribePoint;
import boofcv.alg.filter.derivative.GImageDerivativeOps;
import boofcv.alg.interpolate.InterpolateRectangle;
import boofcv.alg.tracker.combined.CombinedTrackerScalePoint;
import boofcv.alg.tracker.combined.PyramidKltForCombined;
import boofcv.alg.tracker.klt.KltConfig;
import boofcv.alg.tracker.klt.KltTracker;
import boofcv.alg.tracker.klt.PkltConfig;
import boofcv.alg.tracker.klt.PyramidKltTracker;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.feature.TupleDesc;
import boofcv.struct.image.ImageSingleBand;

public class FactoryTrackerAlg {
    public static <I extends ImageSingleBand, D extends ImageSingleBand> KltTracker<I, D> klt(KltConfig config, Class<I> imageType, Class<D> derivType) {
        if (config == null) {
            config = new KltConfig();
        }
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        InterpolateRectangle interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle interpDeriv = FactoryInterpolation.bilinearRectangle((Class)derivType);
        return new KltTracker(interpInput, interpDeriv, config);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> PyramidKltTracker<I, D> kltPyramid(KltConfig config, Class<I> imageType, Class<D> derivType) {
        if (config == null) {
            config = new KltConfig();
        }
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        InterpolateRectangle interpInput = FactoryInterpolation.bilinearRectangle(imageType);
        InterpolateRectangle interpDeriv = FactoryInterpolation.bilinearRectangle((Class)derivType);
        KltTracker klt = new KltTracker(interpInput, interpDeriv, config);
        return new PyramidKltTracker(klt);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand, Desc extends TupleDesc> CombinedTrackerScalePoint<I, D, Desc> combined(DetectDescribePoint<I, Desc> detector, AssociateDescription<Desc> associate, PkltConfig kltConfig, Class<I> imageType, Class<D> derivType) {
        if (kltConfig == null) {
            kltConfig = new PkltConfig();
        }
        if (derivType == null) {
            derivType = GImageDerivativeOps.getDerivativeType(imageType);
        }
        PyramidKltForCombined klt = new PyramidKltForCombined(kltConfig.config, kltConfig.templateRadius, kltConfig.pyramidScaling, imageType, derivType);
        return new CombinedTrackerScalePoint(klt, detector, associate);
    }
}

