/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.feature.orientation;

import boofcv.abst.feature.orientation.ConfigAverageIntegral;
import boofcv.abst.feature.orientation.ConfigSiftOrientation;
import boofcv.abst.feature.orientation.ConfigSlidingIntegral;
import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.orientation.OrientationAverage;
import boofcv.alg.feature.orientation.OrientationHistogram;
import boofcv.alg.feature.orientation.OrientationHistogramSift;
import boofcv.alg.feature.orientation.OrientationImageAverage;
import boofcv.alg.feature.orientation.OrientationSlidingWindow;
import boofcv.alg.feature.orientation.impl.ImplOrientationAverageGradientIntegral;
import boofcv.alg.feature.orientation.impl.ImplOrientationAverage_F32;
import boofcv.alg.feature.orientation.impl.ImplOrientationAverage_S16;
import boofcv.alg.feature.orientation.impl.ImplOrientationAverage_S32;
import boofcv.alg.feature.orientation.impl.ImplOrientationHistogram_F32;
import boofcv.alg.feature.orientation.impl.ImplOrientationHistogram_S16;
import boofcv.alg.feature.orientation.impl.ImplOrientationHistogram_S32;
import boofcv.alg.feature.orientation.impl.ImplOrientationImageAverageIntegral;
import boofcv.alg.feature.orientation.impl.ImplOrientationImageAverage_F32;
import boofcv.alg.feature.orientation.impl.ImplOrientationImageAverage_U8;
import boofcv.alg.feature.orientation.impl.ImplOrientationSlidingWindowIntegral;
import boofcv.alg.feature.orientation.impl.ImplOrientationSlidingWindow_F32;
import boofcv.alg.feature.orientation.impl.ImplOrientationSlidingWindow_S16;
import boofcv.alg.feature.orientation.impl.ImplOrientationSlidingWindow_S32;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt8;

public class FactoryOrientationAlgs {
    public static <T extends ImageSingleBand> OrientationHistogram<T> histogram(int numAngles, int radius, boolean weighted, Class<T> derivType) {
        OrientationHistogram ret;
        if (derivType == ImageFloat32.class) {
            ret = new ImplOrientationHistogram_F32(numAngles, weighted);
        } else if (derivType == ImageSInt16.class) {
            ret = new ImplOrientationHistogram_S16(numAngles, weighted);
        } else if (derivType == ImageSInt32.class) {
            ret = new ImplOrientationHistogram_S32(numAngles, weighted);
        } else {
            throw new IllegalArgumentException("Unknown image type.");
        }
        ret.setRadius(radius);
        return ret;
    }

    public static <T extends ImageSingleBand> OrientationImageAverage<T> nogradient(int radius, Class<T> imageType) {
        OrientationImageAverage ret;
        if (imageType == ImageFloat32.class) {
            ret = new ImplOrientationImageAverage_F32(radius);
        } else if (imageType == ImageUInt8.class) {
            ret = new ImplOrientationImageAverage_U8(radius);
        } else {
            throw new IllegalArgumentException("Unknown image type.");
        }
        ret.setRadius(radius);
        return ret;
    }

    public static <T extends ImageSingleBand> OrientationAverage<T> average(int radius, boolean weighted, Class<T> derivType) {
        OrientationAverage ret;
        if (derivType == ImageFloat32.class) {
            ret = new ImplOrientationAverage_F32(weighted);
        } else if (derivType == ImageSInt16.class) {
            ret = new ImplOrientationAverage_S16(weighted);
        } else if (derivType == ImageSInt32.class) {
            ret = new ImplOrientationAverage_S32(weighted);
        } else {
            throw new IllegalArgumentException("Unknown image type.");
        }
        ret.setRadius(radius);
        return ret;
    }

    public static <T extends ImageSingleBand> OrientationSlidingWindow<T> sliding(int numAngles, double windowSize, int radius, boolean weighted, Class<T> derivType) {
        OrientationSlidingWindow ret;
        if (derivType == ImageFloat32.class) {
            ret = new ImplOrientationSlidingWindow_F32(numAngles, windowSize, weighted);
        } else if (derivType == ImageSInt16.class) {
            ret = new ImplOrientationSlidingWindow_S16(numAngles, windowSize, weighted);
        } else if (derivType == ImageSInt32.class) {
            ret = new ImplOrientationSlidingWindow_S32(numAngles, windowSize, weighted);
        } else {
            throw new IllegalArgumentException("Unknown image type.");
        }
        ret.setRadius(radius);
        return ret;
    }

    public static <II extends ImageSingleBand> OrientationIntegral<II> average_ii(ConfigAverageIntegral config, Class<II> integralType) {
        if (config == null) {
            config = new ConfigAverageIntegral();
        }
        return new ImplOrientationAverageGradientIntegral(config.radius, config.samplePeriod, config.sampleWidth, config.weightSigma, integralType);
    }

    public static <II extends ImageSingleBand> OrientationIntegral<II> image_ii(int radius, double samplePeriod, int sampleWidth, double weightSigma, Class<II> integralImage) {
        return new ImplOrientationImageAverageIntegral(radius, samplePeriod, sampleWidth, weightSigma, integralImage);
    }

    public static <II extends ImageSingleBand> OrientationIntegral<II> sliding_ii(ConfigSlidingIntegral config, Class<II> integralType) {
        if (config == null) {
            config = new ConfigSlidingIntegral();
        }
        config.checkValidity();
        return new ImplOrientationSlidingWindowIntegral(config.samplePeriod, config.windowSize, config.radius, config.weightSigma, config.sampleWidth, integralType);
    }

    public static OrientationHistogramSift sift(ConfigSiftOrientation config) {
        if (config == null) {
            config = new ConfigSiftOrientation();
        }
        config.checkValidity();
        return new OrientationHistogramSift(config.histogramSize, config.sigmaToRadius, config.sigmaEnlarge);
    }
}

