/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.slic;

import boofcv.alg.segmentation.slic.SegmentSlic;
import boofcv.struct.ConnectRule;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;

public class SegmentSlic_MsU8
extends SegmentSlic<MultiSpectral<ImageUInt8>> {
    public SegmentSlic_MsU8(int numberOfRegions, float m, int totalIterations, ConnectRule connectRule, int numBands) {
        super(numberOfRegions, m, totalIterations, connectRule, ImageType.ms((int)numBands, ImageUInt8.class));
    }

    @Override
    public void setColor(float[] color, int x, int y) {
        int numBands = ((MultiSpectral)this.input).getNumBands();
        for (int i = 0; i < numBands; ++i) {
            color[i] = ((ImageUInt8)((MultiSpectral)this.input).getBand(i)).unsafe_get(x, y);
        }
    }

    @Override
    public void addColor(float[] color, int index, float weight) {
        int numBands = ((MultiSpectral)this.input).getNumBands();
        for (int i = 0; i < numBands; ++i) {
            int n = i;
            color[n] = color[n] + (float)(((ImageUInt8)((MultiSpectral)this.input).getBand((int)i)).data[index] & 0xFF) * weight;
        }
    }

    @Override
    public float colorDistance(float[] color, int index) {
        int numBands = ((MultiSpectral)this.input).getNumBands();
        float total = 0.0f;
        for (int i = 0; i < numBands; ++i) {
            float diff = (float)(((ImageUInt8)((MultiSpectral)this.input).getBand((int)i)).data[index] & 0xFF) - color[i];
            total += diff * diff;
        }
        return total;
    }

    @Override
    public float getIntensity(int x, int y) {
        int numBands = ((MultiSpectral)this.input).getNumBands();
        int index = ((MultiSpectral)this.input).getIndex(x, y);
        float total = 0.0f;
        for (int i = 0; i < numBands; ++i) {
            total += (float)(((ImageUInt8)((MultiSpectral)this.input).getBand((int)i)).data[index] & 0xFF);
        }
        return total / (float)numBands;
    }
}

