/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.segmentation.fh04.impl;

import boofcv.alg.segmentation.fh04.FhEdgeWeights;
import boofcv.alg.segmentation.fh04.SegmentFelzenszwalbHuttenlocher04;
import boofcv.struct.image.ImageType;
import boofcv.struct.image.ImageUInt8;
import org.ddogleg.struct.FastQueue;

public class FhEdgeWeights8_U8
implements FhEdgeWeights<ImageUInt8> {
    @Override
    public void process(ImageUInt8 input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        int y;
        int w = input.width - 1;
        int h = input.height - 1;
        for (y = 0; y < h; ++y) {
            int indexSrc = input.startIndex + y * input.stride + 1;
            int indexDst = y * input.width + 1;
            int x = 1;
            while (x < w) {
                int color0 = input.data[indexSrc] & 0xFF;
                int color1 = input.data[indexSrc + 1] & 0xFF;
                int color2 = input.data[indexSrc + input.stride] & 0xFF;
                SegmentFelzenszwalbHuttenlocher04.Edge e1 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                SegmentFelzenszwalbHuttenlocher04.Edge e2 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                e1.sortValue = Math.abs(color1 - color0);
                e1.indexA = indexDst;
                e1.indexB = indexDst + 1;
                e2.sortValue = Math.abs(color2 - color0);
                e2.indexA = indexDst;
                e2.indexB = indexDst + input.width;
                int color3 = input.data[indexSrc + 1 + input.stride] & 0xFF;
                int color4 = input.data[indexSrc - 1 + input.stride] & 0xFF;
                SegmentFelzenszwalbHuttenlocher04.Edge e3 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                SegmentFelzenszwalbHuttenlocher04.Edge e4 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
                e3.sortValue = Math.abs(color3 - color0);
                e3.indexA = indexDst;
                e3.indexB = indexDst + 1 + input.width;
                e4.sortValue = Math.abs(color4 - color0);
                e4.indexA = indexDst;
                e4.indexB = indexDst - 1 + input.width;
                ++x;
                ++indexSrc;
                ++indexDst;
            }
        }
        for (y = 0; y < h; ++y) {
            this.checkAround(0, y, input, edges);
            this.checkAround(w, y, input, edges);
        }
        for (int x = 0; x < w; ++x) {
            this.checkAround(x, h, input, edges);
        }
    }

    private void checkAround(int x, int y, ImageUInt8 input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        int indexSrc = input.startIndex + y * input.stride + x;
        int indexA = y * input.width + x;
        int color0 = input.data[indexSrc] & 0xFF;
        this.check(x + 1, y, color0, indexA, input, edges);
        this.check(x, y + 1, color0, indexA, input, edges);
        this.check(x + 1, y + 1, color0, indexA, input, edges);
        this.check(x - 1, y + 1, color0, indexA, input, edges);
    }

    private void check(int x, int y, int color0, int indexA, ImageUInt8 input, FastQueue<SegmentFelzenszwalbHuttenlocher04.Edge> edges) {
        if (!input.isInBounds(x, y)) {
            return;
        }
        int indexSrc = input.startIndex + y * input.stride + x;
        int indexB = y * input.width + x;
        int colorN = input.data[indexSrc] & 0xFF;
        SegmentFelzenszwalbHuttenlocher04.Edge e1 = (SegmentFelzenszwalbHuttenlocher04.Edge)((Object)edges.grow());
        e1.sortValue = Math.abs(color0 - colorN);
        e1.indexA = indexA;
        e1.indexB = indexB;
    }

    @Override
    public ImageType<ImageUInt8> getInputType() {
        return ImageType.single(ImageUInt8.class);
    }
}

