/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;

public class ImplKitRosCornerIntensity {
    public static void process(ImageFloat32 featureIntensity, ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 hessianXX, ImageFloat32 hessianYY, ImageFloat32 hessianXY) {
        int width = derivX.width;
        int height = derivY.height;
        for (int y = 0; y < height; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexXY = hessianXY.startIndex + y * hessianXY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                float dx = derivX.data[indexX++];
                float dy = derivY.data[indexY++];
                float dxx = hessianXX.data[indexXX++];
                float dyy = hessianYY.data[indexYY++];
                float dxy = hessianXY.data[indexXY++];
                float dx2 = dx * dx;
                float dy2 = dy * dy;
                float top = Math.abs(dxx * dy2 - 2.0f * dxy * dx * dy + dyy * dx2);
                float bottom = dx2 + dy2;
                featureIntensity.data[indexInten++] = (double)bottom == 0.0 ? 0.0f : top / bottom;
            }
        }
    }

    public static void process(ImageFloat32 featureIntensity, ImageSInt16 derivX, ImageSInt16 derivY, ImageSInt16 hessianXX, ImageSInt16 hessianYY, ImageSInt16 hessianXY) {
        int width = derivX.width;
        int height = derivY.height;
        for (int y = 0; y < height; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexXX = hessianXX.startIndex + y * hessianXX.stride;
            int indexYY = hessianYY.startIndex + y * hessianYY.stride;
            int indexXY = hessianXY.startIndex + y * hessianXY.stride;
            int indexInten = featureIntensity.startIndex + y * featureIntensity.stride;
            for (int x = 0; x < width; ++x) {
                short dx = derivX.data[indexX++];
                short dy = derivY.data[indexY++];
                short dxx = hessianXX.data[indexXX++];
                short dyy = hessianYY.data[indexYY++];
                short dxy = hessianXY.data[indexXY++];
                int dx2 = dx * dx;
                int dy2 = dy * dy;
                float top = Math.abs(dxx * dy2 - 2 * dxy * dx * dy + dyy * dx2);
                float bottom = dx2 + dy2;
                featureIntensity.data[indexInten++] = (double)bottom == 0.0 ? 0.0f : top / bottom;
            }
        }
    }
}

