/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.intensity;

import boofcv.alg.feature.detect.intensity.FeatureIntensity;
import boofcv.alg.feature.detect.intensity.impl.FastHelper;
import boofcv.misc.DiscretizedCircle;
import boofcv.struct.QueueCorner;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSingleBand;

public abstract class FastCornerIntensity<T extends ImageSingleBand>
implements FeatureIntensity<T> {
    protected static final int radius = 3;
    protected int[] offsets;
    private int stride = 0;
    private QueueCorner candidates = new QueueCorner(10);
    protected T image;
    protected FastHelper<T> helper;

    protected FastCornerIntensity(FastHelper<T> helper) {
        this.helper = helper;
    }

    public QueueCorner getCandidates() {
        return this.candidates;
    }

    @Override
    public int getRadius() {
        return 3;
    }

    @Override
    public int getIgnoreBorder() {
        return 3;
    }

    public void process(T image, ImageFloat32 intensity) {
        this.candidates.reset();
        this.image = image;
        if (this.stride != ((ImageSingleBand)image).stride) {
            this.stride = ((ImageSingleBand)image).stride;
            this.offsets = DiscretizedCircle.imageOffsets((double)3.0, (int)((ImageSingleBand)image).stride);
        }
        this.helper.setImage(image, this.offsets);
        for (int y = 3; y < ((ImageSingleBand)image).height - 3; ++y) {
            int indexIntensity = intensity.startIndex + y * intensity.stride + 3;
            int index = ((ImageSingleBand)image).startIndex + y * ((ImageSingleBand)image).stride + 3;
            int x = 3;
            while (x < ((ImageSingleBand)image).width - 3) {
                this.helper.setThresholds(index);
                if (this.checkLower(index)) {
                    intensity.data[indexIntensity] = this.helper.scoreLower(index);
                    this.candidates.add(x, y);
                } else if (this.checkUpper(index)) {
                    intensity.data[indexIntensity] = this.helper.scoreUpper(index);
                    this.candidates.add(x, y);
                } else {
                    intensity.data[indexIntensity] = 0.0f;
                }
                ++x;
                ++index;
                ++indexIntensity;
            }
        }
    }

    protected abstract boolean checkLower(int var1);

    protected abstract boolean checkUpper(int var1);
}

