/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detect.edge.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;

public class ImplGradientToEdgeFeatures {
    public static void intensityE(ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                float dx = derivX.data[indexX];
                float dy = derivY.data[indexY];
                intensity.data[indexI] = (float)Math.sqrt(dx * dx + dy * dy);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        }
    }

    public static void intensityAbs(ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                intensity.data[indexI] = Math.abs(derivX.data[indexX]) + Math.abs(derivY.data[indexY]);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        }
    }

    public static void direction(ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                float dx = derivX.data[indexX];
                float dy = derivY.data[indexY];
                angle.data[indexA] = Math.abs(dx) < 1.0E-10f ? 1.5707964f : (float)Math.atan(dy / dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        }
    }

    public static void direction2(ImageFloat32 derivX, ImageFloat32 derivY, ImageFloat32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                float dx = derivX.data[indexX];
                float dy = derivY.data[indexY];
                angle.data[indexA] = (float)Math.atan2(dy, dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        }
    }

    public static void intensityE(ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                short dx = derivX.data[indexX];
                short dy = derivY.data[indexY];
                intensity.data[indexI] = (float)Math.sqrt(dx * dx + dy * dy);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        }
    }

    public static void intensityAbs(ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                intensity.data[indexI] = Math.abs(derivX.data[indexX]) + Math.abs(derivY.data[indexY]);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        }
    }

    public static void direction(ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                short dx = derivX.data[indexX];
                short dy = derivY.data[indexY];
                angle.data[indexA] = dx == 0 ? 1.5707964f : (float)Math.atan((double)dy / (double)dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        }
    }

    public static void direction2(ImageSInt16 derivX, ImageSInt16 derivY, ImageFloat32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                short dx = derivX.data[indexX];
                short dy = derivY.data[indexY];
                angle.data[indexA] = (float)Math.atan2(dy, dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        }
    }

    public static void intensityE(ImageSInt32 derivX, ImageSInt32 derivY, ImageFloat32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                int dx = derivX.data[indexX];
                int dy = derivY.data[indexY];
                intensity.data[indexI] = (float)Math.sqrt(dx * dx + dy * dy);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        }
    }

    public static void intensityAbs(ImageSInt32 derivX, ImageSInt32 derivY, ImageFloat32 intensity) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexI = intensity.startIndex + y * intensity.stride;
            int end = indexX + w;
            while (indexX < end) {
                intensity.data[indexI] = Math.abs(derivX.data[indexX]) + Math.abs(derivY.data[indexY]);
                ++indexX;
                ++indexY;
                ++indexI;
            }
        }
    }

    public static void direction(ImageSInt32 derivX, ImageSInt32 derivY, ImageFloat32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                int dx = derivX.data[indexX];
                int dy = derivY.data[indexY];
                angle.data[indexA] = dx == 0 ? 1.5707964f : (float)Math.atan((double)dy / (double)dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        }
    }

    public static void direction2(ImageSInt32 derivX, ImageSInt32 derivY, ImageFloat32 angle) {
        int w = derivX.width;
        int h = derivY.height;
        for (int y = 0; y < h; ++y) {
            int indexX = derivX.startIndex + y * derivX.stride;
            int indexY = derivY.startIndex + y * derivY.stride;
            int indexA = angle.startIndex + y * angle.stride;
            int end = indexX + w;
            while (indexX < end) {
                int dx = derivX.data[indexX];
                int dy = derivY.data[indexY];
                angle.data[indexA] = (float)Math.atan2(dy, dx);
                ++indexX;
                ++indexY;
                ++indexA;
            }
        }
    }
}

