/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.feature.detdesc;

import boofcv.abst.feature.orientation.OrientationIntegral;
import boofcv.alg.feature.describe.DescribePointSurfMultiSpectral;
import boofcv.alg.feature.detect.interest.FastHessianFeatureDetector;
import boofcv.struct.feature.ScalePoint;
import boofcv.struct.feature.SurfFeature;
import boofcv.struct.feature.SurfFeatureQueue;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.point.Point2D_F64;
import java.util.List;
import org.ddogleg.struct.GrowQueue_F64;

public class DetectDescribeSurfMultiSpectral<II extends ImageSingleBand> {
    private FastHessianFeatureDetector<II> detector;
    private OrientationIntegral<II> orientation;
    private DescribePointSurfMultiSpectral<II> describe;
    private SurfFeatureQueue descriptions;
    private List<ScalePoint> foundPoints;
    private GrowQueue_F64 featureAngles = new GrowQueue_F64(10);

    public DetectDescribeSurfMultiSpectral(FastHessianFeatureDetector<II> detector, OrientationIntegral<II> orientation, DescribePointSurfMultiSpectral<II> describe) {
        this.detector = detector;
        this.orientation = orientation;
        this.describe = describe;
        this.descriptions = new SurfFeatureQueue(describe.getDescriptorLength());
    }

    public SurfFeature createDescription() {
        return this.describe.createDescription();
    }

    public SurfFeature getDescription(int index) {
        return (SurfFeature)this.descriptions.get(index);
    }

    public void detect(II grayII, MultiSpectral<II> colorII) {
        this.orientation.setImage(grayII);
        this.describe.setImage(grayII, colorII);
        this.descriptions.reset();
        this.featureAngles.reset();
        this.detector.detect(grayII);
        this.foundPoints = this.detector.getFoundPoints();
        for (int i = 0; i < this.foundPoints.size(); ++i) {
            ScalePoint p = this.foundPoints.get(i);
            this.orientation.setScale(p.scale);
            double angle = this.orientation.compute(p.x, p.y);
            this.describe.describe(p.x, p.y, angle, p.scale, (SurfFeature)this.descriptions.grow());
            this.featureAngles.push(angle);
        }
    }

    public DescribePointSurfMultiSpectral<II> getDescribe() {
        return this.describe;
    }

    public int getNumberOfFeatures() {
        return this.foundPoints.size();
    }

    public Point2D_F64 getLocation(int featureIndex) {
        return this.foundPoints.get(featureIndex);
    }

    public double getScale(int featureIndex) {
        return this.foundPoints.get((int)featureIndex).scale;
    }

    public double getOrientation(int featureIndex) {
        return this.featureAngles.get(featureIndex);
    }
}

