/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.kernel;

import boofcv.alg.distort.DistortImageOps;
import boofcv.alg.filter.kernel.GKernelMath;
import boofcv.alg.filter.kernel.SteerableKernel;
import boofcv.alg.filter.kernel.impl.SteerableKernel_F32;
import boofcv.alg.filter.kernel.impl.SteerableKernel_I32;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.misc.GImageMiscOps;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.factory.filter.kernel.FactoryKernelGaussian;
import boofcv.factory.filter.kernel.FactorySteerCoefficients;
import boofcv.struct.convolve.Kernel2D;
import boofcv.struct.convolve.Kernel2D_F32;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;

public class FactorySteerable {
    public static <K extends Kernel2D> SteerableKernel<K> gaussian(Class<K> kernelType, int orderX, int orderY, double sigma, int radius) {
        if (orderX < 0 || orderX > 4) {
            throw new IllegalArgumentException("derivX must be from 0 to 4 inclusive.");
        }
        if (orderY < 0 || orderY > 4) {
            throw new IllegalArgumentException("derivT must be from 0 to 4 inclusive.");
        }
        int order = orderX + orderY;
        if (order > 4) {
            throw new IllegalArgumentException("The total order of x and y can't be greater than 4");
        }
        int maxOrder = Math.max(orderX, orderY);
        if (sigma <= 0.0) {
            sigma = (float)FactoryKernelGaussian.sigmaForRadius(radius, maxOrder);
        } else if (radius <= 0) {
            radius = FactoryKernelGaussian.radiusForSigma(sigma, maxOrder);
        }
        Class kernel1DType = FactoryKernel.get1DType(kernelType);
        Object kerX = FactoryKernelGaussian.derivativeK(kernel1DType, orderX, sigma, radius);
        Object kerY = FactoryKernelGaussian.derivativeK(kernel1DType, orderY, sigma, radius);
        Kernel2D kernel = GKernelMath.convolve(kerY, kerX);
        Kernel2D[] basis = new Kernel2D[order + 1];
        Object image = GKernelMath.convertToImage(kernel);
        ImageSingleBand imageRotated = (ImageSingleBand)((ImageBase)image)._createNew(((ImageSingleBand)image).width, ((ImageSingleBand)image).height);
        basis[0] = kernel;
        double angleStep = Math.PI / (double)basis.length;
        for (int index = 1; index <= order; ++index) {
            float angle = (float)(angleStep * (double)index);
            GImageMiscOps.fill(imageRotated, 0.0);
            DistortImageOps.rotate(image, imageRotated, TypeInterpolate.BILINEAR, angle);
            basis[index] = GKernelMath.convertToKernel(imageRotated);
        }
        SteerableKernel<Kernel2D_F32> ret = kernelType == Kernel2D_F32.class ? new SteerableKernel_F32() : new SteerableKernel_I32();
        ret.setBasis(FactorySteerCoefficients.polynomial(order), basis);
        return ret;
    }
}

