/*
 * Decompiled with CFR 0.152.
 */
package boofcv.core.image.border;

import boofcv.core.image.border.BorderIndex1D_Exception;
import boofcv.core.image.border.BorderIndex1D_Extend;
import boofcv.core.image.border.BorderIndex1D_Reflect;
import boofcv.core.image.border.BorderIndex1D_Wrap;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder1D_F32;
import boofcv.core.image.border.ImageBorder1D_F64;
import boofcv.core.image.border.ImageBorder1D_I32;
import boofcv.core.image.border.ImageBorder1D_I64;
import boofcv.core.image.border.ImageBorderValue;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageFloat64;
import boofcv.struct.image.ImageInteger;
import boofcv.struct.image.ImageSInt64;
import boofcv.struct.image.ImageSingleBand;

public class FactoryImageBorder {
    public static <T extends ImageSingleBand> ImageBorder<T> general(T image, BorderType borderType) {
        ImageBorder<?> ret = FactoryImageBorder.general(image.getClass(), borderType);
        ret.setImage(image);
        return ret;
    }

    public static Class<ImageBorder> lookupBorderClassType(Class<ImageSingleBand> imageType) {
        if (imageType == ImageFloat32.class) {
            return ImageBorder1D_F32.class;
        }
        if (imageType == ImageFloat64.class) {
            return ImageBorder1D_F64.class;
        }
        if (ImageInteger.class.isAssignableFrom(imageType)) {
            return ImageBorder1D_I32.class;
        }
        if (imageType == ImageSInt64.class) {
            return ImageBorder1D_I64.class;
        }
        throw new IllegalArgumentException("Unknown image type");
    }

    public static <T extends ImageSingleBand> ImageBorder<T> general(Class<T> imageType, BorderType borderType) {
        Class borderClass;
        switch (borderType) {
            case SKIP: {
                borderClass = BorderIndex1D_Exception.class;
                break;
            }
            case NORMALIZED: {
                throw new IllegalArgumentException("Normalized can't be supported by this border interface");
            }
            case REFLECT: {
                borderClass = BorderIndex1D_Reflect.class;
                break;
            }
            case EXTENDED: {
                borderClass = BorderIndex1D_Extend.class;
                break;
            }
            case WRAP: {
                borderClass = BorderIndex1D_Wrap.class;
                break;
            }
            default: {
                throw new IllegalArgumentException("Border type not supported: " + (Object)((Object)borderType));
            }
        }
        if (imageType == ImageFloat32.class) {
            return new ImageBorder1D_F32(borderClass);
        }
        if (imageType == ImageFloat64.class) {
            return new ImageBorder1D_F64(borderClass);
        }
        if (ImageInteger.class.isAssignableFrom(imageType)) {
            return new ImageBorder1D_I32(borderClass);
        }
        if (imageType == ImageSInt64.class) {
            return new ImageBorder1D_I64(borderClass);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }

    public static <T extends ImageSingleBand> ImageBorder<T> value(T image, double value) {
        ImageBorder<?> border = FactoryImageBorder.value(image.getClass(), value);
        border.setImage(image);
        return border;
    }

    public static <T extends ImageSingleBand> ImageBorder<T> value(Class<T> imageType, double value) {
        if (imageType == ImageFloat32.class) {
            return new ImageBorderValue.Value_F32((float)value);
        }
        if (imageType == ImageFloat64.class) {
            return new ImageBorderValue.Value_F64(value);
        }
        if (ImageInteger.class.isAssignableFrom(imageType)) {
            return new ImageBorderValue.Value_I((int)value);
        }
        throw new IllegalArgumentException("Unknown image type: " + imageType.getSimpleName());
    }
}

