/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative.impl;

import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageUInt8;

public class GradientThree_Standard {
    public static void process(ImageFloat32 orig, ImageFloat32 derivX, ImageFloat32 derivY) {
        float[] data = orig.data;
        float[] imgX = derivX.data;
        float[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 2;
            for (indexSrc = orig.startIndex + stride * y + 1; indexSrc < endX; ++indexSrc) {
                imgX[indexX++] = (data[indexSrc + 1] - data[indexSrc - 1]) * 0.5f;
                imgY[indexY++] = (data[indexSrc + stride] - data[indexSrc - stride]) * 0.5f;
            }
        }
    }

    public static void process(ImageUInt8 orig, ImageSInt16 derivX, ImageSInt16 derivY) {
        byte[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 2;
            for (indexSrc = orig.startIndex + stride * y + 1; indexSrc < endX; ++indexSrc) {
                imgX[indexX++] = (short)((data[indexSrc + 1] & 0xFF) - (data[indexSrc - 1] & 0xFF));
                imgY[indexY++] = (short)((data[indexSrc + stride] & 0xFF) - (data[indexSrc - stride] & 0xFF));
            }
        }
    }

    public static void process(ImageSInt16 orig, ImageSInt16 derivX, ImageSInt16 derivY) {
        short[] data = orig.data;
        short[] imgX = derivX.data;
        short[] imgY = derivY.data;
        int width = orig.getWidth();
        int height = orig.getHeight() - 1;
        int stride = orig.stride;
        for (int y = 1; y < height; ++y) {
            int indexSrc;
            int indexX = derivX.startIndex + derivX.stride * y + 1;
            int indexY = derivY.startIndex + derivY.stride * y + 1;
            int endX = indexSrc + width - 2;
            for (indexSrc = orig.startIndex + stride * y + 1; indexSrc < endX; ++indexSrc) {
                imgX[indexX++] = (short)(data[indexSrc + 1] - data[indexSrc - 1]);
                imgY[indexY++] = (short)(data[indexSrc + stride] - data[indexSrc - stride]);
            }
        }
    }
}

