/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.derivative;

import boofcv.abst.filter.derivative.AnyImageDerivative;
import boofcv.alg.filter.derivative.GradientPrewitt;
import boofcv.alg.filter.derivative.GradientSobel;
import boofcv.alg.filter.derivative.GradientThree;
import boofcv.alg.filter.derivative.GradientTwo;
import boofcv.alg.filter.derivative.HessianFromGradient;
import boofcv.alg.filter.derivative.HessianSobel;
import boofcv.alg.filter.derivative.HessianThree;
import boofcv.alg.filter.derivative.LaplacianEdge;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.core.image.ImageGenerator;
import boofcv.core.image.border.BorderType;
import boofcv.core.image.border.FactoryImageBorder;
import boofcv.core.image.border.ImageBorder;
import boofcv.core.image.border.ImageBorder_F32;
import boofcv.core.image.border.ImageBorder_I32;
import boofcv.core.image.inst.FactoryImageGenerator;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.image.ImageSInt16;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;

public class GImageDerivativeOps {
    public static <I extends ImageSingleBand, D extends ImageSingleBand> void laplace(I input, D output) {
        if (input instanceof ImageFloat32) {
            LaplacianEdge.process((ImageFloat32)input, (ImageFloat32)output);
        } else if (input instanceof ImageUInt8) {
            LaplacianEdge.process((ImageUInt8)input, (ImageSInt16)output);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> Class<D> getDerivativeType(Class<I> imageType) {
        if (imageType == ImageFloat32.class) {
            return ImageFloat32.class;
        }
        if (imageType == ImageUInt8.class) {
            return ImageSInt16.class;
        }
        if (imageType == ImageUInt16.class) {
            return ImageSInt32.class;
        }
        throw new IllegalArgumentException("Unknown input image type: " + imageType.getSimpleName());
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> void sobel(I input, D derivX, D derivY, BorderType borderType) {
        ImageBorder<I> border;
        ImageBorder<I> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.general(input, borderType);
        if (input instanceof ImageFloat32) {
            GradientSobel.process((ImageFloat32)input, (ImageFloat32)derivX, (ImageFloat32)derivY, (ImageBorder_F32)border);
        } else if (input instanceof ImageUInt8) {
            GradientSobel.process((ImageUInt8)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_I32)border);
        } else if (input instanceof ImageSInt16) {
            GradientSobel.process((ImageSInt16)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_I32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> void prewitt(I input, D derivX, D derivY, BorderType borderType) {
        ImageBorder<I> border;
        ImageBorder<I> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.general(input, borderType);
        if (input instanceof ImageFloat32) {
            GradientPrewitt.process((ImageFloat32)input, (ImageFloat32)derivX, (ImageFloat32)derivY, (ImageBorder_F32)border);
        } else if (input instanceof ImageUInt8) {
            GradientPrewitt.process((ImageUInt8)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_I32)border);
        } else if (input instanceof ImageSInt16) {
            GradientPrewitt.process((ImageSInt16)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_I32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> void three(I input, D derivX, D derivY, BorderType borderType) {
        ImageBorder<I> border;
        ImageBorder<I> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.general(input, borderType);
        if (input instanceof ImageFloat32) {
            GradientThree.process((ImageFloat32)input, (ImageFloat32)derivX, (ImageFloat32)derivY, (ImageBorder_F32)border);
        } else if (input instanceof ImageUInt8) {
            GradientThree.process((ImageUInt8)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_I32)border);
        } else if (input instanceof ImageSInt16) {
            GradientThree.process((ImageSInt16)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_I32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> void two(I input, D derivX, D derivY, BorderType borderType) {
        ImageBorder<I> border;
        ImageBorder<I> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.general(input, borderType);
        if (input instanceof ImageFloat32) {
            GradientTwo.process((ImageFloat32)input, (ImageFloat32)derivX, (ImageFloat32)derivY, (ImageBorder_F32)border);
        } else if (input instanceof ImageUInt8) {
            GradientTwo.process((ImageUInt8)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_I32)border);
        } else if (input instanceof ImageSInt16) {
            GradientTwo.process((ImageSInt16)input, (ImageSInt16)derivX, (ImageSInt16)derivY, (ImageBorder_I32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> void hessianSobel(I input, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<I> border;
        ImageBorder<I> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.general(input, borderType);
        if (input instanceof ImageFloat32) {
            HessianSobel.process((ImageFloat32)input, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
        } else if (input instanceof ImageUInt8) {
            HessianSobel.process((ImageUInt8)input, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_I32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> void hessianThree(I input, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<I> border;
        ImageBorder<I> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.general(input, borderType);
        if (input instanceof ImageFloat32) {
            HessianThree.process((ImageFloat32)input, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
        } else if (input instanceof ImageUInt8) {
            HessianThree.process((ImageUInt8)input, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_I32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + input.getClass().getSimpleName());
        }
    }

    public static <D extends ImageSingleBand> void hessianSobel(D inputDerivX, D inputDerivY, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<D> border;
        ImageBorder<D> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.general(inputDerivX, borderType);
        if (inputDerivX instanceof ImageFloat32) {
            HessianFromGradient.hessianSobel((ImageFloat32)inputDerivX, (ImageFloat32)inputDerivY, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
        } else if (inputDerivX instanceof ImageSInt16) {
            HessianFromGradient.hessianSobel((ImageSInt16)inputDerivX, (ImageSInt16)inputDerivY, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_I32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + inputDerivX.getClass().getSimpleName());
        }
    }

    public static <D extends ImageSingleBand> void hessianPrewitt(D inputDerivX, D inputDerivY, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<D> border;
        ImageBorder<D> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.general(inputDerivX, borderType);
        if (inputDerivX instanceof ImageFloat32) {
            HessianFromGradient.hessianPrewitt((ImageFloat32)inputDerivX, (ImageFloat32)inputDerivY, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
        } else if (inputDerivX instanceof ImageSInt16) {
            HessianFromGradient.hessianPrewitt((ImageSInt16)inputDerivX, (ImageSInt16)inputDerivY, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_I32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + inputDerivX.getClass().getSimpleName());
        }
    }

    public static <D extends ImageSingleBand> void hessianThree(D inputDerivX, D inputDerivY, D derivXX, D derivYY, D derivXY, BorderType borderType) {
        ImageBorder<D> border;
        ImageBorder<D> imageBorder = border = BorderType.SKIP == borderType ? null : FactoryImageBorder.general(inputDerivX, borderType);
        if (inputDerivX instanceof ImageFloat32) {
            HessianFromGradient.hessianThree((ImageFloat32)inputDerivX, (ImageFloat32)inputDerivY, (ImageFloat32)derivXX, (ImageFloat32)derivYY, (ImageFloat32)derivXY, (ImageBorder_F32)border);
        } else if (inputDerivX instanceof ImageSInt16) {
            HessianFromGradient.hessianThree((ImageSInt16)inputDerivX, (ImageSInt16)inputDerivY, (ImageSInt16)derivXX, (ImageSInt16)derivYY, (ImageSInt16)derivXY, (ImageBorder_I32)border);
        } else {
            throw new IllegalArgumentException("Unknown input image type: " + inputDerivX.getClass().getSimpleName());
        }
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> AnyImageDerivative<I, D> createDerivatives(Class<I> inputType, ImageGenerator<D> derivGen) {
        boolean isInteger = !GeneralizedImageOps.isFloatingPoint(inputType);
        return new AnyImageDerivative<I, D>(GradientThree.getKernelX(isInteger), inputType, derivGen);
    }

    public static <I extends ImageSingleBand, D extends ImageSingleBand> AnyImageDerivative<I, D> createDerivatives(Class<I> inputType, Class<D> derivType) {
        boolean isInteger = !GeneralizedImageOps.isFloatingPoint(inputType);
        ImageGenerator<Class<D>> gen = FactoryImageGenerator.create(derivType);
        return new AnyImageDerivative<I, Class<D>>(GradientThree.getKernelX(isInteger), inputType, gen);
    }
}

