/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;

public class GrowQueue_I8 {
    public byte[] data;
    public int size;

    public GrowQueue_I8(int maxSize) {
        this.data = new byte[maxSize];
        this.size = 0;
    }

    public GrowQueue_I8() {
        this(10);
    }

    public void reset() {
        this.size = 0;
    }

    public void addAll(GrowQueue_I8 queue) {
        if (this.size + queue.size > this.data.length) {
            byte[] temp = new byte[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void add(int value) {
        this.push(value);
    }

    public void push(int val) {
        if (this.size == this.data.length) {
            byte[] temp = new byte[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = (byte)val;
    }

    public int get(int index) {
        return this.data[index];
    }

    public void fill(byte value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new byte[size];
        }
        this.size = size;
    }

    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new byte[size];
        }
    }

    public int size() {
        return this.size;
    }

    public int pop() {
        return this.data[--this.size];
    }
}

