/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.struct;

import java.util.Arrays;

public class GrowQueue_I64 {
    public long[] data;
    public int size;

    public GrowQueue_I64(int maxSize) {
        this.data = new long[maxSize];
        this.size = 0;
    }

    public GrowQueue_I64() {
        this(10);
    }

    public void reset() {
        this.size = 0;
    }

    public void addAll(GrowQueue_I64 queue) {
        if (this.size + queue.size > this.data.length) {
            long[] temp = new long[(this.size + queue.size) * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        System.arraycopy(queue.data, 0, this.data, this.size, queue.size);
        this.size += queue.size;
    }

    public void add(int value) {
        this.push(value);
    }

    public void push(int val) {
        if (this.size == this.data.length) {
            long[] temp = new long[this.size * 2];
            System.arraycopy(this.data, 0, temp, 0, this.size);
            this.data = temp;
        }
        this.data[this.size++] = val;
    }

    public long get(int index) {
        return this.data[index];
    }

    public void remove(int index) {
        for (int i = index + 1; i < this.size; ++i) {
            this.data[i - 1] = this.data[i];
        }
        --this.size;
    }

    public void resize(int size) {
        if (this.data.length < size) {
            this.data = new long[size];
        }
        this.size = size;
    }

    public void fill(long value) {
        Arrays.fill(this.data, 0, this.size, value);
    }

    public void setMaxSize(int size) {
        if (this.data.length < size) {
            this.data = new long[size];
        }
    }

    public int size() {
        return this.size;
    }

    public long pop() {
        return this.data[--this.size];
    }
}

