/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.UtilEjml;
import org.ejml.data.DenseMatrix64F;

public class NumericalJacobianForward
implements FunctionNtoMxN {
    private final int N;
    private final int M;
    private FunctionNtoM function;
    private double differenceScale;
    private double[] output0;
    private double[] output1;

    public NumericalJacobianForward(FunctionNtoM function, double differenceScale) {
        this.function = function;
        this.differenceScale = differenceScale;
        this.N = function.getNumOfInputsN();
        this.M = function.getNumOfOutputsM();
        this.output0 = new double[this.M];
        this.output1 = new double[this.M];
    }

    public NumericalJacobianForward(FunctionNtoM function) {
        this(function, Math.sqrt(UtilEjml.EPS));
    }

    @Override
    public int getNumOfInputsN() {
        return this.N;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.M;
    }

    @Override
    public void process(double[] input, double[] jacobian) {
        DenseMatrix64F J = DenseMatrix64F.wrap((int)this.M, (int)this.N, (double[])jacobian);
        this.function.process(input, this.output0);
        for (int i = 0; i < this.N; ++i) {
            double x = input[i];
            double h = x != 0.0 ? this.differenceScale * Math.abs(x) : this.differenceScale;
            double temp = x + h;
            h = temp - x;
            input[i] = temp;
            this.function.process(input, this.output1);
            for (int j = 0; j < this.M; ++j) {
                J.unsafe_set(j, i, (this.output1[j] - this.output0[j]) / h);
            }
            input[i] = x;
        }
    }
}

