/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ejml.UtilEjml;

public class NumericalGradientFB
implements FunctionNtoN {
    private final int N;
    private FunctionNtoS function;
    private double differenceScale;

    public NumericalGradientFB(FunctionNtoS function, double differenceScale) {
        this.function = function;
        this.differenceScale = differenceScale;
        this.N = function.getNumOfInputsN();
    }

    public NumericalGradientFB(FunctionNtoS function) {
        this(function, Math.sqrt(UtilEjml.EPS));
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public void process(double[] input, double[] output) {
        for (int i = 0; i < this.N; ++i) {
            double temp;
            double x = input[i];
            double h = x != 0.0 ? this.differenceScale * Math.abs(x) : this.differenceScale;
            input[i] = temp = x - h;
            double h0 = x - temp;
            double backwards = this.function.process(input);
            input[i] = temp = x + h;
            double h1 = temp - x;
            double forward = this.function.process(input);
            output[i] = (forward - backwards) / (h0 + h1);
            input[i] = x;
        }
    }
}

