/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.functions.FunctionStoS;
import org.ejml.UtilEjml;

public class NumericalDerivativeFB
implements FunctionStoS {
    private FunctionStoS function;
    private double differenceScale;

    public NumericalDerivativeFB(FunctionStoS function, double differenceScale) {
        this.function = function;
        this.differenceScale = differenceScale;
    }

    public NumericalDerivativeFB(FunctionStoS function) {
        this(function, Math.sqrt(UtilEjml.EPS));
    }

    @Override
    public double process(double x) {
        double valueOrig = this.function.process(x);
        double h = x != 0.0 ? this.differenceScale * Math.abs(x) : this.differenceScale;
        double temp = x - h;
        double h0 = x - temp;
        double backwards = this.function.process(temp);
        temp = x + h;
        double h1 = temp - x;
        double forwards = this.function.process(temp);
        return (forwards - backwards) / (h0 + h1);
    }
}

