/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.wrap;

import java.util.List;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.nn.alg.AxisSplitter;
import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeConstructor;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.ddogleg.nn.alg.KdTreeResult;
import org.ddogleg.nn.alg.KdTreeSearch1Bbf;
import org.ddogleg.nn.alg.KdTreeSearchNBbf;
import org.ddogleg.struct.FastQueue;

public class KdForestBbfSearch<D>
implements NearestNeighbor<D> {
    KdTree[] forest;
    KdTreeConstructor<D> constructor;
    KdTreeSearch1Bbf search1;
    KdTreeSearchNBbf searchN;
    AxisSplitter<D> splitter;
    KdTreeMemory memory = new KdTreeMemory();
    FastQueue<KdTreeResult> found = new FastQueue<KdTreeResult>(KdTreeResult.class, true);

    public KdForestBbfSearch(int numberOfTrees, int maxNodesSearched, AxisSplitter<D> splitter) {
        this.forest = new KdTree[numberOfTrees];
        this.splitter = splitter;
        this.search1 = new KdTreeSearch1Bbf(maxNodesSearched);
        this.searchN = new KdTreeSearchNBbf(maxNodesSearched);
    }

    @Override
    public void init(int pointDimension) {
        this.constructor = new KdTreeConstructor<D>(this.memory, pointDimension, this.splitter);
    }

    @Override
    public void setPoints(List<double[]> points, List<D> data) {
        int i;
        if (this.forest[0] != null) {
            for (i = 0; i < this.forest.length; ++i) {
                this.memory.recycleGraph(this.forest[i]);
            }
        }
        for (i = 0; i < this.forest.length; ++i) {
            this.forest[i] = this.constructor.construct(points, data);
        }
        this.search1.setTrees(this.forest);
        this.searchN.setTrees(this.forest);
    }

    @Override
    public boolean findNearest(double[] point, double maxDistance, NnData<D> result) {
        if (maxDistance < 0.0) {
            this.search1.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.search1.setMaxDistance(maxDistance);
        }
        KdTree.Node found = this.search1.findNeighbor(point);
        if (found == null) {
            return false;
        }
        result.point = found.point;
        result.data = found.data;
        result.distance = this.search1.getDistance();
        return true;
    }

    @Override
    public void findNearest(double[] point, double maxDistance, int numNeighbors, FastQueue<NnData<D>> result) {
        if (maxDistance <= 0.0) {
            this.searchN.setMaxDistance(Double.MAX_VALUE);
        } else {
            this.searchN.setMaxDistance(maxDistance);
        }
        this.found.reset();
        this.searchN.findNeighbor(point, numNeighbors, this.found);
        for (int i = 0; i < this.found.size; ++i) {
            KdTreeResult k = this.found.get(i);
            NnData<D> r = result.grow();
            r.point = k.node.point;
            r.data = k.node.data;
            r.distance = k.distance;
        }
    }
}

