/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.nn.alg.KdTree;

public class KdTreeMemory {
    protected List<KdTree.Node> unusedNodes = new ArrayList<KdTree.Node>();
    protected List<KdTree> unusedTrees = new ArrayList<KdTree>();
    protected List<KdTree.Node> open = new ArrayList<KdTree.Node>();

    public KdTree.Node requestNode() {
        if (this.unusedNodes.isEmpty()) {
            return new KdTree.Node();
        }
        return this.unusedNodes.remove(this.unusedNodes.size() - 1);
    }

    public KdTree.Node requestNode(double[] point, Object data) {
        KdTree.Node n = this.requestNode();
        n.point = point;
        n.data = data;
        n.split = -1;
        return n;
    }

    public KdTree requestTree() {
        if (this.unusedTrees.isEmpty()) {
            return new KdTree();
        }
        return this.unusedTrees.remove(this.unusedTrees.size() - 1);
    }

    public void recycle(KdTree.Node node) {
        node.point = null;
        node.left = null;
        node.right = null;
        this.unusedNodes.add(node);
    }

    public void recycleGraph(KdTree tree) {
        if (tree.root != null) {
            this.open.add(tree.root);
            while (!this.open.isEmpty()) {
                KdTree.Node n = this.open.remove(this.open.size() - 1);
                if (n.left != null) {
                    this.open.add(n.left);
                }
                if (n.right != null) {
                    this.open.add(n.right);
                }
                this.recycle(n);
            }
            tree.root = null;
        }
        this.unusedTrees.add(tree);
    }
}

