/*
 * Decompiled with CFR 0.152.
 */
package my.test;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.RawImage;
import com.android.ddmlib.TimeoutException;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;

public class DeviceSwitcher {
    private static String adbPath = "E:\\itestin\\devicesmanager\\client\\yc-devices-controller\\tools\\win_adb.exe";
    private static DeviceSwitcher mDeviceSwitcher;
    private Map<String, IDevice> mDevicesMap = new HashMap<String, IDevice>();

    public static DeviceSwitcher getDeviceSwitcher() {
        if (mDeviceSwitcher == null) {
            mDeviceSwitcher = new DeviceSwitcher();
        }
        return mDeviceSwitcher;
    }

    public void finish() {
        AndroidDebugBridge.terminate();
    }

    private DeviceSwitcher() {
        this.init();
    }

    private void init() {
        AndroidDebugBridge.init(true);
        try {
            this.usingDeviceChangeListener();
            this.usingWaitLoop();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void usingWaitLoop() throws Exception {
        AndroidDebugBridge adb = AndroidDebugBridge.createBridge(adbPath, false);
        try {
            int trials = 10;
            while (trials > 0) {
                Thread.sleep(50L);
                if (adb.isConnected()) break;
                --trials;
            }
            if (!adb.isConnected()) {
                System.out.println("Couldn't connect to ADB server");
                return;
            }
            trials = 10;
            while (trials > 0) {
                Thread.sleep(50L);
                if (adb.hasInitialDeviceList()) break;
                --trials;
            }
            if (!adb.hasInitialDeviceList()) {
                System.out.println("Couldn't list connected devices");
                return;
            }
            IDevice[] iDeviceArray = adb.getDevices();
            int n = iDeviceArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDevice device = iDeviceArray[n2];
                System.out.println("* " + device.getSerialNumber());
                ++n2;
            }
        }
        finally {
            AndroidDebugBridge.disconnectBridge();
        }
    }

    private void usingDeviceChangeListener() throws Exception {
        AndroidDebugBridge.addDeviceChangeListener(new AndroidDebugBridge.IDeviceChangeListener(){

            @Override
            public void deviceConnected(IDevice device) {
                System.out.println("+ " + device.getSerialNumber());
                DeviceSwitcher.this.mDevicesMap.put(device.getSerialNumber(), device);
            }

            @Override
            public void deviceDisconnected(IDevice device) {
                System.out.println("- " + device.getSerialNumber());
                DeviceSwitcher.this.mDevicesMap.remove(device.getSerialNumber());
            }

            @Override
            public void deviceChanged(IDevice device, int changeMask) {
                System.out.println("& " + device.getSerialNumber());
            }
        });
    }

    private byte[] decoder(RawImage rawImage) throws IOException {
        byte[] buff = null;
        BufferedImage image = null;
        int width2 = rawImage.width;
        int height2 = rawImage.height;
        image = rawImage.bpp == 24 ? new BufferedImage(width2, height2, 1) : (rawImage.bpp == 32 ? new BufferedImage(width2, height2, 1) : new BufferedImage(width2, height2, 8));
        int index = 0;
        int indexInc = rawImage.bpp >> 3;
        int y = 0;
        while (y < rawImage.height) {
            int x = 0;
            while (x < rawImage.width) {
                int value = rawImage.getARGB(index);
                image.setRGB(x, y, value);
                ++x;
                index += indexInc;
            }
            ++y;
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)image, "JPEG", bo);
        buff = bo.toByteArray();
        return buff;
    }

    public static void main(String[] args) {
        DeviceSwitcher switcher = DeviceSwitcher.getDeviceSwitcher();
        while (switcher.mDevicesMap.isEmpty()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String sn = switcher.mDevicesMap.keySet().iterator().next();
        IDevice device = switcher.mDevicesMap.get(sn);
        int i = 0;
        while (i < 100) {
            try {
                RawImage img = null;
                long st = System.currentTimeMillis();
                img = device.getScreenshot();
                long delay = System.currentTimeMillis() - st;
                System.out.println("\ufffd\ufffd\u037c\ufffd\ufffd\u02b1\ufffd\ufffd" + delay);
                byte[] buff = switcher.decoder(img);
                delay = System.currentTimeMillis() - st;
                System.out.println("\u022b\ufffd\ufffd\ufffd\ufffd\u02b1\ufffd\ufffd" + delay);
            }
            catch (TimeoutException e) {
                e.printStackTrace();
            }
            catch (AdbCommandRejectedException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }
}

