/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.ChunkHandler;
import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.JdwpPacket;
import com.android.ddmlib.Log;
import com.android.ddmlib.MonitorThread;
import com.android.ddmlib.NativeAllocationInfo;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

final class HandleNativeHeap
extends ChunkHandler {
    public static final int CHUNK_NHGT = HandleNativeHeap.type("NHGT");
    public static final int CHUNK_NHSG = HandleNativeHeap.type("NHSG");
    public static final int CHUNK_NHST = HandleNativeHeap.type("NHST");
    public static final int CHUNK_NHEN = HandleNativeHeap.type("NHEN");
    private static final HandleNativeHeap mInst = new HandleNativeHeap();

    private HandleNativeHeap() {
    }

    public static void register(MonitorThread mt) {
        mt.registerChunkHandler(CHUNK_NHGT, mInst);
        mt.registerChunkHandler(CHUNK_NHSG, mInst);
        mt.registerChunkHandler(CHUNK_NHST, mInst);
        mt.registerChunkHandler(CHUNK_NHEN, mInst);
    }

    @Override
    public void clientReady(Client client) throws IOException {
    }

    @Override
    public void clientDisconnected(Client client) {
    }

    @Override
    public void handleChunk(Client client, int type, ByteBuffer data, boolean isReply, int msgId) {
        Log.d("ddm-nativeheap", "handling " + ChunkHandler.name(type));
        if (type == CHUNK_NHGT) {
            this.handleNHGT(client, data);
        } else if (type == CHUNK_NHST) {
            client.getClientData().getNativeHeapData().clearHeapData();
        } else if (type == CHUNK_NHEN) {
            client.getClientData().getNativeHeapData().sealHeapData();
        } else if (type == CHUNK_NHSG) {
            this.handleNHSG(client, data);
        } else {
            this.handleUnknownChunk(client, type, data, isReply, msgId);
        }
        client.update(128);
    }

    public static void sendNHGT(Client client) throws IOException {
        ByteBuffer rawBuf = HandleNativeHeap.allocBuffer(0);
        JdwpPacket packet = new JdwpPacket(rawBuf);
        ByteBuffer buf = HandleNativeHeap.getChunkDataBuf(rawBuf);
        HandleNativeHeap.finishChunkPacket(packet, CHUNK_NHGT, buf.position());
        Log.d("ddm-nativeheap", "Sending " + HandleNativeHeap.name(CHUNK_NHGT));
        client.sendAndConsume(packet, mInst);
        rawBuf = HandleNativeHeap.allocBuffer(2);
        packet = new JdwpPacket(rawBuf);
        buf = HandleNativeHeap.getChunkDataBuf(rawBuf);
        buf.put((byte)0);
        buf.put((byte)1);
        HandleNativeHeap.finishChunkPacket(packet, CHUNK_NHSG, buf.position());
        Log.d("ddm-nativeheap", "Sending " + HandleNativeHeap.name(CHUNK_NHSG));
        client.sendAndConsume(packet, mInst);
    }

    private void handleNHGT(Client client, ByteBuffer data) {
        ClientData cd = client.getClientData();
        Log.d("ddm-nativeheap", "NHGT: " + data.limit() + " bytes");
        byte[] copy = new byte[data.limit()];
        data.get(copy);
        cd.clearNativeAllocationInfo();
        ByteBuffer buffer = ByteBuffer.wrap(copy);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int mapSize = buffer.getInt();
        int allocSize = buffer.getInt();
        int allocInfoSize = buffer.getInt();
        int totalMemory = buffer.getInt();
        int backtraceSize = buffer.getInt();
        Log.d("ddms", "mapSize: " + mapSize);
        Log.d("ddms", "allocSize: " + allocSize);
        Log.d("ddms", "allocInfoSize: " + allocInfoSize);
        Log.d("ddms", "totalMemory: " + totalMemory);
        cd.setTotalNativeMemory(totalMemory);
        if (allocInfoSize == 0) {
            return;
        }
        if (mapSize > 0) {
            byte[] maps = new byte[mapSize];
            buffer.get(maps, 0, mapSize);
            this.parseMaps(cd, maps);
        }
        int iterations = allocSize / allocInfoSize;
        int i = 0;
        while (i < iterations) {
            NativeAllocationInfo info = new NativeAllocationInfo(buffer.getInt(), buffer.getInt());
            int j = 0;
            while (j < backtraceSize) {
                long addr = (long)buffer.getInt() & 0xFFFFFFFFL;
                if (addr != 0L) {
                    info.addStackCallAddress(addr);
                }
                ++j;
            }
            cd.addNativeAllocation(info);
            ++i;
        }
    }

    private void handleNHSG(Client client, ByteBuffer data) {
        byte[] dataCopy = new byte[data.limit()];
        data.rewind();
        data.get(dataCopy);
        data = ByteBuffer.wrap(dataCopy);
        client.getClientData().getNativeHeapData().addHeapData(data);
    }

    private void parseMaps(ClientData cd, byte[] maps) {
        InputStreamReader input = new InputStreamReader(new ByteArrayInputStream(maps));
        BufferedReader reader = new BufferedReader(input);
        try {
            String line;
            long startAddr = 0L;
            long endAddr = 0L;
            String library = null;
            while ((line = reader.readLine()) != null) {
                Log.d("ddms", "line: " + line);
                if (line.length() < 16) continue;
                try {
                    long tmpStart = Long.parseLong(line.substring(0, 8), 16);
                    long tmpEnd = Long.parseLong(line.substring(9, 17), 16);
                    int index = line.indexOf(47);
                    if (index == -1) continue;
                    String tmpLib = line.substring(index);
                    if (library == null || library != null && !tmpLib.equals(library)) {
                        if (library != null) {
                            cd.addNativeLibraryMapInfo(startAddr, endAddr, library);
                            Log.d("ddms", String.valueOf(library) + "(" + Long.toHexString(startAddr) + " - " + Long.toHexString(endAddr) + ")");
                        }
                        library = tmpLib;
                        startAddr = tmpStart;
                        endAddr = tmpEnd;
                        continue;
                    }
                    endAddr = tmpEnd;
                }
                catch (NumberFormatException e) {
                    e.printStackTrace();
                }
            }
            if (library != null) {
                cd.addNativeLibraryMapInfo(startAddr, endAddr, library);
                Log.d("ddms", String.valueOf(library) + "(" + Long.toHexString(startAddr) + " - " + Long.toHexString(endAddr) + ")");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

