function processExternalLinks()
{
	if (!document.getElementsByTagName)
		return;

	var anchors = document.getElementsByTagName("a"); 
	for (var i=0; i<anchors.length; i++)
	{
		var anchor = anchors[i];
		
		if (anchor.getAttribute("title") == null || anchor.getAttribute("title") == "")
		{
			anchor.title = anchor.innerText;
		}

		if (anchor.getAttribute("href") && anchor.getAttribute("rel") == "external")
			anchor.target = "_blank";
		else
			anchor.target = "_top";
	} 
}
window.onload = processExternalLinks;

/**
 * Sets a Cookie with the given name and value.
 *
 * name       Name of the cookie
 * value      Value of the cookie
 * [expires]  Expiration date of the cookie (default: end of current session)
 * [path]     Path where the cookie is valid (default: path of calling document)
 * [domain]   Domain where the cookie is valid
 *              (default: domain of calling document)
 * [secure]   Boolean value indicating if the cookie transmission requires a
 *              secure transmission
 */
function setCookie(name, value, expires, path, domain, secure)
{
    document.cookie = name + "=" + escape(value) +
        ((expires) ? "; expires=" + expires.toGMTString() : "") +
        ((path) ? "; path=" + path : "") +
        ((domain) ? "; domain=" + domain : "") +
        ((secure) ? "; secure" : "");
}

/**
 * Gets the value of the specified cookie.
 *
 * name  Name of the desired cookie.
 *
 * Returns a string containing value of specified cookie,
 *   or null if cookie does not exist.
 */
function getCookie(name)
{
    var dc = document.cookie;
    var prefix = name + "=";
    var begin = dc.indexOf("; " + prefix);
    if (begin == -1)
    {
        begin = dc.indexOf(prefix);
        if (begin != 0) return null;
    }
    else
    {
        begin += 2;
    }
    var end = document.cookie.indexOf(";", begin);
    if (end == -1)
    {
        end = dc.length;
    }
    return unescape(dc.substring(begin + prefix.length, end));
}

/**
 * Deletes the specified cookie.
 *
 * name      name of the cookie
 * [path]    path of the cookie (must be same as path used to create cookie)
 * [domain]  domain of the cookie (must be same as domain used to create cookie)
 */
function deleteCookie(name, path, domain)
{
    if (getCookie(name))
    {
        document.cookie = name + "=" + 
            ((path) ? "; path=" + path : "") +
            ((domain) ? "; domain=" + domain : "") +
            "; expires=Thu, 01-Jan-70 00:00:01 GMT";
    }
}

function showContainer(containerId) {
	var cf = document.getElementById(containerId);

	cf.style.display = "block";
}

function hideContainer(containerId) {
	var cf = document.getElementById(containerId);
	
	cf.style.display = "none";
}

function showSubMenu(containerId) {
	var anchors = containerId.getElementsByTagName("ul");
	
	try
	{
		anchors[0].style.display = "block";
	}
	catch(e) { }
}

function hideSubMenu(containerId) {
	var anchors = containerId.getElementsByTagName("ul");

	try
	{
		anchors[0].style.display = "none";
	}
	catch(e) { }
}

function FlashTag(src, width, height)
{
    this.src       = src;
    this.width     = width;
    this.height    = height;
    this.version   = '7,0,14,0';
    this.flashVars = null;
	 this.menu				='false';
    //this.id        = null;
    this.bgcolor   = "";
    this.id        = "f_" + ((new Date()).getTime()).toString();
    this.salign = null;
    this.scale = null;
    this.wmode = 'transparent';
    this.wmodeFF = null;//(FF=firefox)
}

FlashTag.prototype.setSalign = function(sa)
{
    this.salign = sa;
}

FlashTag.prototype.setMenu = function(menuShow)
{
    this.menu = menuShow;
}

FlashTag.prototype.setScale = function(scl)
{
    this.scale = scl;
}

FlashTag.prototype.setWmode = function(wm)
{
    this.wmode = wm;
}

FlashTag.prototype.setWmodeFF = function(wmff)
{
    this.wmodeFF = wmff
}

FlashTag.prototype.setVersion = function(v)
{
    this.version = v;
}

FlashTag.prototype.setId = function(id)
{
    this.id = id;
}

FlashTag.prototype.setBgcolor = function(bgc)
{
    this.bgcolor = bgc;
}

FlashTag.prototype.setFlashvars = function(fv)
{
    this.flashVars = fv;
}

FlashTag.prototype.setSrc = function(src)
{
    this.src       = src;
}
FlashTag.prototype.setNew = function(src, width, height)
{
    this.src       = src;
    this.id        = "f_" + ((new Date()).getTime()).toString();
    this.width     = width;
    this.height    = height;
    this.flashVars = null;
    this.bgcolor   = '';
    this.salign = null;
    this.scale = null;
    this.wmode = 'transparent';//opaque
    this.wmodeFF = null;//(FF=firefox)
	return this.id;
}

FlashTag.prototype.toString = function()
{
    var ie = (navigator.appName.indexOf ("Microsoft") != -1) ? 1 : 0;
    var flashTag = new String();
    if (ie)
    {
        flashTag += '<object classid="clsid:D27CDB6E-AE6D-11cf-96B8-444553540000" ';
        if (this.id != null)
        {
            flashTag += 'id="'+this.id+'" ';
        }
        flashTag += 'codebase="http://download.macromedia.com/pub/shockwave/cabs/flash/swflash.cab#version='+this.version+'" ';
        flashTag += 'width="'+this.width+'" ';
        flashTag += 'height="'+this.height+'">';
        flashTag += '<param name="movie" value="'+this.src+'"/>';
        flashTag += '<param name="quality" value="high"/>';
        flashTag += '<param name="bgcolor" value="#'+this.bgcolor+'"/>';
				flashTag += '<param name="menu" value="'+this.menu+'"/>';
        if (this.wmode != null)
        {
            flashTag += '<param name="wmode" value="'+this.wmode+'"/>';
        }
        if (this.salign != null)
        {
            flashTag += '<param name="salign" value="'+this.salign+'"/>';
        }
        if (this.scale != null)
        {
            flashTag += '<param name="scale" value="'+this.scale+'"/>';
        }
        if (this.flashVars != null)
        {
            flashTag += '<param name="flashvars" value="'+this.flashVars+'"/>';
        }
        flashTag += '</object>';
    }
    else
    {
        flashTag += '<embed src="'+this.src+'" ';
        flashTag += 'quality="high" '; 
        flashTag += 'bgcolor="#'+this.bgcolor+'" ';
        flashTag += 'width="'+this.width+'" ';
        flashTag += 'height="'+this.height+'" ';
        flashTag += 'type="application/x-shockwave-flash" ';
		flashTag += 'menu="'+this.menu+'" ';
        if (this.flashVars != null)
        {
            flashTag += 'flashvars="'+this.flashVars+'" ';
        }
        if (this.id != null)
        {
            flashTag += 'name="'+this.id+'" ';
        }
				if ((this.wmode!=null)&&(this.wmode == "transparent")) {this.wmodeFF = "transparent"; }
        if (this.wmodeFF != null)
        {
            flashTag += 'wmode="'+this.wmodeFF+'" ';
        }
        if (this.scale != null)
        {
            flashTag += 'scale="'+this.scale+'" ';
        }
        if (this.salign != null)
        {
            flashTag += 'salign="'+this.salign+'" ';
        }        flashTag += 'pluginspage="http://www.macromedia.com/go/getflashplayer">';
        flashTag += '</embed>';
    }
    return flashTag;
}

FlashTag.prototype.write = function(doc)
{
    doc.write(this.toString());
	doc.close();
}

FlashTag.prototype.writeToElm = function(elm)
{
    if((typeof elm).toLowerCase()=='string'){
		elm=document.getElementById(elm);
	}
	if(elm){
		elm.innerHTML=this.toString();
	}
}

function FlashSerializer(useCdata)
{
    this.useCdata = useCdata;
}

FlashSerializer.prototype.serialize = function(args)
{
    var qs = new String();

    for (var i = 0; i < args.length; ++i)
    {
        switch(typeof(args[i]))
        {
            case 'undefined':
                qs += 't'+(i)+'=undf';
                break;
            case 'string':
                qs += 't'+(i)+'=str&d'+(i)+'='+escape(args[i]);
                break;
            case 'number':
                qs += 't'+(i)+'=num&d'+(i)+'='+escape(args[i]);
                break;
            case 'boolean':
                qs += 't'+(i)+'=bool&d'+(i)+'='+escape(args[i]);
                break;
            case 'object':
                if (args[i] == null)
                {
                    qs += 't'+(i)+'=null';
                }
                else if (args[i] instanceof Date)
                {
                    qs += 't'+(i)+'=date&d'+(i)+'='+escape(args[i].getTime());
                }
                else // array or object
                {
                    try
                    {
                        qs += 't'+(i)+'=xser&d'+(i)+'='+escape(this._serializeXML(args[i]));
                    }
                    catch (exception)
                    {
                        throw new Exception("FlashSerializationException",
                                            "The following error occurred during complex object serialization: " + exception.getMessage());
                    }
                }
                break;
            default:
                throw new Exception("FlashSerializationException",
                                    "You can only serialize strings, numbers, booleans, dates, objects, arrays, nulls, and undefined.");
        }

        if (i != (args.length - 1))
        {
            qs += '&';
        }
    }

    return qs;
}

FlashSerializer.prototype._serializeXML = function(obj)
{
    var doc = new Object();
    doc.xml = '<fp>'; 
    this._serializeNode(obj, doc, null);
    doc.xml += '</fp>'; 
    return doc.xml;
}

FlashSerializer.prototype._serializeNode = function(obj, doc, name)
{
    switch(typeof(obj))
    {
        case 'undefined':
            doc.xml += '<undf'+this._addName(name)+'/>';
            break;
        case 'string':
            doc.xml += '<str'+this._addName(name)+'>'+this._escapeXml(obj)+'</str>';
            break;
        case 'number':
            doc.xml += '<num'+this._addName(name)+'>'+obj+'</num>';
            break;
        case 'boolean':
            doc.xml += '<bool'+this._addName(name)+' val="'+obj+'"/>';
            break;
        case 'object':
            if (obj == null)
            {
                doc.xml += '<null'+this._addName(name)+'/>';
            }
            else if (obj instanceof Date)
            {
                doc.xml += '<date'+this._addName(name)+'>'+obj.getTime()+'</date>';
            }
            else if (obj instanceof Array)
            {
                doc.xml += '<array'+this._addName(name)+'>';
                for (var i = 0; i < obj.length; ++i)
                {
                    this._serializeNode(obj[i], doc, null);
                }
                doc.xml += '</array>';
            }
            else
            {
                doc.xml += '<obj'+this._addName(name)+'>';
                for (var n in obj)
                {
                    if (typeof(obj[n]) == 'function')
                        continue;
                    this._serializeNode(obj[n], doc, n);
                }
                doc.xml += '</obj>';
            }
            break;
        default:
            throw new Exception("FlashSerializationException",
                                "You can only serialize strings, numbers, booleans, objects, dates, arrays, nulls and undefined");
            break;
    }
}

FlashSerializer.prototype._addName= function(name)
{
    if (name != null)
    {
        return ' name="'+name+'"';
    }
    return '';
}

FlashSerializer.prototype._escapeXml = function(str)
{
    if (this.useCdata)
        return '<![CDATA['+str+']]>';
    else
        return str.replace(/&/g,'&amp;').replace(/</g,'&lt;');
}

function FlashProxy(uid, proxySwfName)
{
    this.uid = uid;
    this.proxySwfName = proxySwfName;
    this.flashSerializer = new FlashSerializer(false);
}

/**
 * Call a function in your Flash content.  Arguments should be:
 * 1. ActionScript function name to call,
 * 2. any number of additional arguments of type object,
 *    array, string, number, boolean, date, null, or undefined. 
 */
FlashProxy.prototype.call = function()
{
    if (arguments.length == 0)
    {
        throw new Exception("Flash Proxy Exception",
                            "The first argument should be the function name followed by any number of additional arguments.");
    }

    var qs = 'lcId=' + escape(this.uid) + '&functionName=' + escape(arguments[0]);

    if (arguments.length > 1)
    {
        var justArgs = new Array();
        for (var i = 1; i < arguments.length; ++i)
        {
            justArgs.push(arguments[i]);
        }
        qs += ('&' + this.flashSerializer.serialize(justArgs));
    }

    var divName = '_flash_proxy_' + this.uid;
    if(!document.getElementById(divName))
    {
        var newTarget = document.createElement("div");
        newTarget.id = divName;
        document.body.appendChild(newTarget);
    }
    var target = document.getElementById(divName);
    var ft = new FlashTag(this.proxySwfName, 1, 1);
    ft.setVersion('6,0,65,0');
    ft.setFlashvars(qs);
    target.innerHTML = ft.toString();
}

FlashProxy.callJS = function()
{
    var functionToCall = eval(arguments[0]);
    var argArray = new Array();
    for (var i = 1; i < arguments.length; ++i)
    {
        argArray.push(arguments[i]);
    }
    functionToCall.apply(functionToCall, argArray);
}

function getMovieObj(movieName) {
	if (navigator.appName.indexOf("Microsoft") != -1){
		return window[movieName];
	}else{
		return document[movieName];
	}
}
var flashTagIns = new FlashTag("", 1, 1);
function addFlash(src, w, h){
	try{
		var flashId=flashTagIns.setNew(src, w, h);
		flashTagIns.setVersion("7,0,19,0");
		flashTagIns.write(document);
		return getMovieObj(flashId);
	}catch(er){return undefined;}
}