/**
 * fulin-file.js
 * JavaScript of Fulin Toolbar for Firefox.
 * Created by Fulin on 2008/03/25
 * Copyright (c) 2008 Inspur Worldwide Services Ltd.
 * All Rights Reserved.
 */
 
var MTB_RDONLY      = 0x01;
var MTB_WRONLY      = 0x02;
var MTB_RDWR        = 0x04;
var MTB_CREATE_FILE = 0x08;
var MTB_APPEND      = 0x10;
var MTB_TRUNCATE    = 0x20;
var PERM_IROTH      = 420;

function SaveUrlToLocalFile(url,filename) { 
	
	var ioserv = Components.classes["@mozilla.org/network/io-service;1"] 
			   .getService(Components.interfaces.nsIIOService); 
			   
	var channel = ioserv.newChannel(url, 0, null); 
	
	var stream = channel.open(); 
	
	if (channel instanceof Components.interfaces.nsIHttpChannel && channel.responseStatus != 200) { 
		return ""; 
	}
	
	var bstream = Components.classes["@mozilla.org/binaryinputstream;1"] 
				.createInstance(Components.interfaces.nsIBinaryInputStream); 
	bstream.setInputStream(stream); 
//

	var dirService = Components.classes["@mozilla.org/file/directory_service;1"]
						.getService(Components.interfaces.nsIProperties);
	var localFile = dirService.get("ProfD", Components.interfaces.nsIFile);
	// append the file-string to our dir file-obj

	localFile.append("Simple");
	if( !localFile.exists() )
	localFile.create(1, parseInt("0700", 8) );

	localFile.append(filename);
	var outstream = Components.classes["@mozilla.org/network/file-output-stream;1"]
							.createInstance(Components.interfaces.nsIFileOutputStream);
	
	if( localFile.exists() )
		localFile.remove( false );

	outstream.init(localFile, MTB_WRONLY|MTB_CREATE_FILE, PERM_IROTH, 0);

//

  var size = 0; 
  while(size = bstream.available()) { 
    //file_data += bstream.readBytes(size); 
	outstream.write(bstream.readBytes(size),size);
	outstream.flush();
  } 
	bstream.close();
	stream.close();
	outstream.close();
  return localFile.path; 
}
// Get local file directory.
function MTB_getLocalFileDir(){
	var dirService = Components.classes["@mozilla.org/file/directory_service;1"]
						.getService(Components.interfaces.nsIProperties);
	var localFile = dirService.get("ProfD", Components.interfaces.nsIFile);
	// append the file-string to our dir file-obj
	
	localFile.append("Simple");
	if( !localFile.exists() )
		localFile.create(1, parseInt("0700", 8) );
		
	return localFile;
};
function MTB_getMainLocalFileDir(){
	var dirService = Components.classes["@mozilla.org/file/directory_service;1"]
						.getService(Components.interfaces.nsIProperties);
	var localFile = dirService.get("CurProcD", Components.interfaces.nsIFile);
	// append the file-string to our dir file-obj
	
	localFile.append("Simple");
	
	if( !localFile.exists() )
		localFile.create(1, parseInt("0700", 8) );
		
	return localFile;
};
function MTB_File(filename){
	
	var localfile =MTB_getMainLocalFileDir();
	
	localfile.append(filename);
	
	this.nowFile = localfile;
	
};

MTB_File.prototype.nowFile   = null;

MTB_File.prototype.nowStream = null;

MTB_File.prototype.tmpStream = null;

MTB_File.prototype.open = function(mode){

	if( this.nowFile == null )
		return false;
	if( this.nowStream != null )
		this.nowStream.close();
	
	switch(mode){
		case "r":
			if( !this.nowFile.exists() )
				return false;
			var instream = Components.classes["@mozilla.org/network/file-input-stream;1"]
									.createInstance(Components.interfaces.nsIFileInputStream);
				
			instream.init(this.nowFile, MTB_RDONLY, PERM_IROTH, 0)			
			
			this.tmpStream = instream;
			var sctinstream = Components.classes["@mozilla.org/scriptableinputstream;1"]
									.createInstance(Components.interfaces.nsIScriptableInputStream);
			sctinstream.init(this.tmpStream);
			this.nowStream = sctinstream;
			break;		
		case "w":
			if( !this.nowFile.exists() )
				return false;
			var outstream = Components.classes["@mozilla.org/network/file-output-stream;1"]
									.createInstance(Components.interfaces.nsIFileOutputStream);
			outstream.init(this.nowFile, MTB_RDWR, PERM_IROTH, 0);
			this.nowStream = outstream;
			break;
		case "w+":
			var outstream = Components.classes["@mozilla.org/network/file-output-stream;1"]
									.createInstance(Components.interfaces.nsIFileOutputStream);
			if( this.exists() )
				this.nowFile.remove( false );
			outstream.init(this.nowFile, MTB_WRONLY|MTB_CREATE_FILE, PERM_IROTH, 0);
			this.nowStream = outstream;
			break;
	}	
	return true;
};

MTB_File.prototype.read = function(count){
	if( this.nowStream == null )
		return;
	return this.nowStream.read(count);
};

MTB_File.prototype.write = function(str){
	if( this.nowStream == null )
		return;
	this.nowStream.write( str, str.length );
	this.nowStream.flush();
};

MTB_File.prototype.close = function(){
	if(this.nowStream != null)
		this.nowStream.close();
	if(this.tmpStream != null)
		this.tmpStream.close();
	this.nowFile = null;
	this.nowStream = null;
	this.tmpStream = null;
};

MTB_File.prototype.exists = function(){
	if( this.nowFile )
		return this.nowFile.exists();
	else
		return;
};

MTB_File.prototype.isFile = function(){
	if( this.nowFile )
		return this.nowFile.isFile();
	else
		return;
};

MTB_File.prototype.isDir = function(){
	if( this.nowFile )
		return this.nowFile.isDirectory();
	else
		return;
};

MTB_File.prototype.isExe = function(){
	if( this.nowFile )
		return this.nowFile.isExecutable();
	else
		return;
};

MTB_File.prototype.EOF = function(){
	if( this.nowStream == null )
		return;
	if( this.nowStream.available() > 0 )
		return false;
	else
		return;
};

MTB_File.prototype.fileSize = function(){
	if( this.nowFile )
		return this.nowFile.fileSize;
};
