#pragma once



#ifndef HDEVICE
#define HDEVICE unsigned long
#endif

typedef struct _DTL_WIRELESSNET_DEVICEINFO
{
	HDEVICE	hDevice;
	WCHAR	szName[MAX_PATH];
	GUID	guid;
	WCHAR	szHwid[MAX_PATH];
	BOOL	bIsWirelessNet;			//TRUEΪFALSEΪUSBӿ豸
	BOOL	bHasDriver;
	BOOL	bEnableUpdateBestDriver;
	BOOL	bEnableUpdateLastDriver;
	BOOL	bEnableUninstDriver;
}DTL_WIRELESSNET_DEVICEINFO,*PDTL_WIRELESSNET_DEVICEINFO;


typedef int (__stdcall* pfDTLGetWirelessNetArray)( PDTL_WIRELESSNET_DEVICEINFO* OUT ppInfoArr );


#define DTL_RESULT_ERROR		0	//װʧܣжʧ
#define DTL_RESULT_SUCESS		1	//װɹжسɹ
#define	DTL_RESULT_REBOOT		2	//װɹжسɹҪ


typedef int (__stdcall* pfDTLUninstallDriver)( HDEVICE IN hDevice );

typedef int (__stdcall* pfDTLUpdateBestDriver)( HDEVICE IN hDevice );

typedef int (__stdcall* pfDTLUpdateLastDriver)( HDEVICE IN hDevice );

typedef void (__stdcall* pfDTLFreeWirelessNetArray)();


class CDtlApiInterface
{
public:
	CDtlApiInterface(void);
	~CDtlApiInterface(void);

public:

	bool InitInterface(WCHAR* szMod);
	void CloseInterface();

	/*
	ػȡĸ
	-1ȡʧ
	0
	>0,
	*/
	int GetWirelessNetArray( PDTL_WIRELESSNET_DEVICEINFO* OUT ppInfoArr );

	/*ж*/
	int UninstallDriver( HDEVICE IN hDevice );

	/*װƼ*/
	int UpdateBestDriver( HDEVICE IN hDevice );

	/*װ*/
	int UpdateLastDriver( HDEVICE IN hDevice );

	/*ͷ*/
	void FreeWirelessNetArray();

private:

	pfDTLGetWirelessNetArray	m_pfDTLGetWirelessNetArray;
	pfDTLUninstallDriver		m_pfDTLUninstallDriver;
	pfDTLUpdateBestDriver		m_pfDTLUpdateBestDriver;
	pfDTLUpdateLastDriver		m_pfDTLUpdateLastDriver;
	pfDTLFreeWirelessNetArray	m_pfDTLFreeWirelessNetArray;

	HMODULE		m_hMod;
};
