#include "StdAfx.h"
#include "DtlApiInterface.h"

CDtlApiInterface::CDtlApiInterface(void)
{
	m_pfDTLGetWirelessNetArray	= NULL;
	m_pfDTLUninstallDriver		= NULL;
	m_pfDTLUpdateBestDriver		= NULL;
	m_pfDTLUpdateLastDriver		= NULL;
	m_pfDTLFreeWirelessNetArray	= NULL;
	m_hMod = NULL;
}

CDtlApiInterface::~CDtlApiInterface(void)
{
}

bool CDtlApiInterface::InitInterface(WCHAR* szMod)
{
	WCHAR szFile[MAX_PATH] = {0};
	WCHAR szWorkPath[MAX_PATH] = {0};

	if ( szMod && wcslen(szMod) > 0 )
	{
		wcscpy_s(szFile,MAX_PATH,szMod);
	}
	else
	{
		::GetModuleFileName(NULL,szFile,MAX_PATH);
		::PathAppend(szFile,L"..\\dtlapi.dll");
	}

	wcscpy_s(szWorkPath,MAX_PATH,szFile);
	::PathRemoveFileSpec(szWorkPath);
	::SetDllDirectory(szWorkPath);

	m_hMod = ::LoadLibrary(szFile);
	if ( NULL == m_hMod )
	{
		return false;
	}

	m_pfDTLGetWirelessNetArray	= (pfDTLGetWirelessNetArray)::GetProcAddress(m_hMod,"DTLGetWirelessNetArray");
	m_pfDTLUninstallDriver		= (pfDTLUninstallDriver)::GetProcAddress(m_hMod,"DTLUninstallDriver");
	m_pfDTLUpdateBestDriver		= (pfDTLUpdateBestDriver)::GetProcAddress(m_hMod,"DTLUpdateBestDriver");
	m_pfDTLUpdateLastDriver		= (pfDTLUpdateLastDriver)::GetProcAddress(m_hMod,"DTLUpdateLastDriver");
	m_pfDTLFreeWirelessNetArray	= (pfDTLFreeWirelessNetArray)::GetProcAddress(m_hMod,"DTLFreeWirelessNetArray");

	return true;
}

void CDtlApiInterface::CloseInterface()
{
	m_pfDTLGetWirelessNetArray	= NULL;
	m_pfDTLUninstallDriver		= NULL;
	m_pfDTLUpdateBestDriver		= NULL;
	m_pfDTLUpdateLastDriver		= NULL;
	m_pfDTLFreeWirelessNetArray	= NULL;
	if ( m_hMod )
	{
		::FreeLibrary(m_hMod);
		m_hMod = NULL;
	}
}

int CDtlApiInterface::GetWirelessNetArray( PDTL_WIRELESSNET_DEVICEINFO* OUT ppInfoArr )
{
	return m_pfDTLGetWirelessNetArray?m_pfDTLGetWirelessNetArray(ppInfoArr):-1;
}

int CDtlApiInterface::UninstallDriver( HDEVICE IN hDevice )
{
	return m_pfDTLUninstallDriver?m_pfDTLUninstallDriver(hDevice):DTL_RESULT_ERROR;
}

int CDtlApiInterface::UpdateBestDriver( HDEVICE IN hDevice )
{
	return m_pfDTLUpdateBestDriver?m_pfDTLUpdateBestDriver(hDevice):DTL_RESULT_ERROR;
}

int CDtlApiInterface::UpdateLastDriver( HDEVICE IN hDevice )
{
	return m_pfDTLUpdateLastDriver?m_pfDTLUpdateLastDriver(hDevice):DTL_RESULT_ERROR;
}

void CDtlApiInterface::FreeWirelessNetArray()
{
	m_pfDTLFreeWirelessNetArray?m_pfDTLFreeWirelessNetArray():NULL;
}